/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import java.util.List;
import org.apache.beam.sdk.io.mongodb.FindQuery;
import org.bson.BsonDocument;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class AutoValue_FindQuery
extends FindQuery {
    private final @Nullable BsonDocument filters;
    private final int limit;
    private final List<String> projection;

    private AutoValue_FindQuery(@Nullable BsonDocument filters, int limit, List<String> projection) {
        this.filters = filters;
        this.limit = limit;
        this.projection = projection;
    }

    @Override
    @Pure
    @Nullable BsonDocument filters() {
        return this.filters;
    }

    @Override
    @Pure
    int limit() {
        return this.limit;
    }

    @Override
    @Pure
    List<String> projection() {
        return this.projection;
    }

    public String toString() {
        return "FindQuery{filters=" + this.filters + ", limit=" + this.limit + ", projection=" + this.projection + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FindQuery) {
            FindQuery that = (FindQuery)o;
            return (this.filters == null ? that.filters() == null : this.filters.equals((Object)that.filters())) && this.limit == that.limit() && this.projection.equals(that.projection());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filters == null ? 0 : this.filters.hashCode();
        h$ *= 1000003;
        h$ ^= this.limit;
        h$ *= 1000003;
        return h$ ^= this.projection.hashCode();
    }

    @Override
    FindQuery.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FindQuery.Builder {
        private @Nullable BsonDocument filters;
        private Integer limit;
        private List<String> projection;

        Builder() {
        }

        private Builder(FindQuery source) {
            this.filters = source.filters();
            this.limit = source.limit();
            this.projection = source.projection();
        }

        @Override
        FindQuery.Builder setFilters(@Nullable BsonDocument filters) {
            this.filters = filters;
            return this;
        }

        @Override
        FindQuery.Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        FindQuery.Builder setProjection(List<String> projection) {
            if (projection == null) {
                throw new NullPointerException("Null projection");
            }
            this.projection = projection;
            return this;
        }

        @Override
        FindQuery build() {
            if (this.limit == null || this.projection == null) {
                StringBuilder missing = new StringBuilder();
                if (this.limit == null) {
                    missing.append(" limit");
                }
                if (this.projection == null) {
                    missing.append(" projection");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FindQuery(this.filters, this.limit, this.projection);
        }
    }
}

