/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.mongodb.AggregationQuery;
import org.apache.beam.sdk.io.mongodb.AutoValue_FindQuery;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbIO_Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbIO_Write;
import org.apache.beam.sdk.io.mongodb.FindQuery;
import org.apache.beam.sdk.io.mongodb.SSLUtils;
import org.apache.beam.sdk.io.mongodb.UpdateConfiguration;
import org.apache.beam.sdk.io.mongodb.UpdateField;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class MongoDbIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MongoDbIO.class);

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_MongoDbIO_Read.Builder().setMaxConnectionIdleTime(60000).setNumSplits(0).setBucketAuto(false).setSslEnabled(false).setIgnoreSSLCertificate(false).setSslInvalidHostNameAllowed(false).setQueryFn(FindQuery.create()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_MongoDbIO_Write.Builder().setMaxConnectionIdleTime(60000).setBatchSize(1024L).setSslEnabled(false).setIgnoreSSLCertificate(false).setSslInvalidHostNameAllowed(false).setOrdered(true).build();
    }

    private MongoDbIO() {
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MongoClientOptions.Builder getOptions(@UnknownKeyFor @NonNull @Initialized int maxConnectionIdleTime, @UnknownKeyFor @NonNull @Initialized boolean sslEnabled, @UnknownKeyFor @NonNull @Initialized boolean sslInvalidHostNameAllowed, @UnknownKeyFor @NonNull @Initialized boolean ignoreSSLCertificate) {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        optionsBuilder.maxConnectionIdleTime(maxConnectionIdleTime);
        if (sslEnabled) {
            optionsBuilder.sslEnabled(sslEnabled).sslInvalidHostNameAllowed(sslInvalidHostNameAllowed);
            if (ignoreSSLCertificate) {
                SSLContext sslContext = SSLUtils.ignoreSSLCertificate();
                optionsBuilder.sslContext(sslContext);
                optionsBuilder.socketFactory((SocketFactory)sslContext.getSocketFactory());
            }
        }
        return optionsBuilder;
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Document>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized String uri();

        abstract @UnknownKeyFor @NonNull @Initialized int maxConnectionIdleTime();

        abstract @UnknownKeyFor @NonNull @Initialized boolean sslEnabled();

        abstract @UnknownKeyFor @NonNull @Initialized boolean sslInvalidHostNameAllowed();

        abstract @UnknownKeyFor @NonNull @Initialized boolean ignoreSSLCertificate();

        abstract @UnknownKeyFor @NonNull @Initialized boolean ordered();

        abstract @Nullable @UnknownKeyFor @Initialized String database();

        abstract @Nullable @UnknownKeyFor @Initialized String collection();

        abstract @UnknownKeyFor @NonNull @Initialized long batchSize();

        abstract @Nullable @UnknownKeyFor @Initialized UpdateConfiguration updateConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withUri(@UnknownKeyFor @NonNull @Initialized String uri) {
            Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri can not be null");
            return this.builder().setUri(uri).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxConnectionIdleTime(@UnknownKeyFor @NonNull @Initialized int maxConnectionIdleTime) {
            return this.builder().setMaxConnectionIdleTime(maxConnectionIdleTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSSLEnabled(@UnknownKeyFor @NonNull @Initialized boolean sslEnabled) {
            return this.builder().setSslEnabled(sslEnabled).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSSLInvalidHostNameAllowed(@UnknownKeyFor @NonNull @Initialized boolean invalidHostNameAllowed) {
            return this.builder().setSslInvalidHostNameAllowed(invalidHostNameAllowed).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withOrdered(@UnknownKeyFor @NonNull @Initialized boolean ordered) {
            return this.builder().setOrdered(ordered).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withIgnoreSSLCertificate(@UnknownKeyFor @NonNull @Initialized boolean ignoreSSLCertificate) {
            return this.builder().setIgnoreSSLCertificate(ignoreSSLCertificate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"database can not be null");
            return this.builder().setDatabase(database).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withCollection(@UnknownKeyFor @NonNull @Initialized String collection) {
            Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"collection can not be null");
            return this.builder().setCollection(collection).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
            Preconditions.checkArgument((batchSize >= 0L ? 1 : 0) != 0, (String)"Batch size must be >= 0, but was %s", (long)batchSize);
            return this.builder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withUpdateConfiguration(@UnknownKeyFor @NonNull @Initialized UpdateConfiguration updateConfiguration) {
            return this.builder().setUpdateConfiguration(updateConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Document> input) {
            Preconditions.checkArgument((this.uri() != null ? 1 : 0) != 0, (Object)"withUri() is required");
            Preconditions.checkArgument((this.database() != null ? 1 : 0) != 0, (Object)"withDatabase() is required");
            Preconditions.checkArgument((this.collection() != null ? 1 : 0) != 0, (Object)"withCollection() is required");
            input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"uri", (String)this.uri()));
            builder.add(DisplayData.item((String)"maxConnectionIdleTime", (Integer)this.maxConnectionIdleTime()));
            builder.add(DisplayData.item((String)"sslEnable", (Boolean)this.sslEnabled()));
            builder.add(DisplayData.item((String)"sslInvalidHostNameAllowed", (Boolean)this.sslInvalidHostNameAllowed()));
            builder.add(DisplayData.item((String)"ignoreSSLCertificate", (Boolean)this.ignoreSSLCertificate()));
            builder.add(DisplayData.item((String)"ordered", (Boolean)this.ordered()));
            builder.add(DisplayData.item((String)"database", (String)this.database()));
            builder.add(DisplayData.item((String)"collection", (String)this.collection()));
            builder.add(DisplayData.item((String)"batchSize", (Long)this.batchSize()));
        }

        static class WriteFn
        extends DoFn<Document, Void> {
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private transient @UnknownKeyFor @NonNull @Initialized MongoClient client;
            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> batch;

            WriteFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void createMongoClient() {
                this.client = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.batch = new ArrayList<Document>();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
                this.batch.add(new Document((Map)ctx.element()));
                if ((long)this.batch.size() >= this.spec.batchSize()) {
                    this.flush();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() {
                this.flush();
            }

            private void flush() {
                if (this.batch.isEmpty()) {
                    return;
                }
                MongoDatabase mongoDatabase = this.client.getDatabase(this.spec.database());
                MongoCollection mongoCollection = mongoDatabase.getCollection(this.spec.collection());
                if (this.spec.updateConfiguration() == null) {
                    this.insertDocuments((MongoCollection<Document>)mongoCollection);
                } else {
                    this.updateDocuments((MongoCollection<Document>)mongoCollection);
                }
                this.batch.clear();
            }

            private void insertDocuments(@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document> mongoCollection) {
                block2: {
                    try {
                        mongoCollection.insertMany(this.batch, new InsertManyOptions().ordered(this.spec.ordered()));
                    }
                    catch (MongoBulkWriteException e) {
                        if (!this.spec.ordered()) break block2;
                        throw e;
                    }
                }
            }

            private void updateDocuments(@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document> mongoCollection) {
                block6: {
                    if (this.batch.isEmpty()) {
                        return;
                    }
                    ArrayList<UpdateOneModel> actions = new ArrayList<UpdateOneModel>();
                    @Nullable List<UpdateField> updateFields = this.spec.updateConfiguration().updateFields();
                    Map<String, List<UpdateField>> operatorFieldsMap = WriteFn.getOperatorFieldsMap(updateFields);
                    try {
                        for (Document doc : this.batch) {
                            Document updateDocument = new Document();
                            for (Map.Entry<String, List<UpdateField>> entry : operatorFieldsMap.entrySet()) {
                                Document updateSubDocument = new Document();
                                for (UpdateField field : entry.getValue()) {
                                    updateSubDocument.append(field.destField(), field.sourceField() == null ? doc : doc.get((Object)field.sourceField()));
                                }
                                updateDocument.append(entry.getKey(), (Object)updateSubDocument);
                            }
                            String findKey = Optional.ofNullable(this.spec.updateConfiguration().findKey()).orElse("_id");
                            Document findCriteria = new Document(findKey, doc.get((Object)this.spec.updateConfiguration().updateKey()));
                            UpdateOptions updateOptions = new UpdateOptions().upsert(this.spec.updateConfiguration().isUpsert());
                            actions.add(new UpdateOneModel((Bson)findCriteria, (Bson)updateDocument, updateOptions));
                        }
                        mongoCollection.bulkWrite(actions, new BulkWriteOptions().ordered(this.spec.ordered()));
                    }
                    catch (MongoBulkWriteException e) {
                        if (!this.spec.ordered()) break block6;
                        throw e;
                    }
                }
            }

            private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UpdateField>> getOperatorFieldsMap(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UpdateField> updateFields) {
                HashMap<String, List<UpdateField>> operatorFieldsMap = new HashMap<String, List<UpdateField>>();
                for (UpdateField field : updateFields) {
                    List<UpdateField> fields;
                    String updateOperator = field.updateOperator();
                    if (operatorFieldsMap.containsKey(updateOperator)) {
                        fields = (List)operatorFieldsMap.get(updateOperator);
                        fields.add(field);
                        operatorFieldsMap.put(updateOperator, fields);
                        continue;
                    }
                    fields = new ArrayList();
                    fields.add(field);
                    operatorFieldsMap.put(updateOperator, fields);
                }
                return operatorFieldsMap;
            }

            @DoFn.Teardown
            public void closeMongoClient() {
                this.client.close();
                this.client = null;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUri(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxConnectionIdleTime(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSslEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSslInvalidHostNameAllowed(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIgnoreSSLCertificate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOrdered(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabase(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCollection(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUpdateConfiguration(@UnknownKeyFor @NonNull @Initialized UpdateConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    private static class BoundedMongoDbReader
    extends BoundedSource.BoundedReader<Document> {
        private final @UnknownKeyFor @NonNull @Initialized BoundedMongoDbSource source;
        private @UnknownKeyFor @NonNull @Initialized MongoClient client;
        private @UnknownKeyFor @NonNull @Initialized MongoCursor<@UnknownKeyFor @NonNull @Initialized Document> cursor;
        private @UnknownKeyFor @NonNull @Initialized Document current;

        BoundedMongoDbReader(@UnknownKeyFor @NonNull @Initialized BoundedMongoDbSource source) {
            this.source = source;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() {
            Read spec = this.source.spec;
            this.client = this.createClient(spec);
            MongoDatabase mongoDatabase = this.client.getDatabase(spec.database());
            MongoCollection mongoCollection = mongoDatabase.getCollection(spec.collection());
            this.cursor = (MongoCursor)spec.queryFn().apply((Object)mongoCollection);
            return this.advance();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() {
            if (this.cursor.hasNext()) {
                this.current = (Document)this.cursor.next();
                return true;
            }
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedMongoDbSource getCurrentSource() {
            return this.source;
        }

        public @UnknownKeyFor @NonNull @Initialized Document getCurrent() {
            return this.current;
        }

        public void close() {
            try {
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Error closing MongoDB cursor", (Throwable)e);
            }
            try {
                this.client.close();
            }
            catch (Exception e) {
                LOG.warn("Error closing MongoDB client", (Throwable)e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized MongoClient createClient(@UnknownKeyFor @NonNull @Initialized Read spec) {
            return new MongoClient(new MongoClientURI(spec.uri(), MongoDbIO.getOptions(spec.maxConnectionIdleTime(), spec.sslEnabled(), spec.sslInvalidHostNameAllowed(), spec.ignoreSSLCertificate())));
        }
    }

    @VisibleForTesting
    static class BoundedMongoDbSource
    extends BoundedSource<Document> {
        private final @UnknownKeyFor @NonNull @Initialized Read spec;

        private BoundedMongoDbSource(@UnknownKeyFor @NonNull @Initialized Read spec) {
            this.spec = spec;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Document> getOutputCoder() {
            return SerializableCoder.of(Document.class);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized Document> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new BoundedMongoDbReader(this);
        }

        @UnknownKeyFor @NonNull @Initialized long getDocumentCount() {
            long l;
            MongoClient mongoClient = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));
            try {
                l = this.getDocumentCount(mongoClient, this.spec.database(), this.spec.collection());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        mongoClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return -1L;
                }
            }
            mongoClient.close();
            return l;
        }

        private @UnknownKeyFor @NonNull @Initialized long getDocumentCount(@UnknownKeyFor @NonNull @Initialized MongoClient mongoClient, @UnknownKeyFor @NonNull @Initialized String database, @UnknownKeyFor @NonNull @Initialized String collection) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database);
            BasicDBObject stat = new BasicDBObject();
            stat.append("collStats", (Object)collection);
            Document stats = mongoDatabase.runCommand((Bson)stat);
            return ((Number)stats.get((Object)"count", Number.class)).longValue();
        }

        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            try (MongoClient mongoClient = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));){
                long l = this.getEstimatedSizeBytes(mongoClient, this.spec.database(), this.spec.collection());
                return l;
            }
        }

        private @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized MongoClient mongoClient, @UnknownKeyFor @NonNull @Initialized String database, @UnknownKeyFor @NonNull @Initialized String collection) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database);
            BasicDBObject stat = new BasicDBObject();
            stat.append("collStats", (Object)collection);
            Document stats = mongoDatabase.runCommand((Bson)stat);
            return ((Number)stats.get((Object)"size", Number.class)).longValue();
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized Document>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try (MongoClient mongoClient = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));){
                MongoDatabase mongoDatabase = mongoClient.getDatabase(this.spec.database());
                ArrayList<BoundedSource<Document>> sources = new ArrayList<BoundedSource<Document>>();
                if (this.spec.queryFn().getClass() == AutoValue_FindQuery.class) {
                    Object splitVectorCommand;
                    List splitKeys;
                    if (this.spec.bucketAuto()) {
                        splitKeys = BoundedMongoDbSource.buildAutoBuckets(mongoDatabase, this.spec);
                    } else {
                        if (this.spec.numSplits() <= 0) {
                            LOG.debug("Split keys disabled, using a unique source");
                            List<BoundedSource<Document>> list = Collections.singletonList(this);
                            return list;
                        }
                        long estimatedSizeBytes = this.getEstimatedSizeBytes(mongoClient, this.spec.database(), this.spec.collection());
                        desiredBundleSizeBytes = estimatedSizeBytes / (long)this.spec.numSplits();
                        if (desiredBundleSizeBytes < 0x100000L) {
                            desiredBundleSizeBytes = 0x100000L;
                        }
                        splitVectorCommand = new BasicDBObject();
                        splitVectorCommand.append("splitVector", (Object)(this.spec.database() + "." + this.spec.collection()));
                        splitVectorCommand.append("keyPattern", (Object)new BasicDBObject().append("_id", (Object)1));
                        splitVectorCommand.append("force", (Object)false);
                        LOG.debug("Splitting in chunk of {} MB", (Object)(desiredBundleSizeBytes / 1024L / 1024L));
                        splitVectorCommand.append("maxChunkSize", (Object)(desiredBundleSizeBytes / 1024L / 1024L));
                        Document splitVectorCommandResult = mongoDatabase.runCommand((Bson)splitVectorCommand);
                        splitKeys = (List)splitVectorCommandResult.get((Object)"splitKeys");
                    }
                    if (splitKeys.size() < 1) {
                        LOG.debug("Split keys is low, using a unique source");
                        splitVectorCommand = Collections.singletonList(this);
                        return splitVectorCommand;
                    }
                    for (String shardFilter : BoundedMongoDbSource.splitKeysToFilters(splitKeys)) {
                        SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn = this.spec.queryFn();
                        BsonDocument filters = FindQuery.bson2BsonDocument((Bson)Document.parse((String)shardFilter));
                        FindQuery findQuery = (FindQuery)queryFn;
                        BsonDocument allFilters = FindQuery.bson2BsonDocument((Bson)(findQuery.filters() != null ? Filters.and((Bson[])new Bson[]{findQuery.filters(), filters}) : filters));
                        FindQuery queryWithFilter = findQuery.toBuilder().setFilters(allFilters).build();
                        LOG.debug("using filters: " + allFilters.toJson());
                        sources.add(new BoundedMongoDbSource(this.spec.withQueryFn(queryWithFilter)));
                    }
                } else {
                    SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn = this.spec.queryFn();
                    AggregationQuery aggregationQuery = (AggregationQuery)queryFn;
                    if (aggregationQuery.mongoDbPipeline().stream().anyMatch(s -> s.keySet().contains("$limit"))) {
                        List<BoundedSource<Document>> list = Collections.singletonList(this);
                        return list;
                    }
                    List<Document> splitKeys = BoundedMongoDbSource.buildAutoBuckets(mongoDatabase, this.spec);
                    for (BsonDocument shardFilter : BoundedMongoDbSource.splitKeysToMatch(splitKeys)) {
                        AggregationQuery queryWithBucket = aggregationQuery.toBuilder().setBucket(shardFilter).build();
                        sources.add(new BoundedMongoDbSource(this.spec.withQueryFn(queryWithBucket)));
                    }
                }
                ArrayList<BoundedSource<Document>> arrayList = sources;
                return arrayList;
            }
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> splitKeysToFilters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> splitKeys) {
            ArrayList<String> filters = new ArrayList<String>();
            String lowestBound = null;
            for (int i = 0; i < splitKeys.size(); ++i) {
                String rangeFilter;
                String splitKey = splitKeys.get(i).get((Object)"_id").toString();
                if (i == 0) {
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$lte:ObjectId(\"%s\")}}", splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                    if (splitKeys.size() == 1) {
                        rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\")}}", splitKey);
                        filters.add(String.format("%s ]}", rangeFilter));
                    }
                } else if (i == splitKeys.size() - 1) {
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\"),$lte:ObjectId(\"%s\")}}", lowestBound, splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\")}}", splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                } else {
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\"),$lte:ObjectId(\"%s\")}}", lowestBound, splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                }
                lowestBound = splitKey;
            }
            return filters;
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BsonDocument> splitKeysToMatch(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> splitKeys) {
            ArrayList<Bson> aggregates = new ArrayList<Bson>();
            ObjectId lowestBound = null;
            for (int i = 0; i < splitKeys.size(); ++i) {
                ObjectId splitKey = splitKeys.get(i).getObjectId((Object)"_id");
                if (i == 0) {
                    aggregates.add(Aggregates.match((Bson)Filters.lte((String)"_id", (Object)splitKey)));
                    if (splitKeys.size() == 1) {
                        aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)splitKey)})));
                    }
                } else if (i == splitKeys.size() - 1) {
                    aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)lowestBound), Filters.lte((String)"_id", (Object)splitKey)})));
                    aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)splitKey)})));
                } else {
                    aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)lowestBound), Filters.lte((String)"_id", (Object)splitKey)})));
                }
                lowestBound = splitKey;
            }
            return aggregates.stream().map(s -> s.toBsonDocument(BasicDBObject.class, MongoClient.getDefaultCodecRegistry())).collect(Collectors.toList());
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> buildAutoBuckets(@UnknownKeyFor @NonNull @Initialized MongoDatabase mongoDatabase, @UnknownKeyFor @NonNull @Initialized Read spec) {
            ArrayList<Document> splitKeys = new ArrayList<Document>();
            MongoCollection mongoCollection = mongoDatabase.getCollection(spec.collection());
            BsonDocument bucketAutoConfig = new BsonDocument();
            bucketAutoConfig.put("groupBy", (BsonValue)new BsonString("$_id"));
            bucketAutoConfig.put("buckets", (BsonValue)new BsonInt32(spec.numSplits() > 0 ? spec.numSplits() : 10));
            BsonDocument bucketAuto = new BsonDocument("$bucketAuto", (BsonValue)bucketAutoConfig);
            ArrayList<BsonDocument> aggregates = new ArrayList<BsonDocument>();
            aggregates.add(bucketAuto);
            AggregateIterable buckets = mongoCollection.aggregate(aggregates);
            for (Document bucket : buckets) {
                Document filter = new Document();
                filter.put("_id", ((Document)bucket.get((Object)"_id")).get((Object)"min"));
                splitKeys.add(filter);
            }
            return splitKeys;
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Document>> {
        abstract @Nullable @UnknownKeyFor @Initialized String uri();

        abstract @UnknownKeyFor @NonNull @Initialized int maxConnectionIdleTime();

        abstract @UnknownKeyFor @NonNull @Initialized boolean sslEnabled();

        abstract @UnknownKeyFor @NonNull @Initialized boolean sslInvalidHostNameAllowed();

        abstract @UnknownKeyFor @NonNull @Initialized boolean ignoreSSLCertificate();

        abstract @Nullable @UnknownKeyFor @Initialized String database();

        abstract @Nullable @UnknownKeyFor @Initialized String collection();

        abstract @UnknownKeyFor @NonNull @Initialized int numSplits();

        abstract @UnknownKeyFor @NonNull @Initialized boolean bucketAuto();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document>, @UnknownKeyFor @NonNull @Initialized MongoCursor<@UnknownKeyFor @NonNull @Initialized Document>> queryFn();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Read withUri(@UnknownKeyFor @NonNull @Initialized String uri) {
            Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"MongoDbIO.read().withUri(uri) called with null uri");
            return this.builder().setUri(uri).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxConnectionIdleTime(@UnknownKeyFor @NonNull @Initialized int maxConnectionIdleTime) {
            return this.builder().setMaxConnectionIdleTime(maxConnectionIdleTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSSLEnabled(@UnknownKeyFor @NonNull @Initialized boolean sslEnabled) {
            return this.builder().setSslEnabled(sslEnabled).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSSLInvalidHostNameAllowed(@UnknownKeyFor @NonNull @Initialized boolean invalidHostNameAllowed) {
            return this.builder().setSslInvalidHostNameAllowed(invalidHostNameAllowed).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withIgnoreSSLCertificate(@UnknownKeyFor @NonNull @Initialized boolean ignoreSSLCertificate) {
            return this.builder().setIgnoreSSLCertificate(ignoreSSLCertificate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"database can not be null");
            return this.builder().setDatabase(database).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCollection(@UnknownKeyFor @NonNull @Initialized String collection) {
            Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"collection can not be null");
            return this.builder().setCollection(collection).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withNumSplits(@UnknownKeyFor @NonNull @Initialized int numSplits) {
            Preconditions.checkArgument((numSplits >= 0 ? 1 : 0) != 0, (String)"invalid num_splits: must be >= 0, but was %s", (int)numSplits);
            return this.builder().setNumSplits(numSplits).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withBucketAuto(@UnknownKeyFor @NonNull @Initialized boolean bucketAuto) {
            return this.builder().setBucketAuto(bucketAuto).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQueryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document>, @UnknownKeyFor @NonNull @Initialized MongoCursor<@UnknownKeyFor @NonNull @Initialized Document>> queryBuilderFn) {
            return this.builder().setQueryFn(queryBuilderFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Document> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.uri() != null ? 1 : 0) != 0, (Object)"withUri() is required");
            Preconditions.checkArgument((this.database() != null ? 1 : 0) != 0, (Object)"withDatabase() is required");
            Preconditions.checkArgument((this.collection() != null ? 1 : 0) != 0, (Object)"withCollection() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedMongoDbSource(this)));
        }

        public @UnknownKeyFor @NonNull @Initialized long getDocumentCount() {
            Preconditions.checkArgument((this.uri() != null ? 1 : 0) != 0, (Object)"withUri() is required");
            Preconditions.checkArgument((this.database() != null ? 1 : 0) != 0, (Object)"withDatabase() is required");
            Preconditions.checkArgument((this.collection() != null ? 1 : 0) != 0, (Object)"withCollection() is required");
            return new BoundedMongoDbSource(this).getDocumentCount();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"uri", (String)this.uri()));
            builder.add(DisplayData.item((String)"maxConnectionIdleTime", (Integer)this.maxConnectionIdleTime()));
            builder.add(DisplayData.item((String)"sslEnabled", (Boolean)this.sslEnabled()));
            builder.add(DisplayData.item((String)"sslInvalidHostNameAllowed", (Boolean)this.sslInvalidHostNameAllowed()));
            builder.add(DisplayData.item((String)"ignoreSSLCertificate", (Boolean)this.ignoreSSLCertificate()));
            builder.add(DisplayData.item((String)"database", (String)this.database()));
            builder.add(DisplayData.item((String)"collection", (String)this.collection()));
            builder.add(DisplayData.item((String)"numSplit", (Integer)this.numSplits()));
            builder.add(DisplayData.item((String)"bucketAuto", (Boolean)this.bucketAuto()));
            builder.add(DisplayData.item((String)"queryFn", (String)this.queryFn().toString()));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUri(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxConnectionIdleTime(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSslEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSslInvalidHostNameAllowed(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIgnoreSSLCertificate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabase(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCollection(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNumSplits(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBucketAuto(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document>, @UnknownKeyFor @NonNull @Initialized MongoCursor<@UnknownKeyFor @NonNull @Initialized Document>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

