/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.mongodb.AutoValue_UpdateConfiguration;
import org.apache.beam.sdk.io.mongodb.UpdateField;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
@AutoValue
public abstract class UpdateConfiguration
implements Serializable {
    abstract @Nullable String updateKey();

    abstract @Nullable List<UpdateField> updateFields();

    abstract boolean isUpsert();

    private static Builder builder() {
        return new AutoValue_UpdateConfiguration.Builder().setUpdateFields(Collections.emptyList()).setIsUpsert(false);
    }

    abstract Builder toBuilder();

    public static UpdateConfiguration create() {
        return UpdateConfiguration.builder().build();
    }

    public UpdateConfiguration withUpdateFields(UpdateField ... updateFields) {
        return this.toBuilder().setUpdateFields(Arrays.asList(updateFields)).build();
    }

    public UpdateConfiguration withUpdateKey(String updateKey) {
        return this.toBuilder().setUpdateKey(updateKey).build();
    }

    public UpdateConfiguration withIsUpsert(boolean isUpsert) {
        return this.toBuilder().setIsUpsert(isUpsert).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setUpdateFields(@Nullable List<UpdateField> var1);

        abstract Builder setUpdateKey(@Nullable String var1);

        abstract Builder setIsUpsert(boolean var1);

        abstract UpdateConfiguration build();
    }
}

