/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_ConnectionConfiguration;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_Write;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.mongodb.repackaged.com.google.common.base.Preconditions;
import org.bson.types.ObjectId;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class MongoDbGridFSIO {
    private static final Parser<String> TEXT_PARSER = (input, callback) -> {
        Instant time = new Instant(input.getUploadDate().getTime());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                callback.output(line, time);
                line = reader.readLine();
            }
        }
    };

    public static Read<String> read() {
        return new AutoValue_MongoDbGridFSIO_Read.Builder<String>().setParser(TEXT_PARSER).setCoder((Coder<String>)StringUtf8Coder.of()).setConnectionConfiguration(ConnectionConfiguration.create()).setSkew(Duration.ZERO).build();
    }

    public static Write<String> write() {
        return new AutoValue_MongoDbGridFSIO_Write.Builder().setConnectionConfiguration(ConnectionConfiguration.create()).setWriteFn((output, outStream) -> {
            outStream.write(output.getBytes(StandardCharsets.UTF_8));
            outStream.write(10);
        }).build();
    }

    public static <T> Write<T> write(WriteFn<T> fn) {
        return new AutoValue_MongoDbGridFSIO_Write.Builder<T>().setWriteFn(fn).setConnectionConfiguration(ConnectionConfiguration.create()).build();
    }

    private static class GridFsWriteFn<T>
    extends DoFn<T, Void> {
        private final Write<T> spec;
        private transient Mongo mongo;
        private transient GridFS gridfs;
        private transient GridFSInputFile gridFsFile;
        private transient OutputStream outputStream;

        public GridFsWriteFn(Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.mongo = this.spec.connectionConfiguration().setupMongo();
            this.gridfs = this.spec.connectionConfiguration().setupGridFS(this.mongo);
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.gridFsFile = this.gridfs.createFile(this.spec.filename());
            if (this.spec.chunkSize() != null) {
                this.gridFsFile.setChunkSize(this.spec.chunkSize().longValue());
            }
            this.outputStream = this.gridFsFile.getOutputStream();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            Object record = context.element();
            this.spec.writeFn().write(record, this.outputStream);
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            if (this.gridFsFile != null) {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
                this.gridFsFile = null;
            }
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            try {
                if (this.gridFsFile != null) {
                    this.outputStream.flush();
                    this.outputStream.close();
                    this.outputStream = null;
                    this.gridFsFile = null;
                }
            }
            finally {
                if (this.mongo != null) {
                    this.mongo.close();
                    this.mongo = null;
                    this.gridfs = null;
                }
            }
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        abstract ConnectionConfiguration connectionConfiguration();

        @Nullable
        abstract Long chunkSize();

        abstract WriteFn<T> writeFn();

        @Nullable
        abstract String filename();

        abstract Builder<T> toBuilder();

        public Write<T> withUri(String uri) {
            Preconditions.checkNotNull(uri);
            ConnectionConfiguration config = ConnectionConfiguration.create(uri, this.connectionConfiguration().database(), this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public Write<T> withDatabase(String database) {
            Preconditions.checkNotNull(database);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), database, this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public Write<T> withBucket(String bucket) {
            Preconditions.checkNotNull(bucket);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), this.connectionConfiguration().database(), bucket);
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public Write<T> withFilename(String filename) {
            Preconditions.checkNotNull(filename);
            return this.toBuilder().setFilename(filename).build();
        }

        public Write<T> withChunkSize(Long chunkSize) {
            Preconditions.checkNotNull(chunkSize);
            Preconditions.checkArgument(chunkSize > 1L, "Chunk Size must be greater than 1", (Object)chunkSize);
            return this.toBuilder().setChunkSize(chunkSize).build();
        }

        public void validate(T input) {
            Preconditions.checkNotNull(this.filename(), "filename");
            Preconditions.checkNotNull(this.writeFn(), "writeFn");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"uri", (String)this.connectionConfiguration().uri()));
            builder.addIfNotNull(DisplayData.item((String)"database", (String)this.connectionConfiguration().database()));
            builder.addIfNotNull(DisplayData.item((String)"bucket", (String)this.connectionConfiguration().bucket()));
            builder.addIfNotNull(DisplayData.item((String)"chunkSize", (Long)this.chunkSize()));
            builder.addIfNotNull(DisplayData.item((String)"filename", (String)this.filename()));
        }

        public PDone expand(PCollection<T> input) {
            input.apply((PTransform)ParDo.of(new GridFsWriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder<T> setFilename(String var1);

            abstract Builder<T> setChunkSize(Long var1);

            abstract Builder<T> setWriteFn(WriteFn<T> var1);

            abstract Write<T> build();
        }
    }

    public static interface WriteFn<T>
    extends Serializable {
        public void write(T var1, OutputStream var2) throws IOException;
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract ConnectionConfiguration connectionConfiguration();

        @Nullable
        abstract Parser<T> parser();

        @Nullable
        abstract Coder<T> coder();

        @Nullable
        abstract Duration skew();

        @Nullable
        abstract String filter();

        abstract Builder<T> toBuilder();

        public Read<T> withUri(String uri) {
            Preconditions.checkNotNull(uri);
            ConnectionConfiguration config = ConnectionConfiguration.create(uri, this.connectionConfiguration().database(), this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public Read<T> withDatabase(String database) {
            Preconditions.checkNotNull(database);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), database, this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public Read<T> withBucket(String bucket) {
            Preconditions.checkNotNull(bucket);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), this.connectionConfiguration().database(), bucket);
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public <X> Read<X> withParser(Parser<X> parser) {
            Preconditions.checkNotNull(parser);
            Builder<X> builder = this.toBuilder();
            return builder.setParser(parser).setCoder(null).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkNotNull(coder);
            return this.toBuilder().setCoder(coder).build();
        }

        public Read<T> withSkew(Duration skew) {
            return this.toBuilder().setSkew(skew == null ? Duration.ZERO : skew).build();
        }

        public Read<T> withFilter(String filter) {
            return this.toBuilder().setFilter(filter).build();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"uri", (String)this.connectionConfiguration().uri()));
            builder.addIfNotNull(DisplayData.item((String)"database", (String)this.connectionConfiguration().database()));
            builder.addIfNotNull(DisplayData.item((String)"bucket", (String)this.connectionConfiguration().bucket()));
            builder.addIfNotNull(DisplayData.item((String)"parser", (String)this.parser().getClass().getName()));
            builder.addIfNotNull(DisplayData.item((String)"coder", (String)this.coder().getClass().getName()));
            builder.addIfNotNull(DisplayData.item((String)"skew", (Duration)this.skew()));
            builder.addIfNotNull(DisplayData.item((String)"filter", (String)this.filter()));
        }

        public PCollection<T> expand(PBegin input) {
            final BoundedGridFSSource source = new BoundedGridFSSource(this, null);
            Read.Bounded objectIds = org.apache.beam.sdk.io.Read.from((BoundedSource)source);
            PCollection output = (PCollection)((PCollection)input.getPipeline().apply((PTransform)objectIds)).apply((PTransform)ParDo.of((DoFn)new DoFn<ObjectId, T>(){
                Mongo mongo;
                GridFS gridfs;

                @DoFn.Setup
                public void setup() {
                    this.mongo = source.spec.connectionConfiguration().setupMongo();
                    this.gridfs = source.spec.connectionConfiguration().setupGridFS(this.mongo);
                }

                @DoFn.Teardown
                public void teardown() {
                    this.mongo.close();
                }

                @DoFn.ProcessElement
                public void processElement(final DoFn.ProcessContext c) throws IOException {
                    ObjectId oid = (ObjectId)c.element();
                    GridFSDBFile file = this.gridfs.find(oid);
                    this.parser().parse(file, new ParserCallback<T>(){

                        @Override
                        public void output(T output, Instant timestamp) {
                            Preconditions.checkNotNull(timestamp);
                            c.outputWithTimestamp(output, timestamp);
                        }

                        @Override
                        public void output(T output) {
                            c.output(output);
                        }
                    });
                }

                public Duration getAllowedTimestampSkew() {
                    return this.skew();
                }
            }));
            if (this.coder() != null) {
                output.setCoder(this.coder());
            }
            return output;
        }

        protected static class BoundedGridFSSource
        extends BoundedSource<ObjectId> {
            private Read<?> spec;
            @Nullable
            private List<ObjectId> objectIds;

            BoundedGridFSSource(Read<?> spec, List<ObjectId> objectIds) {
                this.spec = spec;
                this.objectIds = objectIds;
            }

            private DBCursor createCursor(GridFS gridfs) {
                if (this.spec.filter() != null) {
                    DBObject query = (DBObject)JSON.parse((String)this.spec.filter());
                    return gridfs.getFileList(query).sort(null);
                }
                return gridfs.getFileList().sort(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<? extends BoundedSource<ObjectId>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
                try (Mongo mongo = this.spec.connectionConfiguration().setupMongo();){
                    GridFS gridfs = this.spec.connectionConfiguration().setupGridFS(mongo);
                    DBCursor cursor = this.createCursor(gridfs);
                    long size = 0L;
                    ArrayList<BoundedGridFSSource> list = new ArrayList<BoundedGridFSSource>();
                    ArrayList<Object> objects = new ArrayList<ObjectId>();
                    while (cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)cursor.next();
                        long len = file.getLength();
                        if (size + len > desiredBundleSizeBytes && !objects.isEmpty()) {
                            list.add(new BoundedGridFSSource(this.spec, objects));
                            size = 0L;
                            objects = new ArrayList();
                        }
                        objects.add((ObjectId)file.getId());
                        size += len;
                    }
                    if (!objects.isEmpty() || list.isEmpty()) {
                        list.add(new BoundedGridFSSource(this.spec, objects));
                    }
                    ArrayList<BoundedGridFSSource> arrayList = list;
                    return arrayList;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
                try (Mongo mongo = this.spec.connectionConfiguration().setupMongo();){
                    GridFS gridfs = this.spec.connectionConfiguration().setupGridFS(mongo);
                    DBCursor cursor = this.createCursor(gridfs);
                    long size = 0L;
                    while (cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)cursor.next();
                        size += file.getLength();
                    }
                    long l = size;
                    return l;
                }
            }

            public BoundedSource.BoundedReader<ObjectId> createReader(PipelineOptions options) throws IOException {
                return new GridFSReader(this, this.objectIds);
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                this.spec.populateDisplayData(builder);
            }

            public Coder<ObjectId> getOutputCoder() {
                return SerializableCoder.of(ObjectId.class);
            }

            static class GridFSReader
            extends BoundedSource.BoundedReader<ObjectId> {
                final BoundedGridFSSource source;
                @Nullable
                final List<ObjectId> objects;
                Mongo mongo;
                DBCursor cursor;
                Iterator<ObjectId> iterator;
                ObjectId current;

                GridFSReader(BoundedGridFSSource source, List<ObjectId> objects) {
                    this.source = source;
                    this.objects = objects;
                }

                public BoundedSource<ObjectId> getCurrentSource() {
                    return this.source;
                }

                public boolean start() throws IOException {
                    if (this.objects == null) {
                        this.mongo = this.source.spec.connectionConfiguration().setupMongo();
                        GridFS gridfs = this.source.spec.connectionConfiguration().setupGridFS(this.mongo);
                        this.cursor = this.source.createCursor(gridfs);
                    } else {
                        this.iterator = this.objects.iterator();
                    }
                    return this.advance();
                }

                public boolean advance() throws IOException {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        this.current = this.iterator.next();
                        return true;
                    }
                    if (this.cursor != null && this.cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)this.cursor.next();
                        this.current = (ObjectId)file.getId();
                        return true;
                    }
                    this.current = null;
                    return false;
                }

                public ObjectId getCurrent() throws NoSuchElementException {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    return this.current;
                }

                public Instant getCurrentTimestamp() throws NoSuchElementException {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    long time = this.current.getTimestamp();
                    return new Instant(time *= 1000L);
                }

                public void close() throws IOException {
                    if (this.mongo != null) {
                        this.mongo.close();
                    }
                }
            }
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder<T> setParser(Parser<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setSkew(Duration var1);

            abstract Builder<T> setFilter(String var1);

            abstract Read<T> build();
        }
    }

    @AutoValue
    public static abstract class ConnectionConfiguration
    implements Serializable {
        @Nullable
        abstract String uri();

        @Nullable
        abstract String database();

        @Nullable
        abstract String bucket();

        static ConnectionConfiguration create() {
            return new AutoValue_MongoDbGridFSIO_ConnectionConfiguration(null, null, null);
        }

        static ConnectionConfiguration create(String uri, String database, String bucket) {
            return new AutoValue_MongoDbGridFSIO_ConnectionConfiguration(uri, database, bucket);
        }

        Mongo setupMongo() {
            return this.uri() == null ? new Mongo() : new Mongo(new MongoURI(this.uri()));
        }

        GridFS setupGridFS(Mongo mongo) {
            DB db = this.database() == null ? mongo.getDB("gridfs") : mongo.getDB(this.database());
            return this.bucket() == null ? new GridFS(db) : new GridFS(db, this.bucket());
        }
    }

    public static interface Parser<T>
    extends Serializable {
        public void parse(GridFSDBFile var1, ParserCallback<T> var2) throws IOException;
    }

    public static interface ParserCallback<T>
    extends Serializable {
        public void output(T var1);

        public void output(T var1, Instant var2);
    }
}

