/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.mongodb.AutoValue_AggregationQuery;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.bson.BsonDocument;
import org.bson.Document;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
@AutoValue
public abstract class AggregationQuery
implements SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> {
    abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BsonDocument> mongoDbPipeline();

    @Nullable
    abstract @UnknownKeyFor @NonNull @Initialized BsonDocument bucket();

    private static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_AggregationQuery.Builder().setMongoDbPipeline(new ArrayList<BsonDocument>());
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized AggregationQuery create() {
        return AggregationQuery.builder().build();
    }

    public @UnknownKeyFor @NonNull @Initialized AggregationQuery withMongoDbPipeline(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BsonDocument> mongoDbPipeline) {
        return this.toBuilder().setMongoDbPipeline(mongoDbPipeline).build();
    }

    public @UnknownKeyFor @NonNull @Initialized MongoCursor<@UnknownKeyFor @NonNull @Initialized Document> apply(@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document> collection) {
        if (this.bucket() != null) {
            if (this.mongoDbPipeline().size() == 1) {
                this.mongoDbPipeline().add(this.bucket());
            } else {
                this.mongoDbPipeline().set(this.mongoDbPipeline().size() - 1, this.bucket());
            }
        }
        return collection.aggregate(this.mongoDbPipeline()).iterator();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMongoDbPipeline(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BsonDocument> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setBucket(@UnknownKeyFor @NonNull @Initialized BsonDocument var1);

        abstract @UnknownKeyFor @NonNull @Initialized AggregationQuery build();
    }
}

