/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Projections;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.mongodb.AutoValue_FindQuery;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
@AutoValue
public abstract class FindQuery
implements SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> {
    abstract @Nullable BsonDocument filters();

    abstract int limit();

    abstract List<String> projection();

    private static Builder builder() {
        return new AutoValue_FindQuery.Builder().setLimit(0).setProjection(Collections.emptyList()).setFilters(new BsonDocument());
    }

    abstract Builder toBuilder();

    public static FindQuery create() {
        return FindQuery.builder().build();
    }

    private FindQuery withFilters(BsonDocument filters) {
        return this.toBuilder().setFilters(filters).build();
    }

    static BsonDocument bson2BsonDocument(Bson filters) {
        return filters.toBsonDocument(BasicDBObject.class, MongoClient.getDefaultCodecRegistry());
    }

    public FindQuery withFilters(Bson filters) {
        return this.withFilters(FindQuery.bson2BsonDocument(filters));
    }

    public FindQuery withLimit(int limit) {
        return this.toBuilder().setLimit(limit).build();
    }

    public FindQuery withProjection(List<String> projection) {
        Preconditions.checkArgument((projection != null ? 1 : 0) != 0, (Object)"projection can not be null");
        return this.toBuilder().setProjection(projection).build();
    }

    public MongoCursor<Document> apply(MongoCollection<Document> collection) {
        return collection.find().filter((Bson)this.filters()).limit(this.limit()).projection(Projections.include(this.projection())).iterator();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setFilters(@Nullable BsonDocument var1);

        abstract Builder setLimit(int var1);

        abstract Builder setProjection(List<String> var1);

        abstract FindQuery build();
    }
}

