/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;

final class AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration
extends KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration {
    private final String format;
    private final String topic;
    private final String bootstrapServers;
    private final Map<String, String> producerConfigUpdates;
    private final ErrorHandling errorHandling;

    private AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration(String format, String topic, String bootstrapServers, @Nullable Map<String, String> producerConfigUpdates, @Nullable ErrorHandling errorHandling) {
        this.format = format;
        this.topic = topic;
        this.bootstrapServers = bootstrapServers;
        this.producerConfigUpdates = producerConfigUpdates;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Kafka. Valid options are: RAW,JSON,AVRO")
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    @SchemaFieldDescription(value="A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping\u2014this list only impacts the initial hosts used to discover the full set of servers. | Format: host1:port1,host2:port2,...")
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="A list of key-value pairs that act as configuration parameters for Kafka producers. Most of these configurations will not be needed, but if you need to customize your Kafka producer, you may use this. See a detailed list: https://docs.confluent.io/platform/current/installation/configuration/producer-configs.html")
    public Map<String, String> getProducerConfigUpdates() {
        return this.producerConfigUpdates;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "KafkaWriteSchemaTransformConfiguration{format=" + this.format + ", topic=" + this.topic + ", bootstrapServers=" + this.bootstrapServers + ", producerConfigUpdates=" + this.producerConfigUpdates + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration) {
            KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration that = (KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && this.topic.equals(that.getTopic()) && this.bootstrapServers.equals(that.getBootstrapServers()) && (this.producerConfigUpdates == null ? that.getProducerConfigUpdates() == null : this.producerConfigUpdates.equals(that.getProducerConfigUpdates())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.bootstrapServers.hashCode();
        h$ *= 1000003;
        h$ ^= this.producerConfigUpdates == null ? 0 : this.producerConfigUpdates.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder {
        private String format;
        private String topic;
        private String bootstrapServers;
        private Map<String, String> producerConfigUpdates;
        private ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setBootstrapServers(String bootstrapServers) {
            if (bootstrapServers == null) {
                throw new NullPointerException("Null bootstrapServers");
            }
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setProducerConfigUpdates(Map<String, String> producerConfigUpdates) {
            this.producerConfigUpdates = producerConfigUpdates;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration build() {
            if (this.format == null || this.topic == null || this.bootstrapServers == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.topic == null) {
                    missing.append(" topic");
                }
                if (this.bootstrapServers == null) {
                    missing.append(" bootstrapServers");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration(this.format, this.topic, this.bootstrapServers, this.producerConfigUpdates, this.errorHandling);
        }
    }
}

