/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class KafkaIOReadImplementationCompatibility {
    KafkaIOReadImplementationCompatibility() {
    }

    static @UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementationCompatibilityResult getCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> read) {
        HashMultimap notSupportedImplementationsWithProperties = HashMultimap.create();
        for (KafkaIOReadProperties property : KafkaIOReadProperties.values()) {
            Object currentValue;
            EnumSet<KafkaIOReadImplementation> notSupportedImplementations = EnumSet.complementOf(EnumSet.copyOf(property.supportedImplementations));
            if (notSupportedImplementations.isEmpty()) continue;
            Object defaultValue = property.getDefaultValue();
            try {
                currentValue = property.getterMethod.invoke((Object)read, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Should not happen", e);
            }
            if (Objects.equals(defaultValue, currentValue)) continue;
            for (KafkaIOReadImplementation notSupportedImplementation : notSupportedImplementations) {
                notSupportedImplementationsWithProperties.put((Object)notSupportedImplementation, (Object)property);
            }
        }
        if (EnumSet.allOf(KafkaIOReadImplementation.class).equals(notSupportedImplementationsWithProperties.keySet())) {
            throw new IllegalStateException("There is no Kafka read implementation that supports every configured property! Not supported implementations with the associated properties: " + notSupportedImplementationsWithProperties);
        }
        return new KafkaIOReadImplementationCompatibilityResult((Multimap)notSupportedImplementationsWithProperties);
    }

    static class KafkaIOReadImplementationCompatibilityException
    extends IllegalStateException {
        private final @UnknownKeyFor @NonNull @Initialized ImmutableSortedSet<@UnknownKeyFor @NonNull @Initialized KafkaIOReadProperties> conflictingProperties;

        private KafkaIOReadImplementationCompatibilityException(@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation selectedImplementation, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized KafkaIOReadProperties> conflictingProperties) {
            super("The current Kafka read configuration isn't supported by the " + (Object)((Object)selectedImplementation) + " read implementation! Conflicting properties: " + conflictingProperties);
            this.conflictingProperties = ImmutableSortedSet.copyOf(conflictingProperties);
        }

        @UnknownKeyFor @NonNull @Initialized ImmutableSortedSet<@UnknownKeyFor @NonNull @Initialized KafkaIOReadProperties> getConflictingProperties() {
            return this.conflictingProperties;
        }
    }

    static class KafkaIOReadImplementationCompatibilityResult {
        private final @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation, @UnknownKeyFor @NonNull @Initialized KafkaIOReadProperties> notSupported;

        private KafkaIOReadImplementationCompatibilityResult(@UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation, @UnknownKeyFor @NonNull @Initialized KafkaIOReadProperties> notSupportedImplementationsWithAssociatedProperties) {
            this.notSupported = notSupportedImplementationsWithAssociatedProperties;
        }

        @UnknownKeyFor @NonNull @Initialized boolean supports(@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation implementation) {
            return !this.notSupported.containsKey((Object)implementation);
        }

        @UnknownKeyFor @NonNull @Initialized boolean supportsOnly(@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation implementation) {
            return EnumSet.complementOf(EnumSet.of(implementation)).equals(this.notSupported.keySet());
        }

        void checkSupport(@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation selectedImplementation) {
            if (!this.supports(selectedImplementation)) {
                throw new KafkaIOReadImplementationCompatibilityException(selectedImplementation, this.notSupported.get((Object)selectedImplementation));
            }
        }
    }

    @VisibleForTesting
    static enum KafkaIOReadProperties {
        CONSUMER_CONFIG,
        TOPICS,
        TOPIC_PARTITIONS,
        KEY_CODER,
        VALUE_CODER,
        CONSUMER_FACTORY_FN,
        WATERMARK_FN(KafkaIOReadImplementation.LEGACY),
        MAX_NUM_RECORDS(new KafkaIOReadImplementation[]{KafkaIOReadImplementation.LEGACY}){

            @Override
            @UnknownKeyFor @NonNull @Initialized Object getDefaultValue() {
                return Long.MAX_VALUE;
            }
        }
        ,
        MAX_READ_TIME(KafkaIOReadImplementation.LEGACY),
        START_READ_TIME,
        STOP_READ_TIME(KafkaIOReadImplementation.SDF),
        COMMIT_OFFSETS_IN_FINALIZE_ENABLED{

            @Override
            @UnknownKeyFor @NonNull @Initialized Object getDefaultValue() {
                return false;
            }
        }
        ,
        DYNAMIC_READ(new KafkaIOReadImplementation[]{KafkaIOReadImplementation.SDF}){

            @Override
            @UnknownKeyFor @NonNull @Initialized Object getDefaultValue() {
                return false;
            }
        }
        ,
        WATCH_TOPIC_PARTITION_DURATION(KafkaIOReadImplementation.SDF),
        TIMESTAMP_POLICY_FACTORY,
        OFFSET_CONSUMER_CONFIG,
        KEY_DESERIALIZER_PROVIDER,
        VALUE_DESERIALIZER_PROVIDER,
        CHECK_STOP_READING_FN(KafkaIOReadImplementation.SDF);

        @Nonnull
        private final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized KafkaIOReadImplementation> supportedImplementations;
        @Nonnull
        private final @UnknownKeyFor @NonNull @Initialized Method getterMethod;

        private KafkaIOReadProperties() {
            this(KafkaIOReadImplementation.values());
        }

        private KafkaIOReadProperties(KafkaIOReadImplementation ... supportedImplementations) {
            this.supportedImplementations = Sets.immutableEnumSet(Arrays.asList(supportedImplementations));
            this.getterMethod = KafkaIOReadProperties.findGetterMethod(this);
        }

        private static @UnknownKeyFor @NonNull @Initialized Method findGetterMethod(@UnderInitialization(value=Enum.class) @UnknownKeyFor @NonNull KafkaIOReadProperties property) {
            String propertyNameInUpperCamel = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, property.name());
            try {
                return KafkaIO.Read.class.getDeclaredMethod("get" + propertyNameInUpperCamel, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return KafkaIO.Read.class.getDeclaredMethod("is" + propertyNameInUpperCamel, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    throw new RuntimeException("Should not happen", e);
                }
            }
        }

        @Nullable
        @VisibleForTesting
        @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object getDefaultValue() {
            return null;
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Method getGetterMethod() {
            return this.getterMethod;
        }
    }

    static enum KafkaIOReadImplementation {
        LEGACY,
        SDF;

    }
}

