/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.ConfluentSchemaRegistryDeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaSchemaTransformReadConfiguration;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

@AutoService(value={SchemaTransformProvider.class})
public class KafkaSchemaTransformReadProvider
extends TypedSchemaTransformProvider<KafkaSchemaTransformReadConfiguration> {
    protected Class<KafkaSchemaTransformReadConfiguration> configurationClass() {
        return KafkaSchemaTransformReadConfiguration.class;
    }

    protected SchemaTransform from(KafkaSchemaTransformReadConfiguration configuration) {
        return new KafkaReadSchemaTransform(configuration);
    }

    public String identifier() {
        return "kafka:read";
    }

    public List<String> inputCollectionNames() {
        return Lists.newArrayList();
    }

    public List<String> outputCollectionNames() {
        return Lists.newArrayList((Object[])new String[]{"OUTPUT"});
    }

    private static class KafkaReadSchemaTransform
    implements SchemaTransform {
        private final KafkaSchemaTransformReadConfiguration configuration;

        KafkaReadSchemaTransform(KafkaSchemaTransformReadConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public PTransform<PCollectionRowTuple, PCollectionRowTuple> buildTransform() {
            String autoOffsetReset;
            String avroSchema = this.configuration.getAvroSchema();
            final Integer groupId = this.configuration.hashCode() % Integer.MAX_VALUE;
            String string = autoOffsetReset = this.configuration.getAutoOffsetResetConfig() == null ? "latest" : this.configuration.getAutoOffsetResetConfig();
            if (avroSchema != null) {
                assert (this.configuration.getConfluentSchemaRegistryUrl() == null) : "To read from Kafka, a schema must be provided directly or though Confluent Schema Registry, but not both.";
                org.apache.beam.sdk.schemas.Schema beamSchema = AvroUtils.toBeamSchema((Schema)new Schema.Parser().parse(avroSchema));
                SimpleFunction valueMapper = AvroUtils.getAvroBytesToRowFunction((org.apache.beam.sdk.schemas.Schema)beamSchema);
                return new PTransform<PCollectionRowTuple, PCollectionRowTuple>((SerializableFunction)valueMapper, beamSchema){
                    final /* synthetic */ SerializableFunction val$valueMapper;
                    final /* synthetic */ org.apache.beam.sdk.schemas.Schema val$beamSchema;
                    {
                        this.val$valueMapper = serializableFunction;
                        this.val$beamSchema = schema;
                    }

                    public PCollectionRowTuple expand(PCollectionRowTuple input) {
                        KafkaIO.Read<byte[], byte[]> kafkaRead = KafkaIO.readBytes().withConsumerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"group.id", (Object)("kafka-read-provider-" + groupId), (Object)"enable.auto.commit", (Object)true, (Object)"auto.commit.interval.ms", (Object)100, (Object)"auto.offset.reset", (Object)autoOffsetReset)).withTopic(configuration.getTopic()).withBootstrapServers(configuration.getBootstrapServers());
                        return PCollectionRowTuple.of((String)"OUTPUT", (PCollection)((PCollection)((PCollection)((PCollection)input.getPipeline().apply(kafkaRead.withoutMetadata())).apply((PTransform)Values.create())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via(this.val$valueMapper))).setRowSchema(this.val$beamSchema));
                    }
                };
            }
            return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                public PCollectionRowTuple expand(PCollectionRowTuple input) {
                    String confluentSchemaRegUrl = configuration.getConfluentSchemaRegistryUrl();
                    String confluentSchemaRegSubject = configuration.getConfluentSchemaRegistrySubject();
                    if (confluentSchemaRegUrl == null || confluentSchemaRegSubject == null) {
                        throw new IllegalArgumentException("To read from Kafka, a schema must be provided directly or though Confluent Schema Registry. Make sure you are providing one of these parameters.");
                    }
                    KafkaIO.Read kafkaRead = KafkaIO.read().withTopic(configuration.getTopic()).withBootstrapServers(configuration.getBootstrapServers()).withConsumerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"group.id", (Object)("kafka-read-provider-" + groupId), (Object)"enable.auto.commit", (Object)true, (Object)"auto.commit.interval.ms", (Object)100, (Object)"auto.offset.reset", (Object)autoOffsetReset)).withKeyDeserializer(ByteArrayDeserializer.class).withValueDeserializer(ConfluentSchemaRegistryDeserializerProvider.of(confluentSchemaRegUrl, confluentSchemaRegSubject));
                    PCollection kafkaValues = (PCollection)((PCollection)input.getPipeline().apply(kafkaRead.withoutMetadata())).apply((PTransform)Values.create());
                    assert (kafkaValues.getCoder().getClass() == AvroCoder.class);
                    AvroCoder coder = (AvroCoder)kafkaValues.getCoder();
                    kafkaValues = kafkaValues.setCoder((Coder)AvroUtils.schemaCoder((Schema)coder.getSchema()));
                    return PCollectionRowTuple.of((String)"OUTPUT", (PCollection)((PCollection)kafkaValues.apply(Convert.toRows())));
                }
            };
        }
    }
}

