/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.sdk.values.KV;

public class KafkaRecordCoder<K, V>
extends StructuredCoder<KafkaRecord<K, V>> {
    private static final StringUtf8Coder stringCoder = StringUtf8Coder.of();
    private static final VarLongCoder longCoder = VarLongCoder.of();
    private static final VarIntCoder intCoder = VarIntCoder.of();
    private final KvCoder<K, V> kvCoder;

    public static <K, V> KafkaRecordCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new KafkaRecordCoder<K, V>(keyCoder, valueCoder);
    }

    public KafkaRecordCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.kvCoder = KvCoder.of(keyCoder, valueCoder);
    }

    public void encode(KafkaRecord<K, V> value, OutputStream outStream) throws IOException {
        stringCoder.encode(value.getTopic(), outStream);
        intCoder.encode(Integer.valueOf(value.getPartition()), outStream);
        longCoder.encode(Long.valueOf(value.getOffset()), outStream);
        longCoder.encode(Long.valueOf(value.getTimestamp()), outStream);
        intCoder.encode(Integer.valueOf(value.getTimestampType().ordinal()), outStream);
        this.kvCoder.encode(value.getKV(), outStream);
    }

    public KafkaRecord<K, V> decode(InputStream inStream) throws IOException {
        return new KafkaRecord(stringCoder.decode(inStream), intCoder.decode(inStream), longCoder.decode(inStream), longCoder.decode(inStream), KafkaTimestampType.forOrdinal(intCoder.decode(inStream)), this.kvCoder.decode(inStream));
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return this.kvCoder.getCoderArguments();
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.kvCoder.verifyDeterministic();
    }

    public boolean isRegisterByteSizeObserverCheap(KafkaRecord<K, V> value) {
        return this.kvCoder.isRegisterByteSizeObserverCheap(value.getKV());
    }

    public Object structuralValue(KafkaRecord<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        return new KafkaRecord(value.getTopic(), value.getPartition(), value.getOffset(), value.getTimestamp(), value.getTimestampType(), (KV)this.kvCoder.structuralValue(value.getKV()));
    }

    public boolean consistentWithEquals() {
        return this.kvCoder.consistentWithEquals();
    }
}

