/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.joda.time.Instant;

final class AutoValue_KafkaSourceDescriptor
extends KafkaSourceDescriptor {
    private final String topic;
    private final Integer partition;
    private final Long startReadOffset;
    private final Instant startReadTime;
    private final List<String> bootStrapServers;

    AutoValue_KafkaSourceDescriptor(String topic, Integer partition, @Nullable Long startReadOffset, @Nullable Instant startReadTime, @Nullable List<String> bootStrapServers) {
        if (topic == null) {
            throw new NullPointerException("Null topic");
        }
        this.topic = topic;
        if (partition == null) {
            throw new NullPointerException("Null partition");
        }
        this.partition = partition;
        this.startReadOffset = startReadOffset;
        this.startReadTime = startReadTime;
        this.bootStrapServers = bootStrapServers;
    }

    @Override
    @SchemaFieldName(value="topic")
    String getTopic() {
        return this.topic;
    }

    @Override
    @SchemaFieldName(value="partition")
    Integer getPartition() {
        return this.partition;
    }

    @Override
    @SchemaFieldName(value="start_read_offset")
    @Nullable
    Long getStartReadOffset() {
        return this.startReadOffset;
    }

    @Override
    @SchemaFieldName(value="start_read_time")
    @Nullable
    Instant getStartReadTime() {
        return this.startReadTime;
    }

    @Override
    @SchemaFieldName(value="bootstrap_servers")
    @Nullable
    List<String> getBootStrapServers() {
        return this.bootStrapServers;
    }

    public String toString() {
        return "KafkaSourceDescriptor{topic=" + this.topic + ", partition=" + this.partition + ", startReadOffset=" + this.startReadOffset + ", startReadTime=" + this.startReadTime + ", bootStrapServers=" + this.bootStrapServers + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaSourceDescriptor) {
            KafkaSourceDescriptor that = (KafkaSourceDescriptor)o;
            return this.topic.equals(that.getTopic()) && this.partition.equals(that.getPartition()) && (this.startReadOffset == null ? that.getStartReadOffset() == null : this.startReadOffset.equals(that.getStartReadOffset())) && (this.startReadTime == null ? that.getStartReadTime() == null : this.startReadTime.equals((Object)that.getStartReadTime())) && (this.bootStrapServers == null ? that.getBootStrapServers() == null : this.bootStrapServers.equals(that.getBootStrapServers()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.startReadOffset == null ? 0 : this.startReadOffset.hashCode();
        h$ *= 1000003;
        h$ ^= this.startReadTime == null ? 0 : this.startReadTime.hashCode();
        h$ *= 1000003;
        return h$ ^= this.bootStrapServers == null ? 0 : this.bootStrapServers.hashCode();
    }
}

