/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.joda.time.Duration;
import org.joda.time.Instant;

final class AutoValue_KafkaIO_Read<K, V>
extends KafkaIO.Read<K, V> {
    private final Map<String, Object> consumerConfig;
    private final List<String> topics;
    private final List<TopicPartition> topicPartitions;
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;
    private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
    private final SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn;
    private final SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
    private final long maxNumRecords;
    private final Duration maxReadTime;

    private AutoValue_KafkaIO_Read(Map<String, Object> consumerConfig, List<String> topics, List<TopicPartition> topicPartitions, @Nullable Coder<K> keyCoder, @Nullable Coder<V> valueCoder, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn, long maxNumRecords, @Nullable Duration maxReadTime) {
        this.consumerConfig = consumerConfig;
        this.topics = topics;
        this.topicPartitions = topicPartitions;
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
        this.consumerFactoryFn = consumerFactoryFn;
        this.timestampFn = timestampFn;
        this.watermarkFn = watermarkFn;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
    }

    @Override
    Map<String, Object> getConsumerConfig() {
        return this.consumerConfig;
    }

    @Override
    List<String> getTopics() {
        return this.topics;
    }

    @Override
    List<TopicPartition> getTopicPartitions() {
        return this.topicPartitions;
    }

    @Override
    @Nullable
    Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    @Override
    @Nullable
    Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> getConsumerFactoryFn() {
        return this.consumerFactoryFn;
    }

    @Override
    @Nullable
    SerializableFunction<KafkaRecord<K, V>, Instant> getTimestampFn() {
        return this.timestampFn;
    }

    @Override
    @Nullable
    SerializableFunction<KafkaRecord<K, V>, Instant> getWatermarkFn() {
        return this.watermarkFn;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable
    Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.Read) {
            KafkaIO.Read that = (KafkaIO.Read)((Object)o);
            return this.consumerConfig.equals(that.getConsumerConfig()) && this.topics.equals(that.getTopics()) && this.topicPartitions.equals(that.getTopicPartitions()) && (this.keyCoder == null ? that.getKeyCoder() == null : this.keyCoder.equals(that.getKeyCoder())) && (this.valueCoder == null ? that.getValueCoder() == null : this.valueCoder.equals(that.getValueCoder())) && this.consumerFactoryFn.equals(that.getConsumerFactoryFn()) && (this.timestampFn == null ? that.getTimestampFn() == null : this.timestampFn.equals(that.getTimestampFn())) && (this.watermarkFn == null ? that.getWatermarkFn() == null : this.watermarkFn.equals(that.getWatermarkFn())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.consumerConfig.hashCode();
        h *= 1000003;
        h ^= this.topics.hashCode();
        h *= 1000003;
        h ^= this.topicPartitions.hashCode();
        h *= 1000003;
        h ^= this.keyCoder == null ? 0 : this.keyCoder.hashCode();
        h *= 1000003;
        h ^= this.valueCoder == null ? 0 : this.valueCoder.hashCode();
        h *= 1000003;
        h ^= this.consumerFactoryFn.hashCode();
        h *= 1000003;
        h ^= this.timestampFn == null ? 0 : this.timestampFn.hashCode();
        h *= 1000003;
        h ^= this.watermarkFn == null ? 0 : this.watermarkFn.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.maxNumRecords >>> 32 ^ this.maxNumRecords));
        h *= 1000003;
        return h ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
    }

    @Override
    public KafkaIO.Read.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.Read.Builder<K, V> {
        private Map<String, Object> consumerConfig;
        private List<String> topics;
        private List<TopicPartition> topicPartitions;
        private Coder<K> keyCoder;
        private Coder<V> valueCoder;
        private SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
        private SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn;
        private SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
        private Long maxNumRecords;
        private Duration maxReadTime;

        Builder() {
        }

        Builder(KafkaIO.Read<K, V> source) {
            this.consumerConfig = source.getConsumerConfig();
            this.topics = source.getTopics();
            this.topicPartitions = source.getTopicPartitions();
            this.keyCoder = source.getKeyCoder();
            this.valueCoder = source.getValueCoder();
            this.consumerFactoryFn = source.getConsumerFactoryFn();
            this.timestampFn = source.getTimestampFn();
            this.watermarkFn = source.getWatermarkFn();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setConsumerConfig(Map<String, Object> consumerConfig) {
            this.consumerConfig = consumerConfig;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setTopics(List<String> topics) {
            this.topics = topics;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setTopicPartitions(List<TopicPartition> topicPartitions) {
            this.topicPartitions = topicPartitions;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setKeyCoder(@Nullable Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setValueCoder(@Nullable Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn) {
            this.consumerFactoryFn = consumerFactoryFn;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setTimestampFn(@Nullable SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn) {
            this.timestampFn = timestampFn;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setWatermarkFn(@Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn) {
            this.watermarkFn = watermarkFn;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        public KafkaIO.Read.Builder<K, V> setMaxReadTime(@Nullable Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        public KafkaIO.Read<K, V> build() {
            String missing = "";
            if (this.consumerConfig == null) {
                missing = missing + " consumerConfig";
            }
            if (this.topics == null) {
                missing = missing + " topics";
            }
            if (this.topicPartitions == null) {
                missing = missing + " topicPartitions";
            }
            if (this.consumerFactoryFn == null) {
                missing = missing + " consumerFactoryFn";
            }
            if (this.maxNumRecords == null) {
                missing = missing + " maxNumRecords";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_Read(this.consumerConfig, this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, this.consumerFactoryFn, this.timestampFn, this.watermarkFn, this.maxNumRecords, this.maxReadTime);
        }
    }
}

