/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JdbcWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<JdbcWriteSchemaTransformConfiguration> {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:jdbc_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return "Write to a JDBC sink using a SQL query or by directly accessing a single table.\n\nThis transform can be used to write to a JDBC sink using either a given JDBC driver jar and class name, or by using one of the default packaged drivers given a `jdbc_type`.\n\n#### Using a default driver\n\nThis transform comes packaged with drivers for several popular JDBC distributions. The following distributions can be declared as the `jdbc_type`: " + JdbcUtil.JDBC_DRIVER_MAP.keySet().toString().replaceAll("[\\[\\]]", "") + ".\n\nFor example, writing to a MySQL sink using a SQL query: ::\n    - type: WriteToJdbc\n      config:\n        jdbc_type: mysql\n        url: \"jdbc:mysql://my-host:3306/database\"\n        query: \"INSERT INTO table VALUES(?, ?)\"\n\n\n**Note**: See the following transforms which are built on top of this transform and simplify this logic for several popular JDBC distributions:\n\n - WriteToMySql\n - WriteToPostgres\n - WriteToOracle\n - WriteToSqlServer\n\n#### Declaring custom JDBC drivers\n\nIf writing to a JDBC sink not listed above, or if it is necessary to use a custom driver not packaged with Beam, one must define a JDBC driver and class name.\n\nFor example, writing to a MySQL table: ::\n    - type: WriteToJdbc\n      config:\n        driver_jars: \"path/to/some/jdbc.jar\"\n        driver_class_name: \"com.mysql.jdbc.Driver\"\n        url: \"jdbc:mysql://my-host:3306/database\"\n        table: \"my-table\"\n\n#### Connection Properties\n\nConnection properties are properties sent to the Driver used to connect to the JDBC source. For example, to set the character encoding to UTF-8, one could write: ::\n\n    - type: WriteToJdbc\n      config:\n        connectionProperties: \"characterEncoding=UTF-8;\"\n        ...\nAll properties should be semi-colon-delimited (e.g. \"key1=value1;key2=value2;\")\n";
    }

    protected @UnknownKeyFor @NonNull @Initialized String inheritedDescription(@UnknownKeyFor @NonNull @Initialized String prettyName, @UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized int port) {
        return String.format("Write to a %s sink using a SQL query or by directly accessing a single table.%n%nThis is a special case of WriteToJdbc that includes the necessary %s Driver and classes.%n%nAn example of using %s with SQL query: ::%n%n    - type: %s%n      config:%n        url: \"jdbc:%s://my-host:%d/database\"%n        query: \"INSERT INTO table VALUES(?, ?)\"%n%nIt is also possible to read a table by specifying a table name. For example, the following configuration will perform a read on an entire table: ::%n%n    - type: %s%n      config:%n        url: \"jdbc:%s://my-host:%d/database\"%n        table: \"my-table\"%n%n#### Advanced Usage%n%nIt might be necessary to use a custom JDBC driver that is not packaged with this transform. If that is the case, see WriteToJdbc which allows for more custom configuration.", prettyName, prettyName, transformName, transformName, prefix, port, transformName, prefix, port);
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration> configurationClass() {
        return JdbcWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized String jdbcType() {
        return "";
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration configuration) {
        configuration.validate(this.jdbcType());
        return new JdbcWriteSchemaTransform(configuration, this.jdbcType());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class JdbcWriteSchemaTransformConfiguration
    implements Serializable {
        @SchemaFieldDescription(value="Connection URL for the JDBC sink.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getJdbcUrl();

        @SchemaFieldDescription(value="If true, enables using a dynamically determined number of shards to write.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getAutosharding();

        @SchemaFieldDescription(value="Sets the connection init sql statements used by the Driver. Only MySQL and MariaDB support this.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized String> getConnectionInitSql();

        @SchemaFieldDescription(value="Used to set connection properties passed to the JDBC driver not already defined as standalone parameter (e.g. username and password can be set using parameters above accordingly). Format of the string must be \"key1=value1;key2=value2;\".")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConnectionProperties();

        @SchemaFieldDescription(value="Name of a Java Driver class to use to connect to the JDBC source. For example, \"com.mysql.jdbc.Driver\".")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getDriverClassName();

        @SchemaFieldDescription(value="Comma separated path(s) for the JDBC driver jar(s). This can be a local path or GCS (gs://) path.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getDriverJars();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long getBatchSize();

        @SchemaFieldDescription(value="Type of JDBC source. When specified, an appropriate default Driver will be packaged with the transform. One of mysql, postgres, oracle, or mssql.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getJdbcType();

        @SchemaFieldDescription(value="Name of the table to write to.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getLocation();

        @SchemaFieldDescription(value="Password for the JDBC source.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getPassword();

        @SchemaFieldDescription(value="Username for the JDBC source.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getUsername();

        @SchemaFieldDescription(value="SQL query used to insert records into the JDBC sink.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getWriteStatement();

        public void validate() {
            this.validate("");
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized String jdbcType) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
            boolean locationPresent;
            boolean jdbcTypePresent;
            if (Strings.isNullOrEmpty((String)this.getJdbcUrl())) {
                throw new IllegalArgumentException("JDBC URL cannot be blank");
            }
            jdbcType = !Strings.isNullOrEmpty((String)jdbcType) ? jdbcType : this.getJdbcType();
            boolean driverClassNamePresent = !Strings.isNullOrEmpty((String)this.getDriverClassName());
            boolean driverJarsPresent = !Strings.isNullOrEmpty((String)this.getDriverJars());
            boolean bl = jdbcTypePresent = !Strings.isNullOrEmpty((String)jdbcType);
            if (!(driverClassNamePresent || driverJarsPresent || jdbcTypePresent)) {
                throw new IllegalArgumentException("If JDBC type is not specified, then Driver Class Name and Driver Jars must be specified.");
            }
            if (!driverClassNamePresent && !jdbcTypePresent) {
                throw new IllegalArgumentException("One of JDBC Driver class name or JDBC type must be specified.");
            }
            if (jdbcTypePresent && !JdbcUtil.JDBC_DRIVER_MAP.containsKey(Objects.requireNonNull(jdbcType).toLowerCase())) {
                throw new IllegalArgumentException("JDBC type must be one of " + JdbcUtil.JDBC_DRIVER_MAP.keySet() + " but was " + jdbcType);
            }
            boolean writeStatementPresent = this.getWriteStatement() != null && !"".equals(this.getWriteStatement());
            boolean bl2 = locationPresent = this.getLocation() != null && !"".equals(this.getLocation());
            if (writeStatementPresent && locationPresent) {
                throw new IllegalArgumentException("Write Statement and Table are mutually exclusive configurations");
            }
            if (!writeStatementPresent && !locationPresent) {
                throw new IllegalArgumentException("Either Write Statement or Table must be set.");
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDriverClassName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJdbcType(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJdbcUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionProperties(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionInitSql(@UnknownKeyFor @NonNull @Initialized List<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteStatement(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutosharding(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDriverJars(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration build();
        }
    }

    protected static class JdbcWriteSchemaTransform
    extends SchemaTransform
    implements Serializable {
        @UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration config;
        private @UnknownKeyFor @NonNull @Initialized String jdbcType;

        public JdbcWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration config, @UnknownKeyFor @NonNull @Initialized String jdbcType) {
            this.config = config;
            this.jdbcType = jdbcType;
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration dataSourceConfiguration() {
            String driverJars;
            List<String> initialSql;
            String driverClassName = this.config.getDriverClassName();
            if (Strings.isNullOrEmpty((String)driverClassName)) {
                driverClassName = JdbcUtil.JDBC_DRIVER_MAP.get(Objects.requireNonNull(!Strings.isNullOrEmpty((String)this.jdbcType) ? this.jdbcType : this.config.getJdbcType()).toLowerCase());
            }
            JdbcIO.DataSourceConfiguration dsConfig = JdbcIO.DataSourceConfiguration.create(driverClassName, this.config.getJdbcUrl()).withUsername("".equals(this.config.getUsername()) ? null : this.config.getUsername()).withPassword("".equals(this.config.getPassword()) ? null : this.config.getPassword());
            String connectionProperties = this.config.getConnectionProperties();
            if (connectionProperties != null) {
                dsConfig = dsConfig.withConnectionProperties(connectionProperties);
            }
            if ((initialSql = this.config.getConnectionInitSql()) != null && initialSql.size() > 0) {
                dsConfig = dsConfig.withConnectionInitSqls(initialSql);
            }
            if ((driverJars = this.config.getDriverJars()) != null) {
                dsConfig = dsConfig.withDriverJars(this.config.getDriverJars());
            }
            return dsConfig;
        }

        protected @UnknownKeyFor @NonNull @Initialized String writeStatement(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            String writeStatement = this.config.getWriteStatement();
            if (writeStatement != null) {
                return writeStatement;
            }
            StringBuilder statement = new StringBuilder("INSERT INTO ");
            statement.append(this.config.getLocation());
            statement.append(" (");
            statement.append(String.join((CharSequence)", ", schema.getFieldNames()));
            statement.append(") VALUES(");
            for (int i = 0; i < schema.getFieldCount() - 1; ++i) {
                statement.append("?, ");
            }
            statement.append("?)");
            return statement.toString();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Long writeBatchSize;
            JdbcIO.WriteVoid<Row> writeRows = JdbcIO.write().withDataSourceConfiguration(this.dataSourceConfiguration()).withStatement(this.writeStatement(input.get("input").getSchema())).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter()).withResults();
            Boolean autosharding = this.config.getAutosharding();
            if (autosharding != null && autosharding.booleanValue()) {
                writeRows = writeRows.withAutoSharding();
            }
            if ((writeBatchSize = this.config.getBatchSize()) != null) {
                writeRows = writeRows.withBatchSize(writeBatchSize);
            }
            PCollection postWrite = ((PCollection)((PCollection)input.get("input").apply(writeRows)).apply("post-write", (PTransform)ParDo.of(new NoOutputDoFn()))).setRowSchema(Schema.of((Schema.Field[])new Schema.Field[0]));
            return PCollectionRowTuple.of((String)"post_write", (PCollection)postWrite);
        }

        private static class NoOutputDoFn<@UnknownKeyFor T>
        extends DoFn<T, Row> {
            private NoOutputDoFn() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            }
        }
    }
}

