/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import javax.sql.DataSource;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class AutoValue_JdbcIO_Read<T>
extends JdbcIO.Read<T> {
    private final @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
    private final @Nullable ValueProvider<String> query;
    private final  @Nullable JdbcIO.StatementPreparator statementPreparator;
    private final  @Nullable JdbcIO.RowMapper<T> rowMapper;
    private final @Nullable Coder<T> coder;
    private final int fetchSize;
    private final boolean outputParallelization;

    private AutoValue_JdbcIO_Read(@Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn, @Nullable ValueProvider<String> query,  @Nullable JdbcIO.StatementPreparator statementPreparator,  @Nullable JdbcIO.RowMapper<T> rowMapper, @Nullable Coder<T> coder, int fetchSize, boolean outputParallelization) {
        this.dataSourceProviderFn = dataSourceProviderFn;
        this.query = query;
        this.statementPreparator = statementPreparator;
        this.rowMapper = rowMapper;
        this.coder = coder;
        this.fetchSize = fetchSize;
        this.outputParallelization = outputParallelization;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn() {
        return this.dataSourceProviderFn;
    }

    @Override
    @Pure
    @Nullable ValueProvider<String> getQuery() {
        return this.query;
    }

    @Override
    @Pure
     @Nullable JdbcIO.StatementPreparator getStatementPreparator() {
        return this.statementPreparator;
    }

    @Override
    @Pure
     @Nullable JdbcIO.RowMapper<T> getRowMapper() {
        return this.rowMapper;
    }

    @Override
    @Pure
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    @Pure
    int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    @Pure
    boolean getOutputParallelization() {
        return this.outputParallelization;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcIO.Read) {
            JdbcIO.Read that = (JdbcIO.Read)((Object)o);
            return (this.dataSourceProviderFn == null ? that.getDataSourceProviderFn() == null : this.dataSourceProviderFn.equals(that.getDataSourceProviderFn())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && (this.statementPreparator == null ? that.getStatementPreparator() == null : this.statementPreparator.equals(that.getStatementPreparator())) && (this.rowMapper == null ? that.getRowMapper() == null : this.rowMapper.equals(that.getRowMapper())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && this.fetchSize == that.getFetchSize() && this.outputParallelization == that.getOutputParallelization();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataSourceProviderFn == null ? 0 : this.dataSourceProviderFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.statementPreparator == null ? 0 : this.statementPreparator.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowMapper == null ? 0 : this.rowMapper.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.fetchSize;
        h$ *= 1000003;
        return h$ ^= this.outputParallelization ? 1231 : 1237;
    }

    @Override
    JdbcIO.Read.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends JdbcIO.Read.Builder<T> {
        private @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private @Nullable ValueProvider<String> query;
        private  @Nullable JdbcIO.StatementPreparator statementPreparator;
        private  @Nullable JdbcIO.RowMapper<T> rowMapper;
        private @Nullable Coder<T> coder;
        private Integer fetchSize;
        private Boolean outputParallelization;

        Builder() {
        }

        private Builder(JdbcIO.Read<T> source) {
            this.dataSourceProviderFn = source.getDataSourceProviderFn();
            this.query = source.getQuery();
            this.statementPreparator = source.getStatementPreparator();
            this.rowMapper = source.getRowMapper();
            this.coder = source.getCoder();
            this.fetchSize = source.getFetchSize();
            this.outputParallelization = source.getOutputParallelization();
        }

        @Override
        JdbcIO.Read.Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            return this;
        }

        @Override
        JdbcIO.Read.Builder<T> setQuery(ValueProvider<String> query) {
            this.query = query;
            return this;
        }

        @Override
        JdbcIO.Read.Builder<T> setStatementPreparator(JdbcIO.StatementPreparator statementPreparator) {
            this.statementPreparator = statementPreparator;
            return this;
        }

        @Override
        JdbcIO.Read.Builder<T> setRowMapper(JdbcIO.RowMapper<T> rowMapper) {
            this.rowMapper = rowMapper;
            return this;
        }

        @Override
        JdbcIO.Read.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        JdbcIO.Read.Builder<T> setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        @Override
        JdbcIO.Read.Builder<T> setOutputParallelization(boolean outputParallelization) {
            this.outputParallelization = outputParallelization;
            return this;
        }

        @Override
        JdbcIO.Read<T> build() {
            if (this.fetchSize == null || this.outputParallelization == null) {
                StringBuilder missing = new StringBuilder();
                if (this.fetchSize == null) {
                    missing.append(" fetchSize");
                }
                if (this.outputParallelization == null) {
                    missing.append(" outputParallelization");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcIO_Read(this.dataSourceProviderFn, this.query, this.statementPreparator, this.rowMapper, this.coder, this.fetchSize, this.outputParallelization);
        }
    }
}

