/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.sql.JDBCType;
import java.time.Instant;
import java.util.Objects;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.schemas.logicaltypes.FixedPrecisionNumeric;
import org.apache.beam.sdk.schemas.logicaltypes.FixedString;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.schemas.logicaltypes.UuidLogicalType;
import org.apache.beam.sdk.schemas.logicaltypes.VariableBytes;
import org.apache.beam.sdk.schemas.logicaltypes.VariableString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class LogicalTypes {
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_BIT_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Boolean>(JDBCType.BIT.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.BOOLEAN){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_DATE_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Instant>(JDBCType.DATE.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_FLOAT_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Double>(JDBCType.FLOAT.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DOUBLE){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_TIME_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Instant>(JDBCType.TIME.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_TIMESTAMP_WITH_TIMEZONE_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Instant>(JDBCType.TIMESTAMP_WITH_TIMEZONE.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_UUID_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new UuidLogicalType());
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType OTHER_AS_STRING_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<String>(JDBCType.OTHER.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.STRING){});

    LogicalTypes() {
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fixedLengthString(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedString.of((String)jdbcType.getName(), (int)length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fixedLengthBytes(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((String)jdbcType.getName(), (int)length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType variableLengthString(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)VariableString.of((String)jdbcType.getName(), (int)length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType variableLengthBytes(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)VariableBytes.of((String)jdbcType.getName(), (int)length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType numeric(@UnknownKeyFor @NonNull @Initialized int precision, @UnknownKeyFor @NonNull @Initialized int scale) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedPrecisionNumeric.of((int)precision, (int)scale));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> fixedOrVariableBytes(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized int length) {
        if (length == Integer.MAX_VALUE) {
            return VariableBytes.of((String)name, (int)length);
        }
        return FixedBytes.of((String)name, (int)length);
    }

    static abstract class JdbcLogicalType<@UnknownKeyFor T>
    implements Schema.LogicalType<T, T> {
        protected final @UnknownKeyFor @NonNull @Initialized String identifier;
        protected final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Schema.FieldType argumentType;
        protected final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Schema.FieldType baseType;
        protected final @UnknownKeyFor @NonNull @Initialized Object argument;

        protected JdbcLogicalType(@UnknownKeyFor @NonNull @Initialized String identifier, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Schema.FieldType argumentType, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Schema.FieldType baseType, @UnknownKeyFor @NonNull @Initialized Object argument) {
            this.identifier = identifier;
            this.argumentType = argumentType;
            this.baseType = baseType;
            this.argument = argument;
        }

        public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
            return this.identifier;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
            return this.argumentType;
        }

        public <ArgumentT> ArgumentT getArgument() {
            return (ArgumentT)this.argument;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
            return this.baseType;
        }

        public T toBaseType(T input) {
            return input;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JdbcLogicalType)) {
                return false;
            }
            JdbcLogicalType that = (JdbcLogicalType)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.baseType, that.baseType) && Objects.equals(this.argument, that.argument);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.identifier, this.baseType, this.argument);
        }
    }
}

