/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_JdbcIO_RetryConfiguration
extends JdbcIO.RetryConfiguration {
    private final int maxAttempts;
    private final @Nullable Duration maxDuration;
    private final @Nullable Duration initialDuration;

    private AutoValue_JdbcIO_RetryConfiguration(int maxAttempts, @Nullable Duration maxDuration, @Nullable Duration initialDuration) {
        this.maxAttempts = maxAttempts;
        this.maxDuration = maxDuration;
        this.initialDuration = initialDuration;
    }

    @Override
    int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    @Nullable Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    @Nullable Duration getInitialDuration() {
        return this.initialDuration;
    }

    public String toString() {
        return "RetryConfiguration{maxAttempts=" + this.maxAttempts + ", maxDuration=" + this.maxDuration + ", initialDuration=" + this.initialDuration + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcIO.RetryConfiguration) {
            JdbcIO.RetryConfiguration that = (JdbcIO.RetryConfiguration)o;
            return this.maxAttempts == that.getMaxAttempts() && (this.maxDuration == null ? that.getMaxDuration() == null : this.maxDuration.equals((Object)that.getMaxDuration())) && (this.initialDuration == null ? that.getInitialDuration() == null : this.initialDuration.equals((Object)that.getInitialDuration()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.maxAttempts;
        h$ *= 1000003;
        h$ ^= this.maxDuration == null ? 0 : this.maxDuration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.initialDuration == null ? 0 : this.initialDuration.hashCode();
    }

    @Override
    JdbcIO.RetryConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends JdbcIO.RetryConfiguration.Builder {
        private Integer maxAttempts;
        private @Nullable Duration maxDuration;
        private @Nullable Duration initialDuration;

        Builder() {
        }

        private Builder(JdbcIO.RetryConfiguration source) {
            this.maxAttempts = source.getMaxAttempts();
            this.maxDuration = source.getMaxDuration();
            this.initialDuration = source.getInitialDuration();
        }

        @Override
        JdbcIO.RetryConfiguration.Builder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Override
        JdbcIO.RetryConfiguration.Builder setMaxDuration(Duration maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        @Override
        JdbcIO.RetryConfiguration.Builder setInitialDuration(Duration initialDuration) {
            this.initialDuration = initialDuration;
            return this;
        }

        @Override
        JdbcIO.RetryConfiguration build() {
            String missing = "";
            if (this.maxAttempts == null) {
                missing = missing + " maxAttempts";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcIO_RetryConfiguration(this.maxAttempts, this.maxDuration, this.initialDuration);
        }
    }
}

