/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Read;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_ReadAll;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Write;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.jdbc.repackaged.com.google.common.base.Preconditions;
import org.apache.commons.dbcp2.BasicDataSource;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class JdbcIO {
    public static <T> Read<T> read() {
        return new AutoValue_JdbcIO_Read.Builder().build();
    }

    public static <ParameterT, OutputT> ReadAll<ParameterT, OutputT> readAll() {
        return new AutoValue_JdbcIO_ReadAll.Builder().build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_JdbcIO_Write.Builder().build();
    }

    private JdbcIO() {
    }

    private static class Reparallelize<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Reparallelize() {
        }

        public PCollection<T> expand(PCollection<T> input) {
            PCollectionView empty = (PCollectionView)((PCollection)input.apply("Consume", (PTransform)Filter.by((SerializableFunction)SerializableFunctions.constant((Object)false)))).apply((PTransform)View.asIterable());
            PCollection materialized = (PCollection)input.apply("Identity", (PTransform)ParDo.of((DoFn)new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    c.output(c.element());
                }
            }).withSideInputs(new PCollectionView[]{empty}));
            return (PCollection)materialized.apply((PTransform)Reshuffle.viaRandomKey());
        }
    }

    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract String getStatement();

        @Nullable
        abstract PreparedStatementSetter<T> getPreparedStatementSetter();

        abstract Builder<T> toBuilder();

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.toBuilder().setDataSourceConfiguration(config).build();
        }

        public Write<T> withStatement(String statement) {
            return this.toBuilder().setStatement(statement).build();
        }

        public Write<T> withPreparedStatementSetter(PreparedStatementSetter<T> setter) {
            return this.toBuilder().setPreparedStatementSetter(setter).build();
        }

        public PDone expand(PCollection<T> input) {
            Preconditions.checkArgument(this.getDataSourceConfiguration() != null, "withDataSourceConfiguration() is required");
            Preconditions.checkArgument(this.getStatement() != null, "withStatement() is required");
            Preconditions.checkArgument(this.getPreparedStatementSetter() != null, "withPreparedStatementSetter() is required");
            input.apply((PTransform)ParDo.of(new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static class WriteFn<T>
        extends DoFn<T, Void> {
            private static final int DEFAULT_BATCH_SIZE = 1000;
            private final Write<T> spec;
            private DataSource dataSource;
            private Connection connection;
            private PreparedStatement preparedStatement;
            private int batchCount;

            public WriteFn(Write<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                this.dataSource = this.spec.getDataSourceConfiguration().buildDatasource();
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                this.preparedStatement = this.connection.prepareStatement(this.spec.getStatement());
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.batchCount = 0;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                Object record = context.element();
                this.preparedStatement.clearParameters();
                this.spec.getPreparedStatementSetter().setParameters(record, this.preparedStatement);
                this.preparedStatement.addBatch();
                ++this.batchCount;
                if (this.batchCount >= 1000) {
                    this.executeBatch();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() throws Exception {
                this.executeBatch();
            }

            private void executeBatch() throws SQLException {
                if (this.batchCount > 0) {
                    this.preparedStatement.executeBatch();
                    this.connection.commit();
                    this.batchCount = 0;
                }
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                try {
                    if (this.preparedStatement != null) {
                        this.preparedStatement.close();
                    }
                }
                finally {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    if (this.dataSource instanceof AutoCloseable) {
                        ((AutoCloseable)((Object)this.dataSource)).close();
                    }
                }
            }
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<T> setStatement(String var1);

            abstract Builder<T> setPreparedStatementSetter(PreparedStatementSetter<T> var1);

            abstract Write<T> build();
        }
    }

    @FunctionalInterface
    public static interface PreparedStatementSetter<T>
    extends Serializable {
        public void setParameters(T var1, PreparedStatement var2) throws Exception;
    }

    private static class ReadFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        private final DataSourceConfiguration dataSourceConfiguration;
        private final ValueProvider<String> query;
        private final PreparedStatementSetter<ParameterT> parameterSetter;
        private final RowMapper<OutputT> rowMapper;
        private DataSource dataSource;
        private Connection connection;

        private ReadFn(DataSourceConfiguration dataSourceConfiguration, ValueProvider<String> query, PreparedStatementSetter<ParameterT> parameterSetter, RowMapper<OutputT> rowMapper) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            this.query = query;
            this.parameterSetter = parameterSetter;
            this.rowMapper = rowMapper;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.dataSource = this.dataSourceConfiguration.buildDatasource();
            this.connection = this.dataSource.getConnection();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            try (PreparedStatement statement = this.connection.prepareStatement((String)this.query.get());){
                this.parameterSetter.setParameters(context.element(), statement);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        context.output(this.rowMapper.mapRow(resultSet));
                    }
                }
            }
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.connection.close();
            if (this.dataSource instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
        }
    }

    public static abstract class ReadAll<ParameterT, OutputT>
    extends PTransform<PCollection<ParameterT>, PCollection<OutputT>> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract ValueProvider<String> getQuery();

        @Nullable
        abstract PreparedStatementSetter<ParameterT> getParameterSetter();

        @Nullable
        abstract RowMapper<OutputT> getRowMapper();

        @Nullable
        abstract Coder<OutputT> getCoder();

        abstract Builder<ParameterT, OutputT> toBuilder();

        public ReadAll<ParameterT, OutputT> withDataSourceConfiguration(DataSourceConfiguration configuration) {
            Preconditions.checkArgument(configuration != null, "JdbcIO.readAll().withDataSourceConfiguration(configuration) called with null configuration");
            return this.toBuilder().setDataSourceConfiguration(configuration).build();
        }

        public ReadAll<ParameterT, OutputT> withQuery(String query) {
            Preconditions.checkArgument(query != null, "JdbcIO.readAll().withQuery(query) called with null query");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public ReadAll<ParameterT, OutputT> withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument(query != null, "JdbcIO.readAll().withQuery(query) called with null query");
            return this.toBuilder().setQuery(query).build();
        }

        public ReadAll<ParameterT, OutputT> withParameterSetter(PreparedStatementSetter<ParameterT> parameterSetter) {
            Preconditions.checkArgument(parameterSetter != null, "JdbcIO.readAll().withParameterSetter(parameterSetter) called with null statementPreparator");
            return this.toBuilder().setParameterSetter(parameterSetter).build();
        }

        public ReadAll<ParameterT, OutputT> withRowMapper(RowMapper<OutputT> rowMapper) {
            Preconditions.checkArgument(rowMapper != null, "JdbcIO.readAll().withRowMapper(rowMapper) called with null rowMapper");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public ReadAll<ParameterT, OutputT> withCoder(Coder<OutputT> coder) {
            Preconditions.checkArgument(coder != null, "JdbcIO.readAll().withCoder(coder) called with null coder");
            return this.toBuilder().setCoder(coder).build();
        }

        public PCollection<OutputT> expand(PCollection<ParameterT> input) {
            return (PCollection)((PCollection)input.apply((PTransform)ParDo.of(new ReadFn(this.getDataSourceConfiguration(), this.getQuery(), this.getParameterSetter(), this.getRowMapper())))).setCoder(this.getCoder()).apply(new Reparallelize());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            this.getDataSourceConfiguration().populateDisplayData(builder);
        }

        static abstract class Builder<ParameterT, OutputT> {
            Builder() {
            }

            abstract Builder<ParameterT, OutputT> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<ParameterT, OutputT> setQuery(ValueProvider<String> var1);

            abstract Builder<ParameterT, OutputT> setParameterSetter(PreparedStatementSetter<ParameterT> var1);

            abstract Builder<ParameterT, OutputT> setRowMapper(RowMapper<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setCoder(Coder<OutputT> var1);

            abstract ReadAll<ParameterT, OutputT> build();
        }
    }

    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract ValueProvider<String> getQuery();

        @Nullable
        abstract StatementPreparator getStatementPreparator();

        @Nullable
        abstract RowMapper<T> getRowMapper();

        @Nullable
        abstract Coder<T> getCoder();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration configuration) {
            Preconditions.checkArgument(configuration != null, "configuration can not be null");
            return this.toBuilder().setDataSourceConfiguration(configuration).build();
        }

        public Read<T> withQuery(String query) {
            Preconditions.checkArgument(query != null, "query can not be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public Read<T> withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument(query != null, "query can not be null");
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> withStatementPreparator(StatementPreparator statementPreparator) {
            Preconditions.checkArgument(statementPreparator != null, "statementPreparator can not be null");
            return this.toBuilder().setStatementPreparator(statementPreparator).build();
        }

        public Read<T> withRowMapper(RowMapper<T> rowMapper) {
            Preconditions.checkArgument(rowMapper != null, "rowMapper can not be null");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument(coder != null, "coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public PCollection<T> expand(PBegin input) {
            Preconditions.checkArgument(this.getQuery() != null, "withQuery() is required");
            Preconditions.checkArgument(this.getRowMapper() != null, "withRowMapper() is required");
            Preconditions.checkArgument(this.getCoder() != null, "withCoder() is required");
            Preconditions.checkArgument(this.getDataSourceConfiguration() != null, "withDataSourceConfiguration() is required");
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply(JdbcIO.readAll().withDataSourceConfiguration(this.getDataSourceConfiguration()).withQuery(this.getQuery()).withCoder(this.getCoder()).withRowMapper(this.getRowMapper()).withParameterSetter(new PreparedStatementSetter<Void>(){

                @Override
                public void setParameters(Void element, PreparedStatement preparedStatement) throws Exception {
                    if (Read.this.getStatementPreparator() != null) {
                        Read.this.getStatementPreparator().setParameters(preparedStatement);
                    }
                }
            }));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            this.getDataSourceConfiguration().populateDisplayData(builder);
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setStatementPreparator(StatementPreparator var1);

            abstract Builder<T> setRowMapper(RowMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Read<T> build();
        }
    }

    @FunctionalInterface
    public static interface StatementPreparator
    extends Serializable {
        public void setParameters(PreparedStatement var1) throws Exception;
    }

    public static abstract class DataSourceConfiguration
    implements Serializable {
        @Nullable
        abstract String getDriverClassName();

        @Nullable
        abstract String getUrl();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        @Nullable
        abstract String getConnectionProperties();

        @Nullable
        abstract DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkArgument(dataSource != null, "dataSource can not be null");
            Preconditions.checkArgument(dataSource instanceof Serializable, "dataSource must be Serializable");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDataSource(dataSource).build();
        }

        public static DataSourceConfiguration create(String driverClassName, String url) {
            Preconditions.checkArgument(driverClassName != null, "driverClassName can not be null");
            Preconditions.checkArgument(url != null, "url can not be null");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDriverClassName(driverClassName).setUrl(url).build();
        }

        public DataSourceConfiguration withUsername(String username) {
            return this.builder().setUsername(username).build();
        }

        public DataSourceConfiguration withPassword(String password) {
            return this.builder().setPassword(password).build();
        }

        public DataSourceConfiguration withConnectionProperties(String connectionProperties) {
            Preconditions.checkArgument(connectionProperties != null, "connectionProperties can not be null");
            return this.builder().setConnectionProperties(connectionProperties).build();
        }

        private void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcDriverClassName", (String)this.getDriverClassName()));
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", (String)this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            }
        }

        DataSource buildDatasource() throws Exception {
            if (this.getDataSource() != null) {
                return this.getDataSource();
            }
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(this.getDriverClassName());
            basicDataSource.setUrl(this.getUrl());
            basicDataSource.setUsername(this.getUsername());
            basicDataSource.setPassword(this.getPassword());
            if (this.getConnectionProperties() != null) {
                basicDataSource.setConnectionProperties(this.getConnectionProperties());
            }
            return basicDataSource;
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDriverClassName(String var1);

            abstract Builder setUrl(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setConnectionProperties(String var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    @FunctionalInterface
    public static interface RowMapper<T>
    extends Serializable {
        public T mapRow(ResultSet var1) throws Exception;
    }
}

