/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.options.ValueProvider;

final class AutoValue_JdbcIO_Write<T>
extends JdbcIO.Write<T> {
    private final JdbcIO.DataSourceConfiguration dataSourceConfiguration;
    private final ValueProvider<String> statement;
    private final long batchSize;
    private final JdbcIO.PreparedStatementSetter<T> preparedStatementSetter;
    private final JdbcIO.RetryStrategy retryStrategy;

    private AutoValue_JdbcIO_Write(@Nullable JdbcIO.DataSourceConfiguration dataSourceConfiguration, @Nullable ValueProvider<String> statement, long batchSize, @Nullable JdbcIO.PreparedStatementSetter<T> preparedStatementSetter, @Nullable JdbcIO.RetryStrategy retryStrategy) {
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.statement = statement;
        this.batchSize = batchSize;
        this.preparedStatementSetter = preparedStatementSetter;
        this.retryStrategy = retryStrategy;
    }

    @Override
    @Nullable
    JdbcIO.DataSourceConfiguration getDataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    @Override
    @Nullable
    ValueProvider<String> getStatement() {
        return this.statement;
    }

    @Override
    long getBatchSize() {
        return this.batchSize;
    }

    @Override
    @Nullable
    JdbcIO.PreparedStatementSetter<T> getPreparedStatementSetter() {
        return this.preparedStatementSetter;
    }

    @Override
    @Nullable
    JdbcIO.RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcIO.Write) {
            JdbcIO.Write that = (JdbcIO.Write)((Object)o);
            return (this.dataSourceConfiguration == null ? that.getDataSourceConfiguration() == null : this.dataSourceConfiguration.equals(that.getDataSourceConfiguration())) && (this.statement == null ? that.getStatement() == null : this.statement.equals(that.getStatement())) && this.batchSize == that.getBatchSize() && (this.preparedStatementSetter == null ? that.getPreparedStatementSetter() == null : this.preparedStatementSetter.equals(that.getPreparedStatementSetter())) && (this.retryStrategy == null ? that.getRetryStrategy() == null : this.retryStrategy.equals(that.getRetryStrategy()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataSourceConfiguration == null ? 0 : this.dataSourceConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.statement == null ? 0 : this.statement.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.batchSize >>> 32 ^ this.batchSize);
        h$ *= 1000003;
        h$ ^= this.preparedStatementSetter == null ? 0 : this.preparedStatementSetter.hashCode();
        h$ *= 1000003;
        return h$ ^= this.retryStrategy == null ? 0 : this.retryStrategy.hashCode();
    }

    @Override
    JdbcIO.Write.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends JdbcIO.Write.Builder<T> {
        private JdbcIO.DataSourceConfiguration dataSourceConfiguration;
        private ValueProvider<String> statement;
        private Long batchSize;
        private JdbcIO.PreparedStatementSetter<T> preparedStatementSetter;
        private JdbcIO.RetryStrategy retryStrategy;

        Builder() {
        }

        private Builder(JdbcIO.Write<T> source) {
            this.dataSourceConfiguration = source.getDataSourceConfiguration();
            this.statement = source.getStatement();
            this.batchSize = source.getBatchSize();
            this.preparedStatementSetter = source.getPreparedStatementSetter();
            this.retryStrategy = source.getRetryStrategy();
        }

        @Override
        JdbcIO.Write.Builder<T> setDataSourceConfiguration(JdbcIO.DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        @Override
        JdbcIO.Write.Builder<T> setStatement(ValueProvider<String> statement) {
            this.statement = statement;
            return this;
        }

        @Override
        JdbcIO.Write.Builder<T> setBatchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        JdbcIO.Write.Builder<T> setPreparedStatementSetter(JdbcIO.PreparedStatementSetter<T> preparedStatementSetter) {
            this.preparedStatementSetter = preparedStatementSetter;
            return this;
        }

        @Override
        JdbcIO.Write.Builder<T> setRetryStrategy(JdbcIO.RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        @Override
        JdbcIO.Write<T> build() {
            String missing = "";
            if (this.batchSize == null) {
                missing = missing + " batchSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcIO_Write(this.dataSourceConfiguration, this.statement, this.batchSize, this.preparedStatementSetter, this.retryStrategy);
        }
    }
}

