/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;

public class SerializableConfiguration
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private transient Configuration conf;

    public SerializableConfiguration() {
    }

    public SerializableConfiguration(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("Configuration must not be null.");
        }
        this.conf = conf;
    }

    public Configuration get() {
        return this.conf;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.conf.size());
        for (Map.Entry entry : this.conf) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.conf = new Configuration(false);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.conf.set(in.readUTF(), in.readUTF());
        }
    }

    public static Job newJob(@Nullable SerializableConfiguration conf) throws IOException {
        if (conf == null) {
            return Job.getInstance();
        }
        Job job = Job.getInstance((Configuration)new Configuration(false));
        for (Map.Entry entry : conf.get()) {
            job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
        }
        return job;
    }

    public static Configuration newConfiguration(@Nullable SerializableConfiguration conf) {
        if (conf == null) {
            return new Configuration();
        }
        return conf.get();
    }
}

