/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StandardCoder;
import org.apache.beam.sdk.util.CloudObject;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class WritableCoder<T extends Writable>
extends StandardCoder<T> {
    private static final long serialVersionUID = 0L;
    private final Class<T> type;

    public static <T extends Writable> WritableCoder<T> of(Class<T> clazz) {
        return new WritableCoder<T>(clazz);
    }

    @JsonCreator
    public static WritableCoder<?> of(@JsonProperty(value="type") String classType) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(classType);
        if (!Writable.class.isAssignableFrom(clazz)) {
            throw new ClassNotFoundException("Class " + classType + " does not implement Writable");
        }
        return WritableCoder.of(clazz);
    }

    public WritableCoder(Class<T> type) {
        this.type = type;
    }

    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException {
        value.write((DataOutput)new DataOutputStream(outStream));
    }

    public T decode(InputStream inStream, Coder.Context context) throws IOException {
        try {
            if (this.type == NullWritable.class) {
                return (T)NullWritable.get();
            }
            Writable t = (Writable)this.type.newInstance();
            t.readFields((DataInput)new DataInputStream(inStream));
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CoderException("unable to deserialize record", (Throwable)e);
        }
    }

    public List<Coder<?>> getCoderArguments() {
        return null;
    }

    public CloudObject initializeCloudObject() {
        CloudObject result = CloudObject.forClass(((Object)((Object)this)).getClass());
        result.put("type", (Object)this.type.getName());
        return result;
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "Hadoop Writable may be non-deterministic.");
    }
}

