/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedBytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadAll;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationCellCounter;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationKeyEncoder;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadSpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SpannerIO {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerIO.class);
    private static final long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;
    private static final int DEFAULT_MAX_NUM_MUTATIONS = 5000;
    private static final int DEFAULT_GROUPING_FACTOR = 1000;

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setReadOperation(ReadOperation.create()).setBatching(true).build();
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static ReadAll readAll() {
        return new AutoValue_SpannerIO_ReadAll.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setBatching(true).build();
    }

    @Experimental
    public static CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    @Experimental
    public static Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).setMaxNumMutations(5000L).setGroupingFactor(1000).setFailureMode(FailureMode.FAIL_FAST).build();
    }

    private SpannerIO() {
    }

    private static class WriteToSpannerFn
    extends DoFn<Iterable<MutationGroup>, Void> {
        private transient SpannerAccessor spannerAccessor;
        private final SpannerConfig spannerConfig;
        private final FailureMode failureMode;
        private final Counter mutationGroupBatchesCounter = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches");
        private final Counter mutationGroupWriteSuccessCounter = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_success");
        private final Counter mutationGroupWriteFailCounter = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_fail");
        private final TupleTag<MutationGroup> failedTag;

        WriteToSpannerFn(SpannerConfig spannerConfig, FailureMode failureMode, TupleTag<MutationGroup> failedTag) {
            this.spannerConfig = spannerConfig;
            this.failureMode = failureMode;
            this.failedTag = failedTag;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = this.spannerConfig.connectToSpanner();
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Iterable mutations = (Iterable)c.element();
            boolean tryIndividual = false;
            try {
                this.mutationGroupBatchesCounter.inc();
                Iterable batch = Iterables.concat((Iterable)mutations);
                this.spannerAccessor.getDatabaseClient().writeAtLeastOnce(batch);
                this.mutationGroupWriteSuccessCounter.inc((long)Iterables.size((Iterable)mutations));
                return;
            }
            catch (SpannerException e) {
                if (this.failureMode != FailureMode.REPORT_FAILURES) {
                    if (this.failureMode == FailureMode.FAIL_FAST) {
                        throw e;
                    }
                    throw new IllegalArgumentException("Unknown failure mode " + (Object)((Object)this.failureMode));
                }
                tryIndividual = true;
                if (tryIndividual) {
                    for (MutationGroup mg : mutations) {
                        try {
                            this.spannerAccessor.getDatabaseClient().writeAtLeastOnce((Iterable)mg);
                            this.mutationGroupWriteSuccessCounter.inc();
                        }
                        catch (SpannerException e2) {
                            this.mutationGroupWriteFailCounter.inc();
                            LOG.warn("Failed to write the mutation group: " + mg, (Throwable)e2);
                            c.output(this.failedTag, (Object)mg);
                        }
                    }
                }
                return;
            }
        }
    }

    @VisibleForTesting
    static class BatchableMutationFilterFn
    extends DoFn<MutationGroup, MutationGroup> {
        private final PCollectionView<SpannerSchema> schemaView;
        private final TupleTag<Iterable<MutationGroup>> unbatchableMutationsTag;
        private final long batchSizeBytes;
        private final long maxNumMutations;
        private final Counter batchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"batchable_mutation_groups");
        private final Counter unBatchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"unbatchable_mutation_groups");

        BatchableMutationFilterFn(PCollectionView<SpannerSchema> schemaView, TupleTag<Iterable<MutationGroup>> unbatchableMutationsTag, long batchSizeBytes, long maxNumMutations) {
            this.schemaView = schemaView;
            this.unbatchableMutationsTag = unbatchableMutationsTag;
            this.batchSizeBytes = batchSizeBytes;
            this.maxNumMutations = maxNumMutations;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            MutationGroup mg = (MutationGroup)c.element();
            if (mg.primary().getOperation() == Mutation.Op.DELETE && !MutationUtils.isPointDelete(mg.primary())) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
                return;
            }
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            if (groupSize >= this.batchSizeBytes || groupCells >= this.maxNumMutations) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
            } else {
                c.output((Object)mg);
                this.batchableMutationGroupsCounter.inc();
            }
        }
    }

    @VisibleForTesting
    static class BatchFn
    extends DoFn<Iterable<KV<byte[], byte[]>>, Iterable<MutationGroup>> {
        private final long maxBatchSizeBytes;
        private final long maxNumMutations;
        private final PCollectionView<SpannerSchema> schemaView;

        BatchFn(long maxBatchSizeBytes, long maxNumMutations, PCollectionView<SpannerSchema> schemaView) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            this.maxNumMutations = maxNumMutations;
            this.schemaView = schemaView;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            ImmutableList.Builder batch = ImmutableList.builder();
            long batchSizeBytes = 0L;
            long batchCells = 0L;
            for (KV kv : (Iterable)c.element()) {
                MutationGroup mg = WriteGrouped.decode((byte[])kv.getValue());
                long groupSize = MutationSizeEstimator.sizeOf(mg);
                long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
                if (batchCells + groupCells > this.maxNumMutations || batchSizeBytes + groupSize > this.maxBatchSizeBytes) {
                    c.output((Object)batch.build());
                    batch = ImmutableList.builder();
                    batchSizeBytes = 0L;
                    batchCells = 0L;
                }
                batch.add((Object)mg);
                batchSizeBytes += groupSize;
                batchCells += groupCells;
            }
            if (batchCells > 0L) {
                c.output((Object)batch.build());
            }
        }
    }

    @VisibleForTesting
    static class GatherBundleAndSortFn
    extends DoFn<MutationGroup, Iterable<KV<byte[], byte[]>>> {
        private final long maxBatchSizeBytes;
        private final long maxNumMutations;
        private long batchSizeBytes;
        private long batchCells;
        private final PCollectionView<SpannerSchema> schemaView;
        private transient ArrayList<KV<byte[], byte[]>> mutationsToSort = null;

        GatherBundleAndSortFn(long maxBatchSizeBytes, long maxNumMutations, long groupingFactor, PCollectionView<SpannerSchema> schemaView) {
            this.maxBatchSizeBytes = maxBatchSizeBytes * groupingFactor;
            this.maxNumMutations = maxNumMutations * groupingFactor;
            this.schemaView = schemaView;
        }

        @DoFn.StartBundle
        public synchronized void startBundle() throws Exception {
            if (this.mutationsToSort != null) {
                throw new IllegalStateException("Sorter should be null here");
            }
            this.initSorter();
        }

        private void initSorter() {
            this.mutationsToSort = new ArrayList((int)this.maxNumMutations);
            this.batchSizeBytes = 0L;
            this.batchCells = 0L;
        }

        @DoFn.FinishBundle
        public synchronized void finishBundle(DoFn.FinishBundleContext c) throws Exception {
            c.output(this.sortAndGetList(), Instant.now(), (BoundedWindow)GlobalWindow.INSTANCE);
        }

        private Iterable<KV<byte[], byte[]>> sortAndGetList() throws IOException {
            this.mutationsToSort.sort(EncodedKvMutationGroupComparator.INSTANCE);
            ArrayList<KV<byte[], byte[]>> tmp = this.mutationsToSort;
            this.mutationsToSort = null;
            return tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            MutationKeyEncoder encoder = new MutationKeyEncoder(spannerSchema);
            MutationGroup mg = (MutationGroup)c.element();
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            GatherBundleAndSortFn gatherBundleAndSortFn = this;
            synchronized (gatherBundleAndSortFn) {
                if (this.batchCells + groupCells > this.maxNumMutations || this.batchSizeBytes + groupSize > this.maxBatchSizeBytes) {
                    c.output(this.sortAndGetList());
                    this.initSorter();
                }
                this.mutationsToSort.add((KV<byte[], byte[]>)KV.of((Object)encoder.encodeTableNameAndKey(mg.primary()), (Object)WriteGrouped.encode(mg)));
                this.batchSizeBytes += groupSize;
                this.batchCells += groupCells;
            }
        }
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, SpannerWriteResult> {
        private final Write spec;
        private static final TupleTag<MutationGroup> BATCHABLE_MUTATIONS_TAG = new TupleTag<MutationGroup>("batchableMutations"){};
        private static final TupleTag<Iterable<MutationGroup>> UNBATCHABLE_MUTATIONS_TAG = new TupleTag<Iterable<MutationGroup>>("unbatchableMutations"){};
        private static final TupleTag<Void> MAIN_OUT_TAG = new TupleTag<Void>("mainOut"){};
        private static final TupleTag<MutationGroup> FAILED_MUTATIONS_TAG = new TupleTag<MutationGroup>("failedMutations"){};
        private static final SerializableCoder<MutationGroup> CODER = SerializableCoder.of(MutationGroup.class);

        public WriteGrouped(Write spec) {
            this.spec = spec;
        }

        public SpannerWriteResult expand(PCollection<MutationGroup> input) {
            PCollection schemaSeed = (PCollection)input.getPipeline().apply("Create Seed", (PTransform)Create.of((Object)null, (Object[])new Void[0]));
            if (this.spec.getSchemaReadySignal() != null) {
                schemaSeed = (PCollection)schemaSeed.apply("Wait for schema", (PTransform)Wait.on((PCollection[])new PCollection[]{this.spec.getSchemaReadySignal()}));
            }
            PCollectionView schemaView = (PCollectionView)((PCollection)schemaSeed.apply("Read information schema", (PTransform)ParDo.of((DoFn)new ReadSpannerSchema(this.spec.getSpannerConfig())))).apply("Schema View", (PTransform)View.asSingleton());
            PCollectionTuple filteredMutations = (PCollectionTuple)((PCollection)input.apply("To Global Window", (PTransform)Window.into((WindowFn)new GlobalWindows()))).apply("Filter Unbatchable Mutations", (PTransform)ParDo.of((DoFn)new BatchableMutationFilterFn((PCollectionView<SpannerSchema>)schemaView, UNBATCHABLE_MUTATIONS_TAG, this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations())).withSideInputs(new PCollectionView[]{schemaView}).withOutputTags(BATCHABLE_MUTATIONS_TAG, TupleTagList.of(UNBATCHABLE_MUTATIONS_TAG)));
            PCollection batchedMutations = (PCollection)((PCollection)filteredMutations.get(BATCHABLE_MUTATIONS_TAG).apply("Gather And Sort", (PTransform)ParDo.of((DoFn)new GatherBundleAndSortFn(this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getGroupingFactor(), (PCollectionView<SpannerSchema>)schemaView)).withSideInputs(new PCollectionView[]{schemaView}))).apply("Create Batches", (PTransform)ParDo.of((DoFn)new BatchFn(this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), (PCollectionView<SpannerSchema>)schemaView)).withSideInputs(new PCollectionView[]{schemaView}));
            PCollectionTuple result = (PCollectionTuple)((PCollection)PCollectionList.of((PCollection)filteredMutations.get(UNBATCHABLE_MUTATIONS_TAG)).and(batchedMutations).apply("Merge", (PTransform)Flatten.pCollections())).apply("Write mutations to Spanner", (PTransform)ParDo.of((DoFn)new WriteToSpannerFn(this.spec.getSpannerConfig(), this.spec.getFailureMode(), FAILED_MUTATIONS_TAG)).withOutputTags(MAIN_OUT_TAG, TupleTagList.of(FAILED_MUTATIONS_TAG)));
            return new SpannerWriteResult(input.getPipeline(), (PCollection<Void>)result.get(MAIN_OUT_TAG), (PCollection<MutationGroup>)result.get(FAILED_MUTATIONS_TAG), FAILED_MUTATIONS_TAG);
        }

        @VisibleForTesting
        static MutationGroup decode(byte[] bytes) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                return (MutationGroup)CODER.decode((InputStream)bis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @VisibleForTesting
        static byte[] encode(MutationGroup g) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                CODER.encode((Serializable)g, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bos.toByteArray();
        }
    }

    private static enum EncodedKvMutationGroupComparator implements Comparator<KV<byte[], byte[]>>,
    Serializable
    {
        INSTANCE{

            @Override
            public int compare(KV<byte[], byte[]> a, KV<byte[], byte[]> b) {
                return UnsignedBytes.lexicographicalComparator().compare((byte[])a.getKey(), (byte[])b.getKey());
            }
        };

    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, SpannerWriteResult> {
        abstract SpannerConfig getSpannerConfig();

        abstract long getBatchSizeBytes();

        abstract long getMaxNumMutations();

        abstract FailureMode getFailureMode();

        @Nullable
        abstract PCollection getSchemaReadySignal();

        abstract int getGroupingFactor();

        abstract Builder toBuilder();

        public Write withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Write withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Write withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Write withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Write withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Write withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Write withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public Write withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public Write withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        @VisibleForTesting
        Write withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public Write withBatchSizeBytes(long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public Write withFailureMode(FailureMode failureMode) {
            return this.toBuilder().setFailureMode(failureMode).build();
        }

        public Write withMaxNumMutations(long maxNumMutations) {
            return this.toBuilder().setMaxNumMutations(maxNumMutations).build();
        }

        public Write withSchemaReadySignal(PCollection signal) {
            return this.toBuilder().setSchemaReadySignal(signal).build();
        }

        public Write withGroupingFactor(int groupingFactor) {
            return this.toBuilder().setGroupingFactor(groupingFactor).build();
        }

        public SpannerWriteResult expand(PCollection<Mutation> input) {
            this.getSpannerConfig().validate();
            return (SpannerWriteResult)((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)new WriteGrouped(this));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Batch Size in Bytes"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setBatchSizeBytes(long var1);

            abstract Builder setMaxNumMutations(long var1);

            abstract Builder setFailureMode(FailureMode var1);

            abstract Builder setSchemaReadySignal(PCollection var1);

            abstract Builder setGroupingFactor(int var1);

            abstract Write build();
        }
    }

    public static enum FailureMode {
        FAIL_FAST,
        REPORT_FAILURES;

    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class CreateTransaction
    extends PTransform<PBegin, PCollectionView<Transaction>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public PCollectionView<Transaction> expand(PBegin input) {
            this.getSpannerConfig().validate();
            return (PCollectionView)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this)))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public CreateTransaction withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public CreateTransaction withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public CreateTransaction withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public CreateTransaction withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public CreateTransaction withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public CreateTransaction withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public CreateTransaction withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public CreateTransaction withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public CreateTransaction withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        @VisibleForTesting
        CreateTransaction withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public CreateTransaction withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setSpannerConfig(SpannerConfig var1);

            public abstract Builder setTimestampBound(TimestampBound var1);

            public abstract CreateTransaction build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        abstract ReadOperation getReadOperation();

        @Nullable
        abstract TimestampBound getTimestampBound();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        @Nullable
        abstract PartitionOptions getPartitionOptions();

        abstract Boolean getBatching();

        abstract Builder toBuilder();

        public Read withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Read withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Read withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Read withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Read withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Read withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Read withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public Read withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public Read withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public Read withBatching(boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        @VisibleForTesting
        Read withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public Read withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public Read withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public Read withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public Read withTable(String table) {
            return this.withReadOperation(this.getReadOperation().withTable(table));
        }

        public Read withReadOperation(ReadOperation operation) {
            return this.toBuilder().setReadOperation(operation).build();
        }

        public Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public Read withColumns(List<String> columns) {
            return this.withReadOperation(this.getReadOperation().withColumns(columns));
        }

        public Read withQuery(Statement statement) {
            return this.withReadOperation(this.getReadOperation().withQuery(statement));
        }

        public Read withQuery(String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public Read withKeySet(KeySet keySet) {
            return this.withReadOperation(this.getReadOperation().withKeySet(keySet));
        }

        public Read withIndex(String index) {
            return this.withReadOperation(this.getReadOperation().withIndex(index));
        }

        public Read withPartitionOptions(PartitionOptions partitionOptions) {
            return this.withReadOperation(this.getReadOperation().withPartitionOptions(partitionOptions));
        }

        public PCollection<Struct> expand(PBegin input) {
            this.getSpannerConfig().validate();
            Preconditions.checkArgument((this.getTimestampBound() != null ? 1 : 0) != 0, (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getReadOperation().getQuery() == null) {
                if (this.getReadOperation().getTable() != null) {
                    Preconditions.checkNotNull(this.getReadOperation().getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getReadOperation().getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
            ReadAll readAll = SpannerIO.readAll().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound()).withBatching(this.getBatching()).withTransaction(this.getTransaction());
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.getReadOperation(), (Object[])new ReadOperation[0]))).apply("Execute query", (PTransform)readAll);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setReadOperation(ReadOperation var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Builder setPartitionOptions(PartitionOptions var1);

            abstract Builder setBatching(Boolean var1);

            abstract Read build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        @Nullable
        abstract TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public ReadAll withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public ReadAll withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public ReadAll withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public ReadAll withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public ReadAll withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public ReadAll withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public ReadAll withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public ReadAll withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public ReadAll withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        ReadAll withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public ReadAll withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public ReadAll withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public ReadAll withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public ReadAll withBatching(boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        abstract Boolean getBatching();

        public PCollection<Struct> expand(PCollection<ReadOperation> input) {
            PTransform readTransform = this.getBatching() != false ? BatchSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound()) : NaiveSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound());
            return (PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Cloud Spanner", readTransform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setBatching(Boolean var1);

            abstract ReadAll build();
        }
    }
}

