/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ChangeStreamMetrics
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 7298901109362981596L;
    public static final @UnknownKeyFor @NonNull @Initialized Counter LIST_PARTITIONS_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"list_partitions_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_SPLIT_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_record_split_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_MERGE_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_record_merge_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_RECONCILED_WITH_TOKEN_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_reconciled_with_token_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_RECONCILED_WITHOUT_TOKEN_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_reconciled_without_token_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter ORPHANED_NEW_PARTITION_CLEANED_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"orphaned_new_partition_cleaned_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter HEARTBEAT_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"heartbeat_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter CLOSESTREAM_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"closestream_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter CHANGE_STREAM_MUTATION_USER_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"change_stream_mutation_user_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter CHANGE_STREAM_MUTATION_GC_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"change_stream_mutation_gc_count");
    public static final @UnknownKeyFor @NonNull @Initialized Distribution PROCESSING_DELAY_FROM_COMMIT_TIMESTAMP = Metrics.distribution(ChangeStreamMetrics.class, (String)"processing_delay_from_commit_timestamp");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_STREAM_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_stream_count");

    public void incListPartitionsCount() {
        this.inc(LIST_PARTITIONS_COUNT);
    }

    public void incPartitionSplitCount() {
        this.inc(PARTITION_SPLIT_COUNT);
    }

    public void incPartitionMergeCount() {
        this.inc(PARTITION_MERGE_COUNT);
    }

    public void incPartitionReconciledWithTokenCount() {
        this.inc(PARTITION_RECONCILED_WITH_TOKEN_COUNT);
    }

    public void incPartitionReconciledWithoutTokenCount() {
        this.inc(PARTITION_RECONCILED_WITHOUT_TOKEN_COUNT);
    }

    public void incOrphanedNewPartitionCleanedCount() {
        this.inc(ORPHANED_NEW_PARTITION_CLEANED_COUNT);
    }

    public void incHeartbeatCount() {
        this.inc(HEARTBEAT_COUNT);
    }

    public void incClosestreamCount() {
        this.inc(CLOSESTREAM_COUNT);
    }

    public void incChangeStreamMutationUserCounter() {
        this.inc(CHANGE_STREAM_MUTATION_USER_COUNT);
    }

    public void incChangeStreamMutationGcCounter() {
        this.inc(CHANGE_STREAM_MUTATION_GC_COUNT);
    }

    public void incPartitionStreamCount() {
        this.inc(PARTITION_STREAM_COUNT);
    }

    public void decPartitionStreamCount() {
        this.dec(PARTITION_STREAM_COUNT);
    }

    public void updateProcessingDelayFromCommitTimestamp(@UnknownKeyFor @NonNull @Initialized long durationInMilli) {
        this.update(PROCESSING_DELAY_FROM_COMMIT_TIMESTAMP, durationInMilli);
    }

    private void inc(@UnknownKeyFor @NonNull @Initialized Counter counter) {
        counter.inc();
    }

    private void dec(@UnknownKeyFor @NonNull @Initialized Counter counter) {
        counter.dec();
    }

    private void update(@UnknownKeyFor @NonNull @Initialized Distribution distribution, @UnknownKeyFor @NonNull @Initialized long value) {
        distribution.update(value);
    }
}

