/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubMessageSchemaCoder {
    private static final @UnknownKeyFor @NonNull @Initialized Schema PUBSUB_MESSAGE_SCHEMA = Schema.builder().addByteArrayField("payload").addNullableStringField("topic").addNullableMapField("attributes", Schema.FieldType.STRING, Schema.FieldType.STRING).addNullableStringField("message_id").addNullableStringField("ordering_key").build();
    private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, @UnknownKeyFor @NonNull @Initialized Row> TO_ROW = (SerializableFunction & Serializable)message -> Row.withSchema((Schema)PUBSUB_MESSAGE_SCHEMA).attachValues(new Object[]{message.getPayload(), message.getTopic(), message.getAttributeMap(), message.getMessageId(), message.getOrderingKey()});
    private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized PubsubMessage> FROM_ROW = (SerializableFunction & Serializable)row -> {
        PubsubMessage message = new PubsubMessage((byte[])Preconditions.checkNotNull((Object)row.getBytes("payload")), row.getMap("attributes"), row.getString("message_id"), row.getString("ordering_key"));
        @Nullable String topic = row.getString("topic");
        if (topic != null) {
            message = message.withTopic(topic);
        }
        return message;
    };

    public static @UnknownKeyFor @NonNull @Initialized SchemaCoder<@UnknownKeyFor @NonNull @Initialized PubsubMessage> getSchemaCoder() {
        return SchemaCoder.of((Schema)PUBSUB_MESSAGE_SCHEMA, (TypeDescriptor)TypeDescriptor.of(PubsubMessage.class), TO_ROW, FROM_ROW);
    }
}

