/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.DateTime;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;

public abstract class PubsubClient
implements Closeable {
    @Nullable
    private static Long asMsSinceEpoch(@Nullable String timestamp) {
        if (Strings.isNullOrEmpty((String)timestamp)) {
            return null;
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (IllegalArgumentException e1) {
            return DateTime.parseRfc3339((String)timestamp).getValue();
        }
    }

    protected static long extractTimestamp(@Nullable String timestampAttribute, @Nullable String pubsubTimestamp, @Nullable Map<String, String> attributes) {
        Long timestampMsSinceEpoch;
        if (Strings.isNullOrEmpty((String)timestampAttribute)) {
            timestampMsSinceEpoch = PubsubClient.asMsSinceEpoch(pubsubTimestamp);
            Preconditions.checkArgument((timestampMsSinceEpoch != null ? 1 : 0) != 0, (String)"Cannot interpret PubSub publish timestamp: %s", (Object)pubsubTimestamp);
        } else {
            String value = attributes == null ? null : attributes.get(timestampAttribute);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"PubSub message is missing a value for timestamp attribute %s", (Object)timestampAttribute);
            timestampMsSinceEpoch = PubsubClient.asMsSinceEpoch(value);
            Preconditions.checkArgument((timestampMsSinceEpoch != null ? 1 : 0) != 0, (String)"Cannot interpret value of attribute %s as timestamp: %s", (Object)timestampAttribute, (Object)value);
        }
        return timestampMsSinceEpoch;
    }

    public static ProjectPath projectPathFromPath(String path) {
        return new ProjectPath(path);
    }

    public static ProjectPath projectPathFromId(String projectId) {
        return new ProjectPath(String.format("projects/%s", projectId));
    }

    public static SubscriptionPath subscriptionPathFromPath(String path) {
        return new SubscriptionPath(path);
    }

    public static SubscriptionPath subscriptionPathFromName(String projectId, String subscriptionName) {
        return new SubscriptionPath(String.format("projects/%s/subscriptions/%s", projectId, subscriptionName));
    }

    public static TopicPath topicPathFromPath(String path) {
        return new TopicPath(path);
    }

    public static TopicPath topicPathFromName(String projectId, String topicName) {
        return new TopicPath(String.format("projects/%s/topics/%s", projectId, topicName));
    }

    public abstract int publish(TopicPath var1, List<OutgoingMessage> var2) throws IOException;

    public abstract List<IncomingMessage> pull(long var1, SubscriptionPath var3, int var4, boolean var5) throws IOException;

    public abstract void acknowledge(SubscriptionPath var1, List<String> var2) throws IOException;

    public abstract void modifyAckDeadline(SubscriptionPath var1, List<String> var2, int var3) throws IOException;

    public abstract void createTopic(TopicPath var1) throws IOException;

    public abstract void deleteTopic(TopicPath var1) throws IOException;

    public abstract List<TopicPath> listTopics(ProjectPath var1) throws IOException;

    public abstract void createSubscription(TopicPath var1, SubscriptionPath var2, int var3) throws IOException;

    public SubscriptionPath createRandomSubscription(ProjectPath project, TopicPath topic, int ackDeadlineSeconds) throws IOException {
        String subscriptionName = topic.getName() + "_beam_" + ThreadLocalRandom.current().nextLong();
        SubscriptionPath subscription = PubsubClient.subscriptionPathFromName(project.getId(), subscriptionName);
        this.createSubscription(topic, subscription, ackDeadlineSeconds);
        return subscription;
    }

    public abstract void deleteSubscription(SubscriptionPath var1) throws IOException;

    public abstract List<SubscriptionPath> listSubscriptions(ProjectPath var1, TopicPath var2) throws IOException;

    public abstract int ackDeadlineSeconds(SubscriptionPath var1) throws IOException;

    public abstract boolean isEOF();

    static class IncomingMessage
    implements Serializable {
        public final byte[] elementBytes;
        public Map<String, String> attributes;
        public final long timestampMsSinceEpoch;
        public final long requestTimeMsSinceEpoch;
        public final String ackId;
        public final String recordId;

        public IncomingMessage(byte[] elementBytes, Map<String, String> attributes, long timestampMsSinceEpoch, long requestTimeMsSinceEpoch, String ackId, String recordId) {
            this.elementBytes = elementBytes;
            this.attributes = attributes;
            this.timestampMsSinceEpoch = timestampMsSinceEpoch;
            this.requestTimeMsSinceEpoch = requestTimeMsSinceEpoch;
            this.ackId = ackId;
            this.recordId = recordId;
        }

        public IncomingMessage withRequestTime(long requestTimeMsSinceEpoch) {
            return new IncomingMessage(this.elementBytes, this.attributes, this.timestampMsSinceEpoch, requestTimeMsSinceEpoch, this.ackId, this.recordId);
        }

        public String toString() {
            return String.format("IncomingMessage(%db, %dms)", this.elementBytes.length, this.timestampMsSinceEpoch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncomingMessage that = (IncomingMessage)o;
            return this.timestampMsSinceEpoch == that.timestampMsSinceEpoch && this.requestTimeMsSinceEpoch == that.requestTimeMsSinceEpoch && this.ackId.equals(that.ackId) && this.recordId.equals(that.recordId) && Arrays.equals(this.elementBytes, that.elementBytes) && Objects.equal(this.attributes, that.attributes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.elementBytes), this.attributes, this.timestampMsSinceEpoch, this.requestTimeMsSinceEpoch, this.ackId, this.recordId});
        }
    }

    static class OutgoingMessage
    implements Serializable {
        public final byte[] elementBytes;
        public final Map<String, String> attributes;
        public final long timestampMsSinceEpoch;
        @Nullable
        public final String recordId;

        public OutgoingMessage(byte[] elementBytes, Map<String, String> attributes, long timestampMsSinceEpoch, @Nullable String recordId) {
            this.elementBytes = elementBytes;
            this.attributes = attributes;
            this.timestampMsSinceEpoch = timestampMsSinceEpoch;
            this.recordId = recordId;
        }

        public String toString() {
            return String.format("OutgoingMessage(%db, %dms)", this.elementBytes.length, this.timestampMsSinceEpoch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutgoingMessage that = (OutgoingMessage)o;
            return this.timestampMsSinceEpoch == that.timestampMsSinceEpoch && Arrays.equals(this.elementBytes, that.elementBytes) && Objects.equal(this.attributes, that.attributes) && Objects.equal((Object)this.recordId, (Object)that.recordId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.elementBytes), this.attributes, this.timestampMsSinceEpoch, this.recordId});
        }
    }

    public static class TopicPath
    implements Serializable {
        private final String path;

        TopicPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)this.path);
            Preconditions.checkState((splits.size() == 4 ? 1 : 0) != 0, (String)"Malformed topic path %s", (Object)this.path);
            return (String)splits.get(3);
        }

        public String getV1Beta1Path() {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)this.path);
            Preconditions.checkState((splits.size() == 4 ? 1 : 0) != 0, (String)"Malformed topic path %s", (Object)this.path);
            return String.format("/topics/%s/%s", splits.get(1), splits.get(3));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicPath topicPath = (TopicPath)o;
            return this.path.equals(topicPath.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path;
        }
    }

    public static class SubscriptionPath
    implements Serializable {
        private final String projectId;
        private final String subscriptionName;

        SubscriptionPath(String path) {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)path);
            Preconditions.checkState((splits.size() == 4 && "projects".equals(splits.get(0)) && "subscriptions".equals(splits.get(2)) ? 1 : 0) != 0, (String)"Malformed subscription path %s: must be of the form \"projects/\" + <project id> + \"subscriptions\"", (Object)path);
            this.projectId = (String)splits.get(1);
            this.subscriptionName = (String)splits.get(3);
        }

        public String getPath() {
            return String.format("projects/%s/subscriptions/%s", this.projectId, this.subscriptionName);
        }

        public String getName() {
            return this.subscriptionName;
        }

        public String getV1Beta1Path() {
            return String.format("/subscriptions/%s/%s", this.projectId, this.subscriptionName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionPath that = (SubscriptionPath)o;
            return this.subscriptionName.equals(that.subscriptionName) && this.projectId.equals(that.projectId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.projectId, this.subscriptionName});
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static class ProjectPath
    implements Serializable {
        private final String projectId;

        ProjectPath(String path) {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)path);
            Preconditions.checkArgument((splits.size() == 2 && "projects".equals(splits.get(0)) ? 1 : 0) != 0, (String)"Malformed project path \"%s\": must be of the form \"projects/\" + <project id>", (Object)path);
            this.projectId = (String)splits.get(1);
        }

        public String getPath() {
            return String.format("projects/%s", this.projectId);
        }

        public String getId() {
            return this.projectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectPath that = (ProjectPath)o;
            return this.projectId.equals(that.projectId);
        }

        public int hashCode() {
            return this.projectId.hashCode();
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static interface PubsubClientFactory
    extends Serializable {
        public PubsubClient newClient(@Nullable String var1, @Nullable String var2, PubsubOptions var3) throws IOException;

        public String getKind();
    }
}

