/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ChildPartitionsRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DataChangeRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.HeartbeatRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.PartitionEndRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.PartitionEventRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.PartitionStartRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.QueryChangeStreamAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.BytesThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.NullThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.ChangeStreamRecordMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ReadChangeStreamPartitionRangeTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoFn.UnboundedPerElement
public class ReadChangeStreamPartitionDoFn
extends DoFn<PartitionMetadata, DataChangeRecord>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -7574596218085711975L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReadChangeStreamPartitionDoFn.class);
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory;
    private final @UnknownKeyFor @NonNull @Initialized ActionFactory actionFactory;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private @UnknownKeyFor @NonNull @Initialized ThroughputEstimator<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> throughputEstimator;
    private transient @UnknownKeyFor @NonNull @Initialized QueryChangeStreamAction queryChangeStreamAction;

    public ReadChangeStreamPartitionDoFn(@UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory, @UnknownKeyFor @NonNull @Initialized ActionFactory actionFactory, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.daoFactory = daoFactory;
        this.mapperFactory = mapperFactory;
        this.actionFactory = actionFactory;
        this.metrics = metrics;
        this.throughputEstimator = new NullThroughputEstimator<DataChangeRecord>();
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition) {
        return new Instant((Object)partition.getStartTimestamp().toSqlTimestamp());
    }

    @DoFn.NewWatermarkEstimator
    public @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant watermarkEstimatorState) {
        return new WatermarkEstimators.Manual(watermarkEstimatorState);
    }

    @DoFn.GetInitialRestriction
    public @UnknownKeyFor @NonNull @Initialized TimestampRange initialRestriction(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition) {
        String token = partition.getPartitionToken();
        Timestamp startTimestamp = partition.getStartTimestamp();
        Timestamp endTimestamp = TimestampUtils.next(partition.getEndTimestamp());
        Timestamp partitionScheduledAt = partition.getScheduledAt();
        Timestamp partitionRunningAt = this.daoFactory.getPartitionMetadataDao().updateToRunning(token);
        if (partitionScheduledAt != null && partitionRunningAt != null) {
            this.metrics.updatePartitionScheduledToRunning(new Duration(partitionScheduledAt.toSqlTimestamp().getTime(), partitionRunningAt.toSqlTimestamp().getTime()));
        }
        this.metrics.incActivePartitionReadCounter();
        return TimestampRange.of(startTimestamp, endTimestamp);
    }

    @DoFn.GetSize
    public @UnknownKeyFor @NonNull @Initialized double getSize(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized TimestampRange range) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigDecimal timeGapInSeconds = BigDecimal.valueOf(this.newTracker(partition, range).getProgress().getWorkRemaining());
        BigDecimal throughput = BigDecimal.valueOf(this.throughputEstimator.get());
        double size = timeGapInSeconds.multiply(throughput).min(MAX_DOUBLE).doubleValue();
        LOG.debug("getSize() = {} ({} timeGapInSeconds * {} throughput)", new Object[]{size, timeGapInSeconds, throughput});
        return size;
    }

    @DoFn.NewTracker
    public @UnknownKeyFor @NonNull @Initialized ReadChangeStreamPartitionRangeTracker newTracker(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized TimestampRange range) {
        return new ReadChangeStreamPartitionRangeTracker(partition, range);
    }

    @DoFn.Setup
    public void setup() {
        PartitionMetadataDao partitionMetadataDao = this.daoFactory.getPartitionMetadataDao();
        ChangeStreamDao changeStreamDao = this.daoFactory.getChangeStreamDao();
        ChangeStreamRecordMapper changeStreamRecordMapper = this.mapperFactory.changeStreamRecordMapper();
        PartitionMetadataMapper partitionMetadataMapper = this.mapperFactory.partitionMetadataMapper();
        DataChangeRecordAction dataChangeRecordAction = this.actionFactory.dataChangeRecordAction(this.throughputEstimator);
        HeartbeatRecordAction heartbeatRecordAction = this.actionFactory.heartbeatRecordAction(this.metrics);
        ChildPartitionsRecordAction childPartitionsRecordAction = this.actionFactory.childPartitionsRecordAction(partitionMetadataDao, this.metrics);
        PartitionStartRecordAction partitionStartRecordAction = this.actionFactory.partitionStartRecordAction(partitionMetadataDao, this.metrics);
        PartitionEndRecordAction partitionEndRecordAction = this.actionFactory.partitionEndRecordAction(partitionMetadataDao, this.metrics);
        PartitionEventRecordAction partitionEventRecordAction = this.actionFactory.partitionEventRecordAction(partitionMetadataDao, this.metrics);
        this.queryChangeStreamAction = this.actionFactory.queryChangeStreamAction(changeStreamDao, partitionMetadataDao, changeStreamRecordMapper, partitionMetadataMapper, dataChangeRecordAction, heartbeatRecordAction, childPartitionsRecordAction, partitionStartRecordAction, partitionEndRecordAction, partitionEventRecordAction, this.metrics);
    }

    @DoFn.ProcessElement
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer) {
        String token = partition.getPartitionToken();
        LOG.debug("[{}] Processing element with restriction {}", (Object)token, tracker.currentRestriction());
        return this.queryChangeStreamAction.run(partition, tracker, receiver, watermarkEstimator, bundleFinalizer);
    }

    public void setThroughputEstimator(@UnknownKeyFor @NonNull @Initialized BytesThroughputEstimator<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> throughputEstimator) {
        this.throughputEstimator = throughputEstimator;
    }
}

