/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DetectNewPartitionsAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.cache.CacheFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.cache.WatermarkCache;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.DetectNewPartitionsRangeTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoFn.UnboundedPerElement
public class DetectNewPartitionsDoFn
extends DoFn<PartitionMetadata, PartitionMetadata> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1523712495885011374L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DetectNewPartitionsDoFn.class);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_RESUME_DURATION = Duration.millis((long)100L);
    private final @UnknownKeyFor @NonNull @Initialized Duration resumeDuration;
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory;
    private final @UnknownKeyFor @NonNull @Initialized ActionFactory actionFactory;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized CacheFactory cacheFactory;
    private @UnknownKeyFor @NonNull @Initialized long averagePartitionBytesSize;
    private @UnknownKeyFor @NonNull @Initialized boolean averagePartitionBytesSizeSet;
    private transient @UnknownKeyFor @NonNull @Initialized DetectNewPartitionsAction detectNewPartitionsAction;

    public DetectNewPartitionsDoFn(@UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory, @UnknownKeyFor @NonNull @Initialized ActionFactory actionFactory, @UnknownKeyFor @NonNull @Initialized CacheFactory cacheFactory, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.daoFactory = daoFactory;
        this.mapperFactory = mapperFactory;
        this.actionFactory = actionFactory;
        this.cacheFactory = cacheFactory;
        this.metrics = metrics;
        this.resumeDuration = DEFAULT_RESUME_DURATION;
        this.averagePartitionBytesSizeSet = false;
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition) {
        return new Instant((Object)partition.getStartTimestamp().toSqlTimestamp());
    }

    @DoFn.NewWatermarkEstimator
    public @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant watermarkEstimatorState) {
        return new WatermarkEstimators.Manual(watermarkEstimatorState);
    }

    @DoFn.GetInitialRestriction
    public @UnknownKeyFor @NonNull @Initialized TimestampRange initialRestriction(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition) {
        Timestamp createdAt = partition.getCreatedAt();
        return TimestampRange.of(TimestampUtils.previous(createdAt), Timestamp.MAX_VALUE);
    }

    @DoFn.GetSize
    public @UnknownKeyFor @NonNull @Initialized double getSize(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized TimestampRange restriction) {
        if (!this.averagePartitionBytesSizeSet) {
            LOG.warn("Average partition bytes size has not been initialized, GetSize will always return 0, which will interfere with autoscaling.");
        }
        Timestamp readTimestamp = restriction.getFrom();
        PartitionMetadataDao dao = this.daoFactory.getPartitionMetadataDao();
        long partitionsToSchedule = dao.countPartitionsCreatedAfter(readTimestamp);
        long sizeEstimate = partitionsToSchedule * this.averagePartitionBytesSize;
        LOG.debug("getSize() = {} ({} partitionsToSchedule * {} averagePartitionBytesSize)", new Object[]{sizeEstimate, partitionsToSchedule, this.averagePartitionBytesSize});
        return sizeEstimate;
    }

    @DoFn.NewTracker
    public @UnknownKeyFor @NonNull @Initialized DetectNewPartitionsRangeTracker newTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized TimestampRange restriction) {
        return new DetectNewPartitionsRangeTracker(restriction);
    }

    @DoFn.Setup
    public void setup() {
        PartitionMetadataDao partitionMetadataDao = this.daoFactory.getPartitionMetadataDao();
        PartitionMetadataMapper partitionMetadataMapper = this.mapperFactory.partitionMetadataMapper();
        WatermarkCache watermarkCache = this.cacheFactory.getWatermarkCache();
        this.detectNewPartitionsAction = this.actionFactory.detectNewPartitionsAction(partitionMetadataDao, partitionMetadataMapper, watermarkCache, this.metrics, this.resumeDuration);
    }

    @DoFn.ProcessElement
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        return this.detectNewPartitionsAction.run(tracker, receiver, watermarkEstimator);
    }

    public void setAveragePartitionBytesSize(@UnknownKeyFor @NonNull @Initialized long averagePartitionBytesSize) {
        this.averagePartitionBytesSize = averagePartitionBytesSize;
        this.averagePartitionBytesSizeSet = true;
    }
}

