/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.bigtable.data.v2.models.Range;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.UniqueIdGenerator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessNewPartitionsAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ProcessNewPartitionsAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime;

    public ProcessNewPartitionsAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime) {
        this.metrics = metrics;
        this.metadataTableDao = metadataTableDao;
        this.endTime = endTime;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean processNewPartition(@UnknownKeyFor @NonNull @Initialized NewPartition newPartition, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver) {
        List<Range.ByteStringRange> parentPartitions = newPartition.getParentPartitions();
        if (!ByteStringRangeHelper.coverSameKeySpace(parentPartitions, newPartition.getPartition())) {
            LOG.warn("DNP: New partition does not have all the parents: {}", (Object)newPartition);
            return false;
        }
        String uuid = UniqueIdGenerator.getNextId();
        PartitionRecord partitionRecord = new PartitionRecord(newPartition.getPartition(), newPartition.getChangeStreamContinuationTokens(), uuid, newPartition.getLowWatermark(), Collections.singletonList(newPartition), this.endTime);
        if (parentPartitions.size() > 1) {
            this.metrics.incPartitionMergeCount();
        } else {
            this.metrics.incPartitionSplitCount();
        }
        LOG.info("DNP: Outputting new partition: {}", (Object)partitionRecord);
        this.metadataTableDao.markNewPartitionForDeletion(newPartition);
        receiver.outputWithTimestamp((Object)partitionRecord, Instant.EPOCH);
        return true;
    }
}

