/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration
extends SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration {
    private final String projectId;
    private final String instanceId;
    private final String databaseId;
    private final String tableId;
    private final String query;
    private final List<String> columns;

    private AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration(@Nullable String projectId, String instanceId, String databaseId, @Nullable String tableId, @Nullable String query, @Nullable List<String> columns) {
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        this.tableId = tableId;
        this.query = query;
        this.columns = columns;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the GCP project ID.")
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
    public String getTableId() {
        return this.tableId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the SQL query to execute.")
    public String getQuery() {
        return this.query;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the columns to read from the table.")
    public List<String> getColumns() {
        return this.columns;
    }

    public String toString() {
        return "SpannerReadSchemaTransformConfiguration{projectId=" + this.projectId + ", instanceId=" + this.instanceId + ", databaseId=" + this.databaseId + ", tableId=" + this.tableId + ", query=" + this.query + ", columns=" + this.columns + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration) {
            SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration that = (SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration)o;
            return (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && this.instanceId.equals(that.getInstanceId()) && this.databaseId.equals(that.getDatabaseId()) && (this.tableId == null ? that.getTableId() == null : this.tableId.equals(that.getTableId())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && (this.columns == null ? that.getColumns() == null : this.columns.equals(that.getColumns()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.databaseId.hashCode();
        h$ *= 1000003;
        h$ ^= this.tableId == null ? 0 : this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        return h$ ^= this.columns == null ? 0 : this.columns.hashCode();
    }

    static final class Builder
    extends SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder {
        private String projectId;
        private String instanceId;
        private String databaseId;
        private String tableId;
        private String query;
        private List<String> columns;

        Builder() {
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setInstanceId(String instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("Null instanceId");
            }
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setDatabaseId(String databaseId) {
            if (databaseId == null) {
                throw new NullPointerException("Null databaseId");
            }
            this.databaseId = databaseId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setTableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setColumns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration build() {
            if (this.instanceId == null || this.databaseId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.instanceId == null) {
                    missing.append(" instanceId");
                }
                if (this.databaseId == null) {
                    missing.append(" databaseId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration(this.projectId, this.instanceId, this.databaseId, this.tableId, this.query, this.columns);
        }
    }
}

