/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubIO_Read;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubIO_Write;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubJsonClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessagePayloadOnlyCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubsubIO {
    private static final Logger LOG = LoggerFactory.getLogger(PubsubIO.class);
    private static final PubsubClient.PubsubClientFactory FACTORY = PubsubJsonClient.FACTORY;
    private static final Pattern PROJECT_ID_REGEXP = Pattern.compile("[a-z][-a-z0-9:.]{4,61}[a-z0-9]");
    private static final Pattern SUBSCRIPTION_REGEXP = Pattern.compile("projects/([^/]+)/subscriptions/(.+)");
    private static final Pattern TOPIC_REGEXP = Pattern.compile("projects/([^/]+)/topics/(.+)");
    private static final Pattern V1BETA1_SUBSCRIPTION_REGEXP = Pattern.compile("/subscriptions/([^/]+)/(.+)");
    private static final Pattern V1BETA1_TOPIC_REGEXP = Pattern.compile("/topics/([^/]+)/(.+)");
    private static final Pattern PUBSUB_NAME_REGEXP = Pattern.compile("[a-zA-Z][-._~%+a-zA-Z0-9]+");
    private static final int PUBSUB_NAME_MIN_LENGTH = 3;
    private static final int PUBSUB_NAME_MAX_LENGTH = 255;
    private static final String SUBSCRIPTION_RANDOM_TEST_PREFIX = "_random/";
    private static final String SUBSCRIPTION_STARTING_SIGNAL = "_starting_signal/";
    private static final String TOPIC_DEV_NULL_TEST_NAME = "/topics/dev/null";

    private static void validateProjectName(String project) {
        Matcher match = PROJECT_ID_REGEXP.matcher(project);
        if (!match.matches()) {
            throw new IllegalArgumentException("Illegal project name specified in Pubsub subscription: " + project);
        }
    }

    private static void validatePubsubName(String name) {
        if (name.length() < 3) {
            throw new IllegalArgumentException("Pubsub object name is shorter than 3 characters: " + name);
        }
        if (name.length() > 255) {
            throw new IllegalArgumentException("Pubsub object name is longer than 255 characters: " + name);
        }
        if (name.startsWith("goog")) {
            throw new IllegalArgumentException("Pubsub object name cannot start with goog: " + name);
        }
        Matcher match = PUBSUB_NAME_REGEXP.matcher(name);
        if (!match.matches()) {
            throw new IllegalArgumentException("Illegal Pubsub object name specified: " + name + " Please see Javadoc for naming rules.");
        }
    }

    private static void populateCommonDisplayData(DisplayData.Builder builder, String timestampAttribute, String idAttribute, ValueProvider<PubsubTopic> topic) {
        builder.addIfNotNull(DisplayData.item((String)"timestampAttribute", (String)timestampAttribute).withLabel("Timestamp Attribute")).addIfNotNull(DisplayData.item((String)"idAttribute", (String)idAttribute).withLabel("ID Attribute")).addIfNotNull(DisplayData.item((String)"topic", topic).withLabel("Pubsub Topic"));
    }

    private static <T> Read<T> read() {
        return new AutoValue_PubsubIO_Read.Builder().setNeedsAttributes(false).build();
    }

    public static Read<PubsubMessage> readMessages() {
        return new AutoValue_PubsubIO_Read.Builder().setCoder(PubsubMessagePayloadOnlyCoder.of()).setParseFn(new IdentityMessageFn()).setNeedsAttributes(false).build();
    }

    public static Read<PubsubMessage> readMessagesWithAttributes() {
        return new AutoValue_PubsubIO_Read.Builder().setCoder(PubsubMessageWithAttributesCoder.of()).setParseFn(new IdentityMessageFn()).setNeedsAttributes(true).build();
    }

    public static Read<String> readStrings() {
        return PubsubIO.read().withCoderAndParseFn((Coder)StringUtf8Coder.of(), new ParsePayloadAsUtf8());
    }

    public static <T extends Message> Read<T> readProtos(Class<T> messageClass) {
        ProtoCoder coder = ProtoCoder.of(messageClass);
        return ((Read)PubsubIO.read()).withCoderAndParseFn((Coder)coder, new ParsePayloadUsingCoder(coder));
    }

    public static <T> Read<T> readAvros(Class<T> clazz) {
        AvroCoder coder = AvroCoder.of(clazz);
        return ((Read)PubsubIO.read()).withCoderAndParseFn((Coder)coder, new ParsePayloadUsingCoder(coder));
    }

    private static <T> Write<T> write() {
        return new AutoValue_PubsubIO_Write.Builder().build();
    }

    public static Write<PubsubMessage> writeMessages() {
        return PubsubIO.write().withFormatFn(new IdentityMessageFn());
    }

    public static Write<String> writeStrings() {
        return PubsubIO.write().withFormatFn(new FormatPayloadAsUtf8());
    }

    public static <T extends Message> Write<T> writeProtos(Class<T> messageClass) {
        return ((Write)PubsubIO.write()).withFormatFn(new FormatPayloadUsingCoder(ProtoCoder.of(messageClass)));
    }

    public static <T> Write<T> writeAvros(Class<T> clazz) {
        return ((Write)PubsubIO.write()).withFormatFn(new FormatPayloadUsingCoder(AvroCoder.of(clazz)));
    }

    private PubsubIO() {
    }

    private static class IdentityMessageFn
    extends SimpleFunction<PubsubMessage, PubsubMessage> {
        private IdentityMessageFn() {
        }

        public PubsubMessage apply(PubsubMessage input) {
            return input;
        }
    }

    private static class FormatPayloadUsingCoder<T>
    extends SimpleFunction<T, PubsubMessage> {
        private Coder<T> coder;

        public FormatPayloadUsingCoder(Coder<T> coder) {
            this.coder = coder;
        }

        public PubsubMessage apply(T input) {
            try {
                return new PubsubMessage(CoderUtils.encodeToByteArray(this.coder, input), (Map<String, String>)ImmutableMap.of());
            }
            catch (CoderException e) {
                throw new RuntimeException("Could not decode Pubsub message", e);
            }
        }
    }

    private static class FormatPayloadAsUtf8
    extends SimpleFunction<String, PubsubMessage> {
        private FormatPayloadAsUtf8() {
        }

        public PubsubMessage apply(String input) {
            return new PubsubMessage(input.getBytes(StandardCharsets.UTF_8), (Map<String, String>)ImmutableMap.of());
        }
    }

    private static class ParsePayloadUsingCoder<T>
    extends SimpleFunction<PubsubMessage, T> {
        private Coder<T> coder;

        public ParsePayloadUsingCoder(Coder<T> coder) {
            this.coder = coder;
        }

        public T apply(PubsubMessage input) {
            try {
                return (T)CoderUtils.decodeFromByteArray(this.coder, (byte[])input.getPayload());
            }
            catch (CoderException e) {
                throw new RuntimeException("Could not decode Pubsub message", e);
            }
        }
    }

    private static class ParsePayloadAsUtf8
    extends SimpleFunction<PubsubMessage, String> {
        private ParsePayloadAsUtf8() {
        }

        public String apply(PubsubMessage input) {
            return new String(input.getPayload(), StandardCharsets.UTF_8);
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract ValueProvider<PubsubTopic> getTopicProvider();

        @Nullable
        abstract String getTimestampAttribute();

        @Nullable
        abstract String getIdAttribute();

        @Nullable
        abstract SimpleFunction<T, PubsubMessage> getFormatFn();

        abstract Builder<T> toBuilder();

        public Write<T> to(String topic) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)topic));
        }

        public Write<T> to(ValueProvider<String> topic) {
            return this.toBuilder().setTopicProvider((ValueProvider<PubsubTopic>)ValueProvider.NestedValueProvider.of(topic, (SerializableFunction)new TopicTranslator())).build();
        }

        public Write<T> withTimestampAttribute(String timestampAttribute) {
            return this.toBuilder().setTimestampAttribute(timestampAttribute).build();
        }

        public Write<T> withIdAttribute(String idAttribute) {
            return this.toBuilder().setIdAttribute(idAttribute).build();
        }

        private Write<T> withFormatFn(SimpleFunction<T, PubsubMessage> formatFn) {
            return this.toBuilder().setFormatFn(formatFn).build();
        }

        public PDone expand(PCollection<T> input) {
            if (this.getTopicProvider() == null) {
                throw new IllegalStateException("need to set the topic of a PubsubIO.Write transform");
            }
            switch (input.isBounded()) {
                case BOUNDED: {
                    input.apply((PTransform)ParDo.of((DoFn)new PubsubBoundedWriter()));
                    return PDone.in((Pipeline)input.getPipeline());
                }
                case UNBOUNDED: {
                    return (PDone)((PCollection)input.apply((PTransform)MapElements.via(this.getFormatFn()))).apply((PTransform)new PubsubUnboundedSink(FACTORY, (ValueProvider<PubsubClient.TopicPath>)ValueProvider.NestedValueProvider.of(this.getTopicProvider(), (SerializableFunction)new TopicPathTranslator()), this.getTimestampAttribute(), this.getIdAttribute(), 100));
                }
            }
            throw new RuntimeException();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            PubsubIO.populateCommonDisplayData(builder, this.getTimestampAttribute(), this.getIdAttribute(), (ValueProvider<PubsubTopic>)this.getTopicProvider());
        }

        public class PubsubBoundedWriter
        extends DoFn<T, Void> {
            private static final int MAX_PUBLISH_BATCH_SIZE = 100;
            private transient List<PubsubClient.OutgoingMessage> output;
            private transient PubsubClient pubsubClient;

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext c) throws IOException {
                this.output = new ArrayList<PubsubClient.OutgoingMessage>();
                this.pubsubClient = FACTORY.newClient(Write.this.getTimestampAttribute(), null, (PubsubOptions)c.getPipelineOptions().as(PubsubOptions.class));
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                PubsubMessage message = (PubsubMessage)Write.this.getFormatFn().apply(c.element());
                byte[] payload = message.getPayload();
                Map<String, String> attributes = message.getAttributeMap();
                this.output.add(new PubsubClient.OutgoingMessage(payload, attributes, c.timestamp().getMillis(), null));
                if (this.output.size() >= 100) {
                    this.publish();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() throws IOException {
                if (!this.output.isEmpty()) {
                    this.publish();
                }
                this.output = null;
                this.pubsubClient.close();
                this.pubsubClient = null;
            }

            private void publish() throws IOException {
                PubsubTopic topic = (PubsubTopic)Write.this.getTopicProvider().get();
                int n = this.pubsubClient.publish(PubsubClient.topicPathFromName(topic.project, topic.topic), this.output);
                Preconditions.checkState((n == this.output.size() ? 1 : 0) != 0);
                this.output.clear();
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.delegate((HasDisplayData)Write.this);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setTopicProvider(ValueProvider<PubsubTopic> var1);

            abstract Builder<T> setTimestampAttribute(String var1);

            abstract Builder<T> setIdAttribute(String var1);

            abstract Builder<T> setFormatFn(SimpleFunction<T, PubsubMessage> var1);

            abstract Write<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract ValueProvider<PubsubTopic> getTopicProvider();

        @Nullable
        abstract ValueProvider<PubsubSubscription> getSubscriptionProvider();

        @Nullable
        abstract String getTimestampAttribute();

        @Nullable
        abstract String getIdAttribute();

        @Nullable
        abstract Coder<T> getCoder();

        @Nullable
        abstract SimpleFunction<PubsubMessage, T> getParseFn();

        abstract boolean getNeedsAttributes();

        abstract Builder<T> toBuilder();

        public Read<T> fromSubscription(String subscription) {
            return this.fromSubscription((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)subscription));
        }

        public Read<T> fromSubscription(ValueProvider<String> subscription) {
            if (subscription.isAccessible()) {
                PubsubSubscription.fromPath((String)subscription.get());
            }
            return this.toBuilder().setSubscriptionProvider((ValueProvider<PubsubSubscription>)ValueProvider.NestedValueProvider.of(subscription, (SerializableFunction)new SubscriptionTranslator())).build();
        }

        public Read<T> fromTopic(String topic) {
            return this.fromTopic((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)topic));
        }

        public Read<T> fromTopic(ValueProvider<String> topic) {
            if (topic.isAccessible()) {
                PubsubTopic.fromPath((String)topic.get());
            }
            return this.toBuilder().setTopicProvider((ValueProvider<PubsubTopic>)ValueProvider.NestedValueProvider.of(topic, (SerializableFunction)new TopicTranslator())).build();
        }

        public Read<T> withTimestampAttribute(String timestampAttribute) {
            return this.toBuilder().setTimestampAttribute(timestampAttribute).build();
        }

        public Read<T> withIdAttribute(String idAttribute) {
            return this.toBuilder().setIdAttribute(idAttribute).build();
        }

        private Read<T> withCoderAndParseFn(Coder<T> coder, SimpleFunction<PubsubMessage, T> parseFn) {
            return this.toBuilder().setCoder(coder).setParseFn(parseFn).build();
        }

        public PCollection<T> expand(PBegin input) {
            if (this.getTopicProvider() == null && this.getSubscriptionProvider() == null) {
                throw new IllegalStateException("Need to set either the topic or the subscription for a PubsubIO.Read transform");
            }
            if (this.getTopicProvider() != null && this.getSubscriptionProvider() != null) {
                throw new IllegalStateException("Can't set both the topic and the subscription for a PubsubIO.Read transform");
            }
            ValueProvider.NestedValueProvider topicPath = this.getTopicProvider() == null ? null : ValueProvider.NestedValueProvider.of(this.getTopicProvider(), (SerializableFunction)new TopicPathTranslator());
            ValueProvider.NestedValueProvider subscriptionPath = this.getSubscriptionProvider() == null ? null : ValueProvider.NestedValueProvider.of(this.getSubscriptionProvider(), (SerializableFunction)new SubscriptionPathTranslator());
            PubsubUnboundedSource source = new PubsubUnboundedSource(FACTORY, null, (ValueProvider<PubsubClient.TopicPath>)topicPath, (ValueProvider<PubsubClient.SubscriptionPath>)subscriptionPath, this.getTimestampAttribute(), this.getIdAttribute(), this.getNeedsAttributes());
            return ((PCollection)((PCollection)input.apply((PTransform)source)).apply((PTransform)MapElements.via(this.getParseFn()))).setCoder(this.getCoder());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            PubsubIO.populateCommonDisplayData(builder, this.getTimestampAttribute(), this.getIdAttribute(), (ValueProvider<PubsubTopic>)this.getTopicProvider());
            builder.addIfNotNull(DisplayData.item((String)"subscription", this.getSubscriptionProvider()).withLabel("Pubsub Subscription"));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setTopicProvider(ValueProvider<PubsubTopic> var1);

            abstract Builder<T> setSubscriptionProvider(ValueProvider<PubsubSubscription> var1);

            abstract Builder<T> setTimestampAttribute(String var1);

            abstract Builder<T> setIdAttribute(String var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setParseFn(SimpleFunction<PubsubMessage, T> var1);

            abstract Builder<T> setNeedsAttributes(boolean var1);

            abstract Read<T> build();
        }
    }

    public static class PubsubTopic
    implements Serializable {
        private final Type type;
        private final String project;
        private final String topic;

        private PubsubTopic(Type type, String project, String topic) {
            this.type = type;
            this.project = project;
            this.topic = topic;
        }

        public static PubsubTopic fromPath(String path) {
            String topicName;
            String projectName;
            if (path.equals(PubsubIO.TOPIC_DEV_NULL_TEST_NAME)) {
                return new PubsubTopic(Type.FAKE, "", path);
            }
            Matcher v1beta1Match = V1BETA1_TOPIC_REGEXP.matcher(path);
            if (v1beta1Match.matches()) {
                LOG.warn("Saw topic in v1beta1 format.  Topics should be in the format projects/<project_id>/topics/<topic_name>");
                projectName = v1beta1Match.group(1);
                topicName = v1beta1Match.group(2);
            } else {
                Matcher match = TOPIC_REGEXP.matcher(path);
                if (!match.matches()) {
                    throw new IllegalArgumentException("Pubsub topic is not in projects/<project_id>/topics/<topic_name> format: " + path);
                }
                projectName = match.group(1);
                topicName = match.group(2);
            }
            PubsubIO.validateProjectName(projectName);
            PubsubIO.validatePubsubName(topicName);
            return new PubsubTopic(Type.NORMAL, projectName, topicName);
        }

        @Deprecated
        public String asV1Beta1Path() {
            if (this.type == Type.NORMAL) {
                return "/topics/" + this.project + "/" + this.topic;
            }
            return this.topic;
        }

        @Deprecated
        public String asV1Beta2Path() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/topics/" + this.topic;
            }
            return this.topic;
        }

        public String asPath() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/topics/" + this.topic;
            }
            return this.topic;
        }

        public String toString() {
            return this.asPath();
        }

        private static enum Type {
            NORMAL,
            FAKE;

        }
    }

    private static class ProjectPathTranslator
    implements SerializableFunction<PubsubSubscription, PubsubClient.ProjectPath> {
        private ProjectPathTranslator() {
        }

        public PubsubClient.ProjectPath apply(PubsubSubscription from) {
            return PubsubClient.projectPathFromId(from.project);
        }
    }

    private static class TopicPathTranslator
    implements SerializableFunction<PubsubTopic, PubsubClient.TopicPath> {
        private TopicPathTranslator() {
        }

        public PubsubClient.TopicPath apply(PubsubTopic from) {
            return PubsubClient.topicPathFromName(from.project, from.topic);
        }
    }

    private static class TopicTranslator
    implements SerializableFunction<String, PubsubTopic> {
        private TopicTranslator() {
        }

        public PubsubTopic apply(String from) {
            return PubsubTopic.fromPath(from);
        }
    }

    private static class SubscriptionPathTranslator
    implements SerializableFunction<PubsubSubscription, PubsubClient.SubscriptionPath> {
        private SubscriptionPathTranslator() {
        }

        public PubsubClient.SubscriptionPath apply(PubsubSubscription from) {
            return PubsubClient.subscriptionPathFromName(from.project, from.subscription);
        }
    }

    private static class SubscriptionTranslator
    implements SerializableFunction<String, PubsubSubscription> {
        private SubscriptionTranslator() {
        }

        public PubsubSubscription apply(String from) {
            return PubsubSubscription.fromPath(from);
        }
    }

    public static class PubsubSubscription
    implements Serializable {
        private final Type type;
        private final String project;
        private final String subscription;

        private PubsubSubscription(Type type, String project, String subscription) {
            this.type = type;
            this.project = project;
            this.subscription = subscription;
        }

        public static PubsubSubscription fromPath(String path) {
            String subscriptionName;
            String projectName;
            if (path.startsWith(PubsubIO.SUBSCRIPTION_RANDOM_TEST_PREFIX) || path.startsWith(PubsubIO.SUBSCRIPTION_STARTING_SIGNAL)) {
                return new PubsubSubscription(Type.FAKE, "", path);
            }
            Matcher v1beta1Match = V1BETA1_SUBSCRIPTION_REGEXP.matcher(path);
            if (v1beta1Match.matches()) {
                LOG.warn("Saw subscription in v1beta1 format. Subscriptions should be in the format projects/<project_id>/subscriptions/<subscription_name>");
                projectName = v1beta1Match.group(1);
                subscriptionName = v1beta1Match.group(2);
            } else {
                Matcher match = SUBSCRIPTION_REGEXP.matcher(path);
                if (!match.matches()) {
                    throw new IllegalArgumentException("Pubsub subscription is not in projects/<project_id>/subscriptions/<subscription_name> format: " + path);
                }
                projectName = match.group(1);
                subscriptionName = match.group(2);
            }
            PubsubIO.validateProjectName(projectName);
            PubsubIO.validatePubsubName(subscriptionName);
            return new PubsubSubscription(Type.NORMAL, projectName, subscriptionName);
        }

        @Deprecated
        public String asV1Beta1Path() {
            if (this.type == Type.NORMAL) {
                return "/subscriptions/" + this.project + "/" + this.subscription;
            }
            return this.subscription;
        }

        @Deprecated
        public String asV1Beta2Path() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/subscriptions/" + this.subscription;
            }
            return this.subscription;
        }

        public String asPath() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/subscriptions/" + this.subscription;
            }
            return this.subscription;
        }

        public String toString() {
            return this.asPath();
        }

        private static enum Type {
            NORMAL,
            FAKE;

        }
    }
}

