/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.arrow.ArrowConversion;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.metrics.StringSet;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQueryStorageSourceBase<@UnknownKeyFor T>
extends BoundedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageSourceBase.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_SPLIT_COUNT = 10000;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_SPLIT_COUNT = 10;
    protected final @Nullable @UnknownKeyFor @Initialized DataFormat format;
    protected final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFieldsProvider;
    protected final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestrictionProvider;
    protected final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
    protected final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder;
    protected final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;

    BigQueryStorageSourceBase(@Nullable @UnknownKeyFor @Initialized DataFormat format, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFieldsProvider, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestrictionProvider, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        this.format = format;
        this.selectedFieldsProvider = selectedFieldsProvider;
        this.rowRestrictionProvider = rowRestrictionProvider;
        this.parseFn = (SerializableFunction)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
    }

    protected abstract @Nullable @UnknownKeyFor @Initialized Table getTargetTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    protected abstract @Nullable @UnknownKeyFor @Initialized String getTargetTableId(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        org.apache.avro.Schema sessionSchema;
        ReadSession readSession;
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        @Nullable Table targetTable = this.getTargetTable(bqOptions);
        ReadSession.Builder readSessionBuilder = ReadSession.newBuilder();
        StringSet lineageSources = Lineage.getSources();
        if (targetTable != null) {
            TableReference tableReference = targetTable.getTableReference();
            readSessionBuilder.setTable(BigQueryHelpers.toTableResourceName(tableReference));
            lineageSources.add(BigQueryHelpers.dataCatalogName(tableReference, bqOptions));
        } else {
            @Nullable String tableReferenceId = this.getTargetTableId(bqOptions);
            if (tableReferenceId != null) {
                readSessionBuilder.setTable(tableReferenceId);
                TableReference tableReference = BigQueryHelpers.parseTableUrn(tableReferenceId);
                lineageSources.add(BigQueryHelpers.dataCatalogName(tableReference, bqOptions));
            }
        }
        if (this.selectedFieldsProvider != null || this.rowRestrictionProvider != null) {
            ReadSession.TableReadOptions.Builder tableReadOptionsBuilder = ReadSession.TableReadOptions.newBuilder();
            if (this.selectedFieldsProvider != null) {
                tableReadOptionsBuilder.addAllSelectedFields((Iterable)this.selectedFieldsProvider.get());
            }
            if (this.rowRestrictionProvider != null) {
                tableReadOptionsBuilder.setRowRestriction((String)this.rowRestrictionProvider.get());
            }
            readSessionBuilder.setReadOptions(tableReadOptionsBuilder);
        }
        if (this.format != null) {
            readSessionBuilder.setDataFormat(this.format);
        }
        int streamCount = 0;
        if (!bqOptions.getEnableStorageReadApiV2().booleanValue()) {
            if (desiredBundleSizeBytes > 0L) {
                long tableSizeBytes = targetTable != null ? targetTable.getNumBytes() : 0L;
                streamCount = (int)Math.min(tableSizeBytes / desiredBundleSizeBytes, 10000L);
            }
            streamCount = Math.max(streamCount, 10);
        }
        CreateReadSessionRequest createReadSessionRequest = CreateReadSessionRequest.newBuilder().setParent(BigQueryHelpers.toProjectResourceName(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject())).setReadSession(readSessionBuilder).setMaxStreamCount(streamCount).build();
        try (BigQueryServices.StorageClient client = this.bqServices.getStorageClient(bqOptions);){
            readSession = client.createReadSession(createReadSessionRequest);
            LOG.info("Sent BigQuery Storage API CreateReadSession request '{}'; received response '{}'.", (Object)createReadSessionRequest, (Object)readSession);
        }
        if (readSession.getStreamsList().isEmpty()) {
            LOG.info("Returned stream list is empty. The underlying table is empty or all rows have been pruned.");
            return ImmutableList.of();
        }
        LOG.info("Read session returned {} streams", (Object)readSession.getStreamsList().size());
        if (readSession.getDataFormat() == DataFormat.ARROW) {
            org.apache.arrow.vector.types.pojo.Schema schema = ArrowConversion.arrowSchemaFromInput((InputStream)readSession.getArrowSchema().getSerializedSchema().newInput());
            Schema beamSchema = ArrowConversion.ArrowSchemaTranslator.toBeamSchema((org.apache.arrow.vector.types.pojo.Schema)schema);
            sessionSchema = AvroUtils.toAvroSchema((Schema)beamSchema);
        } else if (readSession.getDataFormat() == DataFormat.AVRO) {
            sessionSchema = new Schema.Parser().parse(readSession.getAvroSchema().getSchema());
        } else {
            throw new IllegalArgumentException("data is not in a supported dataFormat: " + readSession.getDataFormat());
        }
        Preconditions.checkStateNotNull((Object)targetTable);
        TableSchema trimmedSchema = BigQueryAvroUtils.trimBigQueryTableSchema(targetTable.getSchema(), sessionSchema);
        ArrayList sources = Lists.newArrayList();
        for (ReadStream readStream : readSession.getStreamsList()) {
            sources.add(BigQueryStorageStreamSource.create(readSession, readStream, trimmedSchema, this.parseFn, this.outputCoder, this.bqServices));
        }
        return ImmutableList.copyOf((Collection)sources);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("BigQuery storage source must be split before reading");
    }
}

