/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryStorageWriteApiSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration
extends BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration {
    private final String table;
    private final String createDisposition;
    private final String writeDisposition;
    private final Long triggeringFrequencySeconds;
    private final Boolean useAtLeastOnceSemantics;
    private final Boolean autoSharding;
    private final Integer numStreams;
    private final BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.ErrorHandling errorHandling;

    private AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration(String table, @Nullable String createDisposition, @Nullable String writeDisposition, @Nullable Long triggeringFrequencySeconds, @Nullable Boolean useAtLeastOnceSemantics, @Nullable Boolean autoSharding, @Nullable Integer numStreams, @Nullable BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.ErrorHandling errorHandling) {
        this.table = table;
        this.createDisposition = createDisposition;
        this.writeDisposition = writeDisposition;
        this.triggeringFrequencySeconds = triggeringFrequencySeconds;
        this.useAtLeastOnceSemantics = useAtLeastOnceSemantics;
        this.autoSharding = autoSharding;
        this.numStreams = numStreams;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="The bigquery table to write to. Format: [${PROJECT}:]${DATASET}.${TABLE}")
    public String getTable() {
        return this.table;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Optional field that specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED (the job may create the table), CREATE_NEVER (the job must fail if the table does not exist already).")
    public String getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE (overwrites the table data), WRITE_APPEND (append the data to the table), WRITE_EMPTY (job must fail if the table is not empty).")
    public String getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Determines how often to 'commit' progress into BigQuery. Default is every 5 seconds.")
    public Long getTriggeringFrequencySeconds() {
        return this.triggeringFrequencySeconds;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option enables lower latency for insertions to BigQuery but may ocassionally duplicate data elements.")
    public Boolean getUseAtLeastOnceSemantics() {
        return this.useAtLeastOnceSemantics;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option enables using a dynamically determined number of Storage Write API streams to write to BigQuery. Only applicable to unbounded data.")
    public Boolean getAutoSharding() {
        return this.autoSharding;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the number of write streams that the Storage API sink will use. This parameter is only applicable when writing unbounded data.")
    public Integer getNumStreams() {
        return this.numStreams;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "BigQueryStorageWriteApiSchemaTransformConfiguration{table=" + this.table + ", createDisposition=" + this.createDisposition + ", writeDisposition=" + this.writeDisposition + ", triggeringFrequencySeconds=" + this.triggeringFrequencySeconds + ", useAtLeastOnceSemantics=" + this.useAtLeastOnceSemantics + ", autoSharding=" + this.autoSharding + ", numStreams=" + this.numStreams + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration) {
            BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration that = (BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration)o;
            return this.table.equals(that.getTable()) && (this.createDisposition == null ? that.getCreateDisposition() == null : this.createDisposition.equals(that.getCreateDisposition())) && (this.writeDisposition == null ? that.getWriteDisposition() == null : this.writeDisposition.equals(that.getWriteDisposition())) && (this.triggeringFrequencySeconds == null ? that.getTriggeringFrequencySeconds() == null : this.triggeringFrequencySeconds.equals(that.getTriggeringFrequencySeconds())) && (this.useAtLeastOnceSemantics == null ? that.getUseAtLeastOnceSemantics() == null : this.useAtLeastOnceSemantics.equals(that.getUseAtLeastOnceSemantics())) && (this.autoSharding == null ? that.getAutoSharding() == null : this.autoSharding.equals(that.getAutoSharding())) && (this.numStreams == null ? that.getNumStreams() == null : this.numStreams.equals(that.getNumStreams())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.table.hashCode();
        h$ *= 1000003;
        h$ ^= this.createDisposition == null ? 0 : this.createDisposition.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeDisposition == null ? 0 : this.writeDisposition.hashCode();
        h$ *= 1000003;
        h$ ^= this.triggeringFrequencySeconds == null ? 0 : this.triggeringFrequencySeconds.hashCode();
        h$ *= 1000003;
        h$ ^= this.useAtLeastOnceSemantics == null ? 0 : this.useAtLeastOnceSemantics.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoSharding == null ? 0 : this.autoSharding.hashCode();
        h$ *= 1000003;
        h$ ^= this.numStreams == null ? 0 : this.numStreams.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder {
        private String table;
        private String createDisposition;
        private String writeDisposition;
        private Long triggeringFrequencySeconds;
        private Boolean useAtLeastOnceSemantics;
        private Boolean autoSharding;
        private Integer numStreams;
        private BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setTable(String table) {
            if (table == null) {
                throw new NullPointerException("Null table");
            }
            this.table = table;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setCreateDisposition(String createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setWriteDisposition(String writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setTriggeringFrequencySeconds(Long triggeringFrequencySeconds) {
            this.triggeringFrequencySeconds = triggeringFrequencySeconds;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setUseAtLeastOnceSemantics(Boolean useAtLeastOnceSemantics) {
            this.useAtLeastOnceSemantics = useAtLeastOnceSemantics;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setAutoSharding(Boolean autoSharding) {
            this.autoSharding = autoSharding;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setNumStreams(Integer numStreams) {
            this.numStreams = numStreams;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.Builder setErrorHandling(BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration.ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public BigQueryStorageWriteApiSchemaTransformProvider.BigQueryStorageWriteApiSchemaTransformConfiguration build() {
            if (this.table == null) {
                String missing = " table";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration(this.table, this.createDisposition, this.writeDisposition, this.triggeringFrequencySeconds, this.useAtLeastOnceSemantics, this.autoSharding, this.numStreams, this.errorHandling);
        }
    }
}

