/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.TimestampRange;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class BigtableWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<BigtableWriteSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "input";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration> configurationClass() {
        return BigtableWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration configuration) {
        return new BigtableWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigtable_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    public static class GetMutationsFromBeamRow
    extends SimpleFunction<Row, KV<ByteString, Iterable<Mutation>>> {
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            ByteString key = ByteString.copyFrom((byte[])Optional.ofNullable(row.getBytes("key")).get());
            List beamRowMutations = (List)Optional.ofNullable(row.getArray("mutations")).get();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(beamRowMutations.size());
            for (Map mutation : beamRowMutations) {
                Mutation bigtableMutation;
                switch (new String(Optional.ofNullable((byte[])mutation.get("type")).get(), StandardCharsets.UTF_8)) {
                    case "SetCell": {
                        Mutation.SetCell.Builder setMutation = Mutation.SetCell.newBuilder().setValue(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("value")).get())).setColumnQualifier(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("column_qualifier")).get())).setFamilyNameBytes(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("family_name")).get())).setTimestampMicros(mutation.containsKey("timestamp_micros") ? Longs.fromByteArray((byte[])Optional.ofNullable((byte[])mutation.get("timestamp_micros")).get()) : -1L);
                        bigtableMutation = Mutation.newBuilder().setSetCell(setMutation.build()).build();
                        break;
                    }
                    case "DeleteFromColumn": {
                        Mutation.DeleteFromColumn.Builder deleteMutation = Mutation.DeleteFromColumn.newBuilder().setColumnQualifier(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("column_qualifier")).get())).setFamilyNameBytes(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("family_name")).get()));
                        if (mutation.containsKey("start_timestamp_micros") || mutation.containsKey("end_timestamp_micros")) {
                            TimestampRange.Builder timeRange = TimestampRange.newBuilder();
                            if (mutation.containsKey("start_timestamp_micros")) {
                                Long startMicros = ByteBuffer.wrap(Optional.ofNullable((byte[])mutation.get("start_timestamp_micros")).get()).getLong();
                                timeRange.setStartTimestampMicros(startMicros.longValue());
                            }
                            if (mutation.containsKey("end_timestamp_micros")) {
                                Long endMicros = ByteBuffer.wrap(Optional.ofNullable((byte[])mutation.get("end_timestamp_micros")).get()).getLong();
                                timeRange.setEndTimestampMicros(endMicros.longValue());
                            }
                            deleteMutation.setTimeRange(timeRange.build());
                        }
                        bigtableMutation = Mutation.newBuilder().setDeleteFromColumn(deleteMutation.build()).build();
                        break;
                    }
                    case "DeleteFromFamily": {
                        bigtableMutation = Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyNameBytes(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("family_name")).get())).build()).build();
                        break;
                    }
                    case "DeleteFromRow": {
                        bigtableMutation = Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.newBuilder().build()).build();
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Unexpected mutation type [%s]: %s", Arrays.toString(Optional.ofNullable((byte[])mutation.get("type")).get()), mutation));
                    }
                }
                mutations.add(bigtableMutation);
            }
            return KV.of((Object)key, mutations);
        }
    }

    private static class BigtableWriteSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration configuration;

        BigtableWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.has(BigtableWriteSchemaTransformProvider.INPUT_TAG), (Object)String.format("Could not find expected input [%s] to %s.", BigtableWriteSchemaTransformProvider.INPUT_TAG, ((Object)((Object)this)).getClass().getSimpleName()));
            PCollection beamRowMutations = input.get(BigtableWriteSchemaTransformProvider.INPUT_TAG);
            PCollection bigtableMutations = (PCollection)beamRowMutations.apply((PTransform)MapElements.via((SimpleFunction)new GetMutationsFromBeamRow()));
            bigtableMutations.apply((PTransform)BigtableIO.write().withTableId(this.configuration.getTableId()).withInstanceId(this.configuration.getInstanceId()).withProjectId(this.configuration.getProjectId()));
            return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigtableWriteSchemaTransformConfiguration {
        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration.Builder();
        }

        public void validate() {
            String invalidConfigMessage = "Invalid Bigtable Write configuration: %s should be a non-empty String";
            Preconditions.checkArgument((!this.getTableId().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "table"));
            Preconditions.checkArgument((!this.getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "instance"));
            Preconditions.checkArgument((!this.getProjectId().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "project"));
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTableId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getProjectId();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration build();
        }
    }
}

