/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import java.time.Instant;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Queues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

class RetryManager<@UnknownKeyFor ResultT, @UnknownKeyFor ContextT extends @UnknownKeyFor @NonNull @Initialized Operation.Context<ResultT>> {
    private @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Operation<ResultT, ContextT>> operations = Queues.newArrayDeque();
    private final @UnknownKeyFor @NonNull @Initialized BackOff backoff;
    private static final @UnknownKeyFor @NonNull @Initialized ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("BeamBQRetryManager-%d").build());

    RetryManager(@UnknownKeyFor @NonNull @Initialized Duration initialBackoff, @UnknownKeyFor @NonNull @Initialized Duration maxBackoff, @UnknownKeyFor @NonNull @Initialized int maxRetries) {
        this.backoff = FluentBackoff.DEFAULT.withInitialBackoff(initialBackoff).withMaxBackoff(maxBackoff).withMaxRetries(maxRetries).backoff();
    }

    RetryManager(@UnknownKeyFor @NonNull @Initialized Duration initialBackoff, @UnknownKeyFor @NonNull @Initialized Duration maxBackoff, @UnknownKeyFor @NonNull @Initialized int maxRetries, @UnknownKeyFor @NonNull @Initialized Counter throttledTimeCounter) {
        this.backoff = FluentBackoff.DEFAULT.withInitialBackoff(initialBackoff).withMaxBackoff(maxBackoff).withMaxRetries(maxRetries).withThrottledTimeCounter(throttledTimeCounter).backoff();
    }

    void addOperation(@UnknownKeyFor @NonNull @Initialized Function<ContextT, @UnknownKeyFor @NonNull @Initialized ApiFuture<ResultT>> runOperation, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Iterable<ContextT>, @UnknownKeyFor @NonNull @Initialized RetryType> onError, @UnknownKeyFor @NonNull @Initialized Consumer<ContextT> onSuccess, ContextT context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.addOperation(runOperation, onError, onSuccess, r -> true, context);
    }

    void addOperation(@UnknownKeyFor @NonNull @Initialized Function<ContextT, @UnknownKeyFor @NonNull @Initialized ApiFuture<ResultT>> runOperation, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Iterable<ContextT>, @UnknownKeyFor @NonNull @Initialized RetryType> onError, @UnknownKeyFor @NonNull @Initialized Consumer<ContextT> onSuccess, @UnknownKeyFor @NonNull @Initialized Function<ResultT, @UnknownKeyFor @NonNull @Initialized Boolean> hasSucceeded, ContextT context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.addOperation(new Operation<ResultT, ContextT>(runOperation, onError, onSuccess, hasSucceeded, context));
    }

    void addAndRunOperation(@UnknownKeyFor @NonNull @Initialized Function<ContextT, @UnknownKeyFor @NonNull @Initialized ApiFuture<ResultT>> runOperation, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Iterable<ContextT>, @UnknownKeyFor @NonNull @Initialized RetryType> onError, @UnknownKeyFor @NonNull @Initialized Consumer<ContextT> onSuccess, ContextT context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.addAndRunOperation(new Operation<Object, ContextT>(runOperation, onError, onSuccess, r -> true, context));
    }

    void addAndRunOperation(@UnknownKeyFor @NonNull @Initialized Function<ContextT, @UnknownKeyFor @NonNull @Initialized ApiFuture<ResultT>> runOperation, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Iterable<ContextT>, @UnknownKeyFor @NonNull @Initialized RetryType> onError, @UnknownKeyFor @NonNull @Initialized Consumer<ContextT> onSuccess, @UnknownKeyFor @NonNull @Initialized Function<ResultT, @UnknownKeyFor @NonNull @Initialized Boolean> hasSucceeded, ContextT context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.addAndRunOperation(new Operation<ResultT, ContextT>(runOperation, onError, onSuccess, hasSucceeded, context));
    }

    void addOperation(@UnknownKeyFor @NonNull @Initialized Operation<ResultT, ContextT> operation) {
        this.operations.add(operation);
    }

    void addAndRunOperation(@UnknownKeyFor @NonNull @Initialized Operation<ResultT, ContextT> operation) {
        operation.run(executor);
        this.operations.add(operation);
    }

    void run(@UnknownKeyFor @NonNull @Initialized boolean await) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Operation operation : this.operations) {
            operation.run(executor);
        }
        if (await) {
            this.await();
        }
    }

    void await() throws @UnknownKeyFor @NonNull @Initialized Exception {
        while (!this.operations.isEmpty()) {
            Operation<ResultT, ContextT> operation = this.operations.element();
            boolean failed = operation.await();
            Callback callback = ((Operation)operation).callback;
            if (callback != null) {
                ((Operation.Context)operation.context).setOperationEndTime(callback.getOperationEndTime());
            }
            if (failed) {
                Throwable failure = ((Callback)Preconditions.checkStateNotNull((Object)((Operation)operation).callback)).getFailure();
                ((Operation.Context)operation.context).setError(failure);
                RetryType retryType = (RetryType)((Object)((Operation)operation).onError.apply((Iterable)this.operations.stream().map(o -> o.context).collect(Collectors.toList())));
                if (retryType == RetryType.DONT_RETRY) {
                    this.operations.clear();
                    continue;
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((RetryType.RETRY_ALL_OPERATIONS == retryType ? 1 : 0) != 0);
                if (!BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)this.backoff)) {
                    throw new RuntimeException(failure);
                }
                for (Operation operation2 : this.operations) {
                    operation2.await();
                }
                this.run(false);
                continue;
            }
            ((Operation.Context)operation.context).setResult((Object)((ApiFuture)Preconditions.checkStateNotNull((Object)((Operation)operation).future)).get());
            ((Operation)operation).onSuccess.accept(operation.context);
            this.operations.remove();
        }
    }

    private static class Callback<@UnknownKeyFor ResultT>
    implements ApiFutureCallback<ResultT> {
        private final @UnknownKeyFor @NonNull @Initialized CountDownLatch waiter = new CountDownLatch(1);
        private final @UnknownKeyFor @NonNull @Initialized Function<ResultT, @UnknownKeyFor @NonNull @Initialized Boolean> hasSucceeded;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable failure = null;
        @UnknownKeyFor @NonNull @Initialized boolean failed = false;
        @Nullable
        @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant operationEndTime = null;

        Callback(@UnknownKeyFor @NonNull @Initialized Function<ResultT, @UnknownKeyFor @NonNull @Initialized Boolean> hasSucceeded) {
            this.hasSucceeded = hasSucceeded;
        }

        void await() throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.waiter.await();
        }

        @UnknownKeyFor @NonNull @Initialized boolean await(@UnknownKeyFor @NonNull @Initialized long timeoutSec) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            return this.waiter.await(timeoutSec, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            Callback callback = this;
            synchronized (callback) {
                this.operationEndTime = Instant.now();
                this.failure = t;
                this.failed = true;
            }
            this.waiter.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(ResultT result) {
            Callback callback = this;
            synchronized (callback) {
                this.operationEndTime = Instant.now();
                if (this.hasSucceeded.apply(result).booleanValue()) {
                    this.failure = null;
                } else {
                    this.failure = new WrappedFailure(result);
                    this.failed = true;
                }
            }
            this.waiter.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable getFailure() {
            Callback callback = this;
            synchronized (callback) {
                return this.failure;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnknownKeyFor @NonNull @Initialized boolean getFailed() {
            Callback callback = this;
            synchronized (callback) {
                return this.failed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant getOperationEndTime() {
            Callback callback = this;
            synchronized (callback) {
                return this.operationEndTime;
            }
        }
    }

    static class Operation<@UnknownKeyFor ResultT, @UnknownKeyFor ContextT extends @UnknownKeyFor @NonNull @Initialized Context<ResultT>> {
        private final @UnknownKeyFor @NonNull @Initialized Function<ContextT, @UnknownKeyFor @NonNull @Initialized ApiFuture<ResultT>> runOperation;
        private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Iterable<ContextT>, @UnknownKeyFor @NonNull @Initialized RetryType> onError;
        private final @UnknownKeyFor @NonNull @Initialized Consumer<ContextT> onSuccess;
        private final @UnknownKeyFor @NonNull @Initialized Function<ResultT, @UnknownKeyFor @NonNull @Initialized Boolean> hasSucceeded;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ApiFuture<ResultT> future = null;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Callback<ResultT> callback = null;
        ContextT context;

        public Operation(@UnknownKeyFor @NonNull @Initialized Function<ContextT, @UnknownKeyFor @NonNull @Initialized ApiFuture<ResultT>> runOperation, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Iterable<ContextT>, @UnknownKeyFor @NonNull @Initialized RetryType> onError, @UnknownKeyFor @NonNull @Initialized Consumer<ContextT> onSuccess, @UnknownKeyFor @NonNull @Initialized Function<ResultT, @UnknownKeyFor @NonNull @Initialized Boolean> hasSucceeded, ContextT context) {
            this.runOperation = runOperation;
            this.onError = onError;
            this.onSuccess = onSuccess;
            this.hasSucceeded = hasSucceeded;
            this.context = context;
        }

        void run(@UnknownKeyFor @NonNull @Initialized Executor executor) {
            ((Context)this.context).setOperationStartTime(Instant.now());
            ((Context)this.context).setOperationEndTime(null);
            this.future = this.runOperation.apply(this.context);
            this.callback = new Callback<ResultT>(this.hasSucceeded);
            ApiFutures.addCallback(this.future, this.callback, (Executor)executor);
        }

        @UnknownKeyFor @NonNull @Initialized boolean await() throws @UnknownKeyFor @NonNull @Initialized Exception {
            Callback callback = (Callback)Preconditions.checkStateNotNull(this.callback);
            callback.await();
            return callback.getFailed();
        }

        static class Context<@UnknownKeyFor ResultT> {
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable error = null;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable ResultT result = null;
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant operationStartTime = null;
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant operationEndTime = null;

            Context() {
            }

            public void setError(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable error) {
                this.error = error;
            }

            @Nullable
            public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable getError() {
                return this.error;
            }

            public void setResult(@Nullable @org.checkerframework.checker.nullness.qual.Nullable ResultT result) {
                this.result = result;
            }

            @Nullable
            public @org.checkerframework.checker.nullness.qual.Nullable ResultT getResult() {
                return this.result;
            }

            public void setOperationStartTime(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant operationStartTime) {
                this.operationStartTime = operationStartTime;
            }

            @Nullable
            public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant getOperationStartTime() {
                return this.operationStartTime;
            }

            public void setOperationEndTime(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant operationEndTime) {
                this.operationEndTime = operationEndTime;
            }

            @Nullable
            public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant getOperationEndTime() {
                return this.operationEndTime;
            }
        }
    }

    static class WrappedFailure
    extends Throwable {
        @Nullable
        private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object result;

        public WrappedFailure(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object result) {
            this.result = result;
        }

        @Nullable
        @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object getResult() {
            return this.result;
        }
    }

    static enum RetryType {
        DONT_RETRY,
        RETRY_ALL_OPERATIONS;

    }
}

