/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessorFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PerSubscriptionPartitionSdf
extends DoFn<SubscriptionPartition, SequencedMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PerSubscriptionPartitionSdf.class);
    private final @UnknownKeyFor @NonNull @Initialized ManagedFactory<@UnknownKeyFor @NonNull @Initialized TopicBacklogReader> backlogReaderFactory;
    private final @UnknownKeyFor @NonNull @Initialized ManagedFactory<@UnknownKeyFor @NonNull @Initialized BlockingCommitter> committerFactory;
    private final @UnknownKeyFor @NonNull @Initialized SubscriptionPartitionProcessorFactory processorFactory;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition, @UnknownKeyFor @NonNull @Initialized InitialOffsetReader> offsetReaderFactory;
    private final @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TopicBacklogReader, @UnknownKeyFor @NonNull @Initialized OffsetByteRange, @UnknownKeyFor @NonNull @Initialized TrackerWithProgress> trackerFactory;

    PerSubscriptionPartitionSdf(@UnknownKeyFor @NonNull @Initialized ManagedFactory<@UnknownKeyFor @NonNull @Initialized TopicBacklogReader> backlogReaderFactory, @UnknownKeyFor @NonNull @Initialized ManagedFactory<@UnknownKeyFor @NonNull @Initialized BlockingCommitter> committerFactory, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition, @UnknownKeyFor @NonNull @Initialized InitialOffsetReader> offsetReaderFactory, @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TopicBacklogReader, @UnknownKeyFor @NonNull @Initialized OffsetByteRange, @UnknownKeyFor @NonNull @Initialized TrackerWithProgress> trackerFactory, @UnknownKeyFor @NonNull @Initialized SubscriptionPartitionProcessorFactory processorFactory) {
        this.backlogReaderFactory = backlogReaderFactory;
        this.committerFactory = committerFactory;
        this.processorFactory = processorFactory;
        this.offsetReaderFactory = offsetReaderFactory;
        this.trackerFactory = trackerFactory;
    }

    @DoFn.Teardown
    public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (ManagedFactory<BlockingCommitter> c1 = this.committerFactory;){
            ManagedFactory<TopicBacklogReader> c2 = this.backlogReaderFactory;
            Throwable throwable = null;
            if (c2 != null) {
                if (throwable != null) {
                    try {
                        c2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    c2.close();
                }
            }
        }
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkState(@DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant elementTimestamp) {
        return elementTimestamp;
    }

    @DoFn.NewWatermarkEstimator
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WatermarkEstimators.MonotonicallyIncreasing newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant state) {
        return new WatermarkEstimators.MonotonicallyIncreasing(state);
    }

    @DoFn.ProcessElement
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetByteRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker, @DoFn.Element @UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.debug("Starting process for {} at {}", (Object)subscriptionPartition, (Object)Instant.now());
        SubscriptionPartitionProcessor processor = this.processorFactory.newProcessor(subscriptionPartition, tracker, receiver);
        DoFn.ProcessContinuation result = processor.run();
        LOG.debug("Starting commit for {} at {}", (Object)subscriptionPartition, (Object)Instant.now());
        processor.lastClaimed().ifPresent(lastClaimed -> {
            try {
                this.committerFactory.create(subscriptionPartition).commitOffset(Offset.of((long)(lastClaimed.value() + 1L)));
            }
            catch (Exception e) {
                throw ExtractStatus.toCanonical((Throwable)e).underlying;
            }
        });
        LOG.debug("Finishing process for {} at {}", (Object)subscriptionPartition, (Object)Instant.now());
        return result;
    }

    @DoFn.GetInitialRestriction
    public @UnknownKeyFor @NonNull @Initialized OffsetByteRange getInitialRestriction(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        Offset offset = ((InitialOffsetReader)this.offsetReaderFactory.apply((Object)subscriptionPartition)).read();
        return OffsetByteRange.of(new OffsetRange(offset.value(), Long.MAX_VALUE));
    }

    @DoFn.NewTracker
    public @UnknownKeyFor @NonNull @Initialized TrackerWithProgress newTracker(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetByteRange range) {
        return (TrackerWithProgress)((Object)this.trackerFactory.apply((Object)this.backlogReaderFactory.create(subscriptionPartition), (Object)range));
    }

    @DoFn.GetSize
    public @UnknownKeyFor @NonNull @Initialized double getSize(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetByteRange restriction) {
        if (restriction.getRange().getTo() != Long.MAX_VALUE) {
            return restriction.getByteCount();
        }
        return this.newTracker(subscriptionPartition, restriction).getProgress().getWorkRemaining();
    }
}

