/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadAll;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationCellCounter;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroupEncoder;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadSpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SerializedMutation;
import org.apache.beam.sdk.io.gcp.spanner.SerializedMutationCoder;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.ApproximateQuantiles;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SpannerIO {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerIO.class);
    private static final long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;
    private static final int DEFAULT_MAX_NUM_MUTATIONS = 5000;
    private static final long MAX_NUM_KEYS = 1000000L;
    private static final int DEFAULT_NUM_SAMPLES = 1000;

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setReadOperation(ReadOperation.create()).setBatching(true).build();
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static ReadAll readAll() {
        return new AutoValue_SpannerIO_ReadAll.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setBatching(true).build();
    }

    @Experimental
    public static CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    @Experimental
    public static Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).setMaxNumMutations(5000L).setNumSamples(1000).setFailureMode(FailureMode.FAIL_FAST).build();
    }

    private SpannerIO() {
    }

    private static class WriteToSpannerFn
    extends DoFn<Iterable<MutationGroup>, Void> {
        private transient SpannerAccessor spannerAccessor;
        private final SpannerConfig spannerConfig;
        private final FailureMode failureMode;
        private final TupleTag<MutationGroup> failedTag;

        WriteToSpannerFn(SpannerConfig spannerConfig, FailureMode failureMode, TupleTag<MutationGroup> failedTag) {
            this.spannerConfig = spannerConfig;
            this.failureMode = failureMode;
            this.failedTag = failedTag;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = this.spannerConfig.connectToSpanner();
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Iterable mutations = (Iterable)c.element();
            boolean tryIndividual = false;
            try {
                Iterable batch = Iterables.concat((Iterable)mutations);
                this.spannerAccessor.getDatabaseClient().writeAtLeastOnce(batch);
            }
            catch (SpannerException e) {
                if (this.failureMode == FailureMode.REPORT_FAILURES) {
                    tryIndividual = true;
                }
                if (this.failureMode == FailureMode.FAIL_FAST) {
                    throw e;
                }
                throw new IllegalArgumentException("Unknown failure mode " + (Object)((Object)this.failureMode));
            }
            if (tryIndividual) {
                for (MutationGroup mg : mutations) {
                    try {
                        this.spannerAccessor.getDatabaseClient().writeAtLeastOnce((Iterable)mg);
                    }
                    catch (SpannerException e) {
                        LOG.warn("Failed to submit the mutation group", (Throwable)e);
                        c.output(this.failedTag, (Object)mg);
                    }
                }
            }
        }
    }

    private static class BatchFn
    extends DoFn<KV<String, Iterable<SerializedMutation>>, Iterable<MutationGroup>> {
        private final long maxBatchSizeBytes;
        private final long maxNumMutations;
        private final SpannerConfig spannerConfig;
        private final PCollectionView<SpannerSchema> schemaView;
        private transient SpannerAccessor spannerAccessor;
        private transient ImmutableList.Builder<MutationGroup> batch;
        private long batchSizeBytes;
        private long batchCells;

        private BatchFn(long maxBatchSizeBytes, long maxNumMutations, SpannerConfig spannerConfig, PCollectionView<SpannerSchema> schemaView) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            this.maxNumMutations = maxNumMutations;
            this.spannerConfig = spannerConfig;
            this.schemaView = schemaView;
        }

        @DoFn.Setup
        public void setup() {
            this.batch = ImmutableList.builder();
            this.batchSizeBytes = 0L;
            this.batchCells = 0L;
            this.spannerAccessor = this.spannerConfig.connectToSpanner();
        }

        @DoFn.Teardown
        public void teardown() {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            MutationGroupEncoder mutationGroupEncoder = new MutationGroupEncoder(spannerSchema);
            KV element = (KV)c.element();
            for (SerializedMutation kv : (Iterable)element.getValue()) {
                byte[] value = kv.getMutationGroupBytes();
                MutationGroup mg = mutationGroupEncoder.decode(value);
                long groupSize = MutationSizeEstimator.sizeOf(mg);
                long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
                if (this.batchCells + groupCells > this.maxNumMutations || this.batchSizeBytes + groupSize > this.maxBatchSizeBytes) {
                    ImmutableList mutations = this.batch.build();
                    c.output((Object)mutations);
                    this.batch = ImmutableList.builder();
                    this.batchSizeBytes = 0L;
                    this.batchCells = 0L;
                }
                this.batch.add((Object)mg);
                this.batchSizeBytes += groupSize;
                this.batchCells += groupCells;
            }
            ImmutableList mutations = this.batch.build();
            if (!mutations.isEmpty()) {
                c.output((Object)mutations);
                this.batch = ImmutableList.builder();
                this.batchSizeBytes = 0L;
                this.batchCells = 0L;
            }
        }
    }

    private static class AssignPartitionFn
    extends DoFn<SerializedMutation, KV<String, SerializedMutation>> {
        final PCollectionView<Map<String, List<byte[]>>> sampleView;

        public AssignPartitionFn(PCollectionView<Map<String, List<byte[]>>> sampleView) {
            this.sampleView = sampleView;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String groupKey;
            Map sample = (Map)c.sideInput(this.sampleView);
            SerializedMutation g = (SerializedMutation)c.element();
            String table = g.getTableName().toLowerCase();
            byte[] key = g.getEncodedKey();
            if (key.length == 0) {
                groupKey = UUID.randomUUID().toString();
            } else {
                int partition = Collections.binarySearch((List)sample.get(table), key, SerializableBytesComparator.INSTANCE);
                if (partition < 0) {
                    partition = -partition - 1;
                }
                groupKey = table + "%" + partition;
            }
            c.output((Object)KV.of((Object)groupKey, (Object)g));
        }
    }

    private static class ExtractKeys
    extends DoFn<SerializedMutation, KV<String, byte[]>> {
        private ExtractKeys() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            SerializedMutation m = (SerializedMutation)c.element();
            c.output((Object)KV.of((Object)m.getTableName().toLowerCase(), (Object)m.getEncodedKey()));
        }
    }

    private static class SerializeMutationsFn
    extends DoFn<MutationGroup, SerializedMutation> {
        final PCollectionView<SpannerSchema> schemaView;

        private SerializeMutationsFn(PCollectionView<SpannerSchema> schemaView) {
            this.schemaView = schemaView;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            byte[] key;
            MutationGroup g = (MutationGroup)c.element();
            Mutation m = g.primary();
            SpannerSchema schema = (SpannerSchema)c.sideInput(this.schemaView);
            String table = m.getTable();
            MutationGroupEncoder mutationGroupEncoder = new MutationGroupEncoder(schema);
            if (m.getOperation() != Mutation.Op.DELETE) {
                key = mutationGroupEncoder.encodeKey(m);
            } else if (MutationUtils.isPointDelete(m)) {
                Key next = (Key)m.getKeySet().getKeys().iterator().next();
                key = mutationGroupEncoder.encodeKey(m.getTable(), next);
            } else {
                key = new byte[]{};
            }
            byte[] value = mutationGroupEncoder.encode(g);
            c.output((Object)SerializedMutation.create(table, key, value));
        }
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, SpannerWriteResult> {
        private final Write spec;

        public WriteGrouped(Write spec) {
            this.spec = spec;
        }

        public SpannerWriteResult expand(PCollection<MutationGroup> input) {
            PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> sampler = this.spec.getSampler();
            if (sampler == null) {
                sampler = this.createDefaultSampler();
            }
            PCollectionView schemaView = (PCollectionView)((PCollection)((PCollection)((PCollection)input.getPipeline().apply("Create seed", (PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply((PTransform)Wait.on((PCollection[])new PCollection[]{input}))).apply("Read information schema", (PTransform)ParDo.of((DoFn)new ReadSpannerSchema(this.spec.getSpannerConfig())))).apply("Schema View", (PTransform)View.asSingleton());
            PCollection serialized = ((PCollection)input.apply("Serialize mutations", (PTransform)ParDo.of((DoFn)new SerializeMutationsFn(schemaView)).withSideInputs(new PCollectionView[]{schemaView}))).setCoder((Coder)SerializedMutationCoder.of());
            PCollectionView keySample = (PCollectionView)((PCollection)((PCollection)serialized.apply("Extract keys", (PTransform)ParDo.of((DoFn)new ExtractKeys()))).apply("Sample keys", sampler)).apply("Keys sample as view", (PTransform)View.asMap());
            TupleTag mainTag = new TupleTag("mainOut");
            TupleTag failedTag = new TupleTag("failedMutations");
            AssignPartitionFn assignPartitionFn = new AssignPartitionFn((PCollectionView<Map<String, List<byte[]>>>)keySample);
            PCollectionTuple result = (PCollectionTuple)((PCollection)((PCollection)((PCollection)serialized.apply("Partition input", (PTransform)ParDo.of((DoFn)assignPartitionFn).withSideInputs(new PCollectionView[]{keySample}))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)SerializedMutationCoder.of())).apply("Group by partition", (PTransform)GroupByKey.create())).apply("Batch mutations together", (PTransform)ParDo.of((DoFn)new BatchFn(this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getSpannerConfig(), schemaView)).withSideInputs(new PCollectionView[]{schemaView}))).apply("Write mutations to Spanner", (PTransform)ParDo.of((DoFn)new WriteToSpannerFn(this.spec.getSpannerConfig(), this.spec.getFailureMode(), (TupleTag<MutationGroup>)failedTag)).withOutputTags(mainTag, TupleTagList.of((TupleTag)failedTag)));
            PCollection failedMutations = result.get(failedTag);
            failedMutations.setCoder((Coder)SerializableCoder.of(MutationGroup.class));
            return new SpannerWriteResult(input.getPipeline(), (PCollection<Void>)result.get(mainTag), (PCollection<MutationGroup>)failedMutations, (TupleTag<MutationGroup>)failedTag);
        }

        private PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> createDefaultSampler() {
            return Combine.perKey((CombineFnBase.GlobalCombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)this.spec.getNumSamples(), (Comparator)SerializableBytesComparator.INSTANCE, (long)1000000L, (double)(1.0 / (double)this.spec.getNumSamples())));
        }
    }

    @VisibleForTesting
    static enum SerializableBytesComparator implements Comparator<byte[]>,
    Serializable
    {
        INSTANCE{

            @Override
            public int compare(byte[] a, byte[] b) {
                return UnsignedBytes.lexicographicalComparator().compare(a, b);
            }
        };

    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, SpannerWriteResult> {
        abstract SpannerConfig getSpannerConfig();

        abstract long getBatchSizeBytes();

        abstract long getMaxNumMutations();

        abstract int getNumSamples();

        abstract FailureMode getFailureMode();

        @Nullable
        abstract PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> getSampler();

        abstract Builder toBuilder();

        public Write withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Write withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Write withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Write withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Write withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Write withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Write withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public Write withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public Write withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        @VisibleForTesting
        Write withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        @VisibleForTesting
        Write withSampler(PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> sampler) {
            return this.toBuilder().setSampler(sampler).build();
        }

        public WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public Write withBatchSizeBytes(long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public Write withFailureMode(FailureMode failureMode) {
            return this.toBuilder().setFailureMode(failureMode).build();
        }

        public Write withMaxNumMutations(long maxNumMutations) {
            return this.toBuilder().setMaxNumMutations(maxNumMutations).build();
        }

        public SpannerWriteResult expand(PCollection<Mutation> input) {
            this.getSpannerConfig().validate();
            return (SpannerWriteResult)((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)new WriteGrouped(this));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Batch Size in Bytes"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setBatchSizeBytes(long var1);

            abstract Builder setMaxNumMutations(long var1);

            abstract Builder setNumSamples(int var1);

            abstract Builder setFailureMode(FailureMode var1);

            abstract Builder setSampler(PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> var1);

            abstract Write build();
        }
    }

    public static enum FailureMode {
        FAIL_FAST,
        REPORT_FAILURES;

    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class CreateTransaction
    extends PTransform<PBegin, PCollectionView<Transaction>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public PCollectionView<Transaction> expand(PBegin input) {
            this.getSpannerConfig().validate();
            return (PCollectionView)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this)))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public CreateTransaction withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public CreateTransaction withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public CreateTransaction withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public CreateTransaction withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public CreateTransaction withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public CreateTransaction withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public CreateTransaction withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public CreateTransaction withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public CreateTransaction withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        @VisibleForTesting
        CreateTransaction withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public CreateTransaction withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setSpannerConfig(SpannerConfig var1);

            public abstract Builder setTimestampBound(TimestampBound var1);

            public abstract CreateTransaction build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        abstract ReadOperation getReadOperation();

        @Nullable
        abstract TimestampBound getTimestampBound();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        @Nullable
        abstract PartitionOptions getPartitionOptions();

        abstract Boolean getBatching();

        abstract Builder toBuilder();

        public Read withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Read withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Read withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Read withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Read withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Read withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Read withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public Read withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public Read withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public Read withBatching(boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        @VisibleForTesting
        Read withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public Read withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public Read withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public Read withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public Read withTable(String table) {
            return this.withReadOperation(this.getReadOperation().withTable(table));
        }

        public Read withReadOperation(ReadOperation operation) {
            return this.toBuilder().setReadOperation(operation).build();
        }

        public Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public Read withColumns(List<String> columns) {
            return this.withReadOperation(this.getReadOperation().withColumns(columns));
        }

        public Read withQuery(Statement statement) {
            return this.withReadOperation(this.getReadOperation().withQuery(statement));
        }

        public Read withQuery(String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public Read withKeySet(KeySet keySet) {
            return this.withReadOperation(this.getReadOperation().withKeySet(keySet));
        }

        public Read withIndex(String index) {
            return this.withReadOperation(this.getReadOperation().withIndex(index));
        }

        public Read withPartitionOptions(PartitionOptions partitionOptions) {
            return this.withReadOperation(this.getReadOperation().withPartitionOptions(partitionOptions));
        }

        public PCollection<Struct> expand(PBegin input) {
            this.getSpannerConfig().validate();
            Preconditions.checkArgument((this.getTimestampBound() != null ? 1 : 0) != 0, (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getReadOperation().getQuery() == null) {
                if (this.getReadOperation().getTable() != null) {
                    Preconditions.checkNotNull(this.getReadOperation().getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getReadOperation().getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
            ReadAll readAll = SpannerIO.readAll().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound()).withBatching(this.getBatching()).withTransaction(this.getTransaction());
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.getReadOperation(), (Object[])new ReadOperation[0]))).apply("Execute query", (PTransform)readAll);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setReadOperation(ReadOperation var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Builder setPartitionOptions(PartitionOptions var1);

            abstract Builder setBatching(Boolean var1);

            abstract Read build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        @Nullable
        abstract TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public ReadAll withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public ReadAll withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public ReadAll withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public ReadAll withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public ReadAll withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public ReadAll withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public ReadAll withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public ReadAll withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public ReadAll withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        ReadAll withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public ReadAll withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public ReadAll withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public ReadAll withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public ReadAll withBatching(boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        abstract Boolean getBatching();

        public PCollection<Struct> expand(PCollection<ReadOperation> input) {
            PTransform readTransform = this.getBatching() != false ? BatchSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound()) : NaiveSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound());
            return (PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Cloud Spanner", readTransform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setBatching(Boolean var1);

            abstract ReadAll build();
        }
    }
}

