/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.TestBigQueryOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestBigQuery
implements TestRule {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormat.forPattern((String)"YYYY_MM_dd_HH_mm_ss_SSS");
    private TestBigQueryOptions pipelineOptions;
    private Schema schema;
    private TestPipeline resultsPipelineRule;
    private Table table;
    private BigQueryServices.DatasetService datasetService;

    public static TestBigQuery create(Schema tableSchema) {
        return new TestBigQuery((TestBigQueryOptions)TestPipeline.testingPipelineOptions().as(TestBigQueryOptions.class), tableSchema, TestPipeline.create());
    }

    private TestBigQuery(TestBigQueryOptions pipelineOptions, Schema tableSchema, TestPipeline resultsPipelineRule) {
        this.pipelineOptions = pipelineOptions;
        this.schema = tableSchema;
        this.resultsPipelineRule = resultsPipelineRule;
    }

    public Statement apply(Statement base, Description description) {
        return this.resultsPipelineRule.apply(this.testBigQuery(base, description), description);
    }

    private Statement testBigQuery(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (TestBigQuery.this.datasetService != null) {
                    throw new AssertionError((Object)("BigQuery test was not shutdown previously. Table is'" + TestBigQuery.this.table + "'. Current test: " + description.getDisplayName()));
                }
                try {
                    TestBigQuery.this.initializeBigQuery(description);
                    base.evaluate();
                }
                finally {
                    TestBigQuery.this.tearDown();
                }
            }
        };
    }

    private void initializeBigQuery(Description description) throws IOException, InterruptedException {
        this.datasetService = new BigQueryServicesImpl().getDatasetService(this.pipelineOptions);
        this.table = this.createTable(description);
    }

    private Table createTable(Description description) throws IOException, InterruptedException {
        TableReference tableReference = new TableReference().setProjectId(this.pipelineOptions.getProject()).setDatasetId(this.pipelineOptions.getTargetDataset()).setTableId(TestBigQuery.createRandomizedName(description));
        this.table = new Table().setTableReference(tableReference).setSchema(BigQueryUtils.toTableSchema(this.schema)).setDescription("Table created for " + description.getDisplayName() + " by TestBigQueryRule. Should be automatically cleaned up after test completion.");
        if (this.datasetService.getTable(tableReference) != null) {
            throw new IllegalStateException("Table '" + tableReference + "' already exists. It should have been cleaned up by the test rule.");
        }
        this.datasetService.createTable(this.table);
        return this.table;
    }

    private void tearDown() throws IOException, InterruptedException {
        if (this.datasetService == null) {
            return;
        }
        try {
            if (this.table != null) {
                this.datasetService.deleteTable(this.table.getTableReference());
            }
        }
        finally {
            this.datasetService = null;
            this.table = null;
        }
    }

    static String createRandomizedName(Description description) throws IOException {
        StringBuilder topicName = new StringBuilder();
        if (description.getClassName() != null) {
            try {
                topicName.append(Class.forName(description.getClassName()).getSimpleName()).append("_");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (description.getMethodName() != null) {
            topicName.append(description.getMethodName()).append("_");
        }
        DATETIME_FORMAT.printTo((Appendable)topicName, (ReadableInstant)Instant.now());
        return topicName.toString() + "_" + String.valueOf(Math.abs(ThreadLocalRandom.current().nextLong()));
    }

    public String tableSpec() {
        return String.format("%s:%s.%s", this.table.getTableReference().getProjectId(), this.table.getTableReference().getDatasetId(), this.table.getTableReference().getTableId());
    }

    public void assertContainsInAnyOrder(TableRow ... tableRows) {
        PAssert.that(this.readAllRowsFromBQ((Pipeline)this.resultsPipelineRule, this.tableSpec())).containsInAnyOrder(Arrays.asList(tableRows));
        this.resultsPipelineRule.run().waitUntilFinish(Duration.standardMinutes((long)5L));
    }

    private PCollection<TableRow> readAllRowsFromBQ(Pipeline pipeline, String tableSpec) {
        return (PCollection)pipeline.apply(BigQueryIO.readTableRows().from(tableSpec));
    }
}

