/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointMarkImpl
implements UnboundedSource.CheckpointMark {
    private final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(CheckpointMarkImpl.class);
    final @UnknownKeyFor @NonNull @Initialized Offset offset;
    private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized BlockingCommitter>> committer;

    CheckpointMarkImpl(@UnknownKeyFor @NonNull @Initialized Offset offset, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized BlockingCommitter> committer) {
        this.offset = offset;
        this.committer = Optional.of(committer);
    }

    private CheckpointMarkImpl(@UnknownKeyFor @NonNull @Initialized Offset offset) {
        this.offset = offset;
        this.committer = Optional.empty();
    }

    static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized CheckpointMarkImpl> coder() {
        return new AtomicCoder<CheckpointMarkImpl>(){

            public void encode(@UnknownKeyFor @NonNull @Initialized CheckpointMarkImpl value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
                VarLongCoder.of().encode(Long.valueOf(value.offset.value()), outStream);
            }

            public @UnknownKeyFor @NonNull @Initialized CheckpointMarkImpl decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new CheckpointMarkImpl(Offset.of((long)VarLongCoder.of().decode(inStream)));
            }
        };
    }

    public void finalizeCheckpoint() {
        try {
            Preconditions.checkState((boolean)this.committer.isPresent());
            this.committer.get().get().commitOffset(this.offset);
        }
        catch (Exception e) {
            this.logger.warn("Failed to finalize checkpoint.", (Throwable)e);
        }
    }
}

