/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.protobuf.ByteString;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class MetadataTableAdminDao {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_METADATA_TABLE_NAME = "__change_stream_md_table";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_INITIAL_TOKEN = "initial_continuation_token";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_PARENT_PARTITIONS = "parent_partitions";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_PARENT_LOW_WATERMARKS = "parent_low_watermarks";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_WATERMARK = "watermark";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_CONTINUATION_TOKEN = "continuation_token";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_LOCK = "lock";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_MISSING_PARTITIONS = "missing_partitions";
    public static final @UnknownKeyFor @NonNull @Initialized String CF_VERSION = "version";
    public static final @UnknownKeyFor @NonNull @Initialized String QUALIFIER_DEFAULT = "latest";
    public static final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> COLUMN_FAMILIES = ImmutableList.of((Object)"initial_continuation_token", (Object)"parent_partitions", (Object)"parent_low_watermarks", (Object)"watermark", (Object)"continuation_token", (Object)"lock", (Object)"missing_partitions", (Object)"version");
    public static final @UnknownKeyFor @NonNull @Initialized ByteString NEW_PARTITION_PREFIX = ByteString.copyFromUtf8((String)"NewPartition#");
    public static final @UnknownKeyFor @NonNull @Initialized ByteString STREAM_PARTITION_PREFIX = ByteString.copyFromUtf8((String)"StreamPartition#");
    public static final @UnknownKeyFor @NonNull @Initialized ByteString DETECT_NEW_PARTITION_SUFFIX = ByteString.copyFromUtf8((String)"DetectNewPartition");
    public static final @UnknownKeyFor @NonNull @Initialized int CURRENT_METADATA_TABLE_VERSION = 1;
    private final @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient instanceAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized String tableId;
    private final @UnknownKeyFor @NonNull @Initialized ByteString changeStreamNamePrefix;

    public MetadataTableAdminDao(@UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient, @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient instanceAdminClient, @UnknownKeyFor @NonNull @Initialized String changeStreamName, @UnknownKeyFor @NonNull @Initialized String tableId) {
        this.tableAdminClient = tableAdminClient;
        this.instanceAdminClient = instanceAdminClient;
        this.tableId = tableId;
        this.changeStreamNamePrefix = ByteString.copyFromUtf8((String)(changeStreamName + "#"));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString getChangeStreamNamePrefix() {
        return this.changeStreamNamePrefix;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableId() {
        return this.tableId;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAppProfileSingleClusterAndTransactional(@UnknownKeyFor @NonNull @Initialized String appProfileId) {
        AppProfile appProfile = this.instanceAdminClient.getAppProfile(this.tableAdminClient.getInstanceId(), appProfileId);
        if (appProfile.getPolicy() instanceof AppProfile.SingleClusterRoutingPolicy) {
            AppProfile.SingleClusterRoutingPolicy routingPolicy = (AppProfile.SingleClusterRoutingPolicy)appProfile.getPolicy();
            return routingPolicy.getAllowTransactionalWrites();
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean createMetadataTable() {
        GCRules.VersionRule gcRules = GCRules.GCRULES.maxVersions(1);
        if (this.tableAdminClient.exists(this.tableId)) {
            Table table = this.tableAdminClient.getTable(this.tableId);
            List currentCFs = table.getColumnFamilies();
            ModifyColumnFamiliesRequest request = ModifyColumnFamiliesRequest.of((String)this.tableId);
            boolean needsNewColumnFamily = false;
            for (String targetCF : COLUMN_FAMILIES) {
                boolean exists = false;
                for (ColumnFamily currentCF : currentCFs) {
                    if (!targetCF.equals(currentCF.getId())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                needsNewColumnFamily = true;
                request.addFamily(targetCF, (GCRules.GCRule)gcRules);
            }
            if (needsNewColumnFamily) {
                this.tableAdminClient.modifyFamilies(request);
            }
            return false;
        }
        CreateTableRequest createTableRequest = CreateTableRequest.of((String)this.tableId);
        for (String cf : COLUMN_FAMILIES) {
            createTableRequest.addFamily(cf, (GCRules.GCRule)gcRules);
        }
        this.tableAdminClient.createTable(createTableRequest);
        return true;
    }
}

