/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.UniqueIdGenerator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.GenerateInitialPartitionsAction;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.encoder.MetadataTableEncoder;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.reconciler.PartitionReconciler;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DetectNewPartitionsAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DetectNewPartitionsAction.class);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEBUG_WATERMARK_DELAY = Duration.standardMinutes((long)5L);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    private final @UnknownKeyFor @NonNull @Initialized GenerateInitialPartitionsAction generateInitialPartitionsAction;
    private transient @UnknownKeyFor @NonNull @Initialized PartitionReconciler partitionReconciler;

    public DetectNewPartitionsAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao, @UnknownKeyFor @NonNull @Initialized GenerateInitialPartitionsAction generateInitialPartitionsAction) {
        this.metrics = metrics;
        this.metadataTableDao = metadataTableDao;
        this.generateInitialPartitionsAction = generateInitialPartitionsAction;
    }

    private void advanceWatermark(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        if (((OffsetRange)tracker.currentRestriction()).getFrom() % 10L == 0L) {
            ServerStream<Row> rows = this.metadataTableDao.readFromMdTableStreamPartitionsWithWatermark();
            ArrayList<Range.ByteStringRange> partitions = new ArrayList<Range.ByteStringRange>();
            HashMap<Range.ByteStringRange, Instant> slowPartitions = new HashMap<Range.ByteStringRange, Instant>();
            Instant lowWatermark = Instant.ofEpochMilli((long)Long.MAX_VALUE);
            for (Row row : rows) {
                Instant watermark = MetadataTableEncoder.parseWatermarkFromRow(row);
                if (watermark == null) continue;
                if (watermark.compareTo((ReadableInstant)lowWatermark) < 0) {
                    lowWatermark = watermark;
                }
                Range.ByteStringRange partition = this.metadataTableDao.convertStreamPartitionRowKeyToPartition(row.getKey());
                partitions.add(partition);
                if (!watermark.plus((ReadableDuration)DEBUG_WATERMARK_DELAY).isBeforeNow()) continue;
                slowPartitions.put(partition, watermark);
            }
            List<Range.ByteStringRange> missingAndOverlappingPartitions = ByteStringRangeHelper.getMissingAndOverlappingPartitionsFromKeySpace(partitions);
            if (missingAndOverlappingPartitions.isEmpty()) {
                watermarkEstimator.setWatermark(lowWatermark);
                LOG.info("DNP: Updating watermark: " + watermarkEstimator.currentWatermark());
            } else {
                LOG.warn("DNP: Could not update watermark because missing {}", (Object)ByteStringRangeHelper.partitionsToString(missingAndOverlappingPartitions));
            }
            if (!slowPartitions.isEmpty()) {
                LOG.warn("DNP: Watermark is being held back by the following partitions: {}", (Object)slowPartitions.entrySet().stream().map(e -> ByteStringRangeHelper.formatByteStringRange((Range.ByteStringRange)e.getKey()) + " => " + e.getValue()).collect(Collectors.joining(", ", "{", "}")));
            }
            this.partitionReconciler.addMissingPartitions(missingAndOverlappingPartitions);
        }
    }

    private void processNewPartition(@UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteString> recordedPartitionRecords) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Range.ByteStringRange partition = this.metadataTableDao.convertNewPartitionRowKeyToPartition(row.getKey());
        this.partitionReconciler.addNewPartition(partition, row.getKey());
        ArrayList<Range.ByteStringRange> parentPartitions = new ArrayList<Range.ByteStringRange>();
        for (Object cell : row.getCells("parent_partitions")) {
            Range.ByteStringRange parentPartition = Range.ByteStringRange.toByteStringRange((ByteString)cell.getQualifier());
            parentPartitions.add(parentPartition);
        }
        if (!ByteStringRangeHelper.isSuperset(parentPartitions, partition)) {
            LOG.warn("DNP: New partition: {} does not have all the parents {}", (Object)ByteStringRangeHelper.formatByteStringRange(partition), (Object)ByteStringRangeHelper.partitionsToString(parentPartitions));
            return;
        }
        ImmutableList.Builder changeStreamContinuationTokensBuilder = ImmutableList.builder();
        for (RowCell cell : row.getCells("initial_continuation_token")) {
            ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.fromByteString((ByteString)cell.getQualifier());
            changeStreamContinuationTokensBuilder.add((Object)changeStreamContinuationToken);
        }
        ImmutableList changeStreamContinuationTokens = changeStreamContinuationTokensBuilder.build();
        if (parentPartitions.size() != changeStreamContinuationTokens.size()) {
            LOG.warn("DNP: New partition {} parent partitions count {} != continuation token count {}", new Object[]{ByteStringRangeHelper.formatByteStringRange(partition), parentPartitions.size(), changeStreamContinuationTokens.size()});
        }
        ArrayList<Long> parentLowWatermark = new ArrayList<Long>();
        for (RowCell cell : row.getCells("parent_low_watermarks")) {
            parentLowWatermark.add(Longs.fromByteArray((byte[])cell.getValue().toByteArray()));
        }
        Long lowWatermarkMilli = (Long)Collections.min(parentLowWatermark);
        Instant lowWatermark = Instant.ofEpochMilli((long)lowWatermarkMilli);
        String uid = UniqueIdGenerator.getNextId();
        PartitionRecord partitionRecord = new PartitionRecord(partition, (List<ChangeStreamContinuationToken>)changeStreamContinuationTokens, uid, lowWatermark);
        if (parentPartitions.size() > 1) {
            this.metrics.incPartitionMergeCount();
        } else {
            this.metrics.incPartitionSplitCount();
        }
        LOG.info("DNP: Split/Merge {} into {}", (Object)parentPartitions.stream().map(ByteStringRangeHelper::formatByteStringRange).collect(Collectors.joining(",", "{", "}")), (Object)ByteStringRangeHelper.formatByteStringRange(partition));
        receiver.outputWithTimestamp((Object)partitionRecord, Instant.EPOCH);
        recordedPartitionRecords.add(row.getKey());
    }

    private void processReconcilerPartitions(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, @UnknownKeyFor @NonNull @Initialized Instant startTime, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteString> recordedPartitionRecords) {
        for (Map.Entry<Range.ByteStringRange, Set<ByteString>> partitionToReconcile : this.partitionReconciler.getPartitionsToReconcile().entrySet()) {
            String uid = UniqueIdGenerator.getNextId();
            Instant reconciledTime = watermarkEstimator.currentWatermark().minus((ReadableDuration)Duration.standardMinutes((long)60L));
            if (reconciledTime.compareTo((ReadableInstant)startTime) < 0) {
                reconciledTime = startTime;
            }
            PartitionRecord partitionRecord = new PartitionRecord(partitionToReconcile.getKey(), reconciledTime, uid, reconciledTime);
            receiver.outputWithTimestamp((Object)partitionRecord, Instant.EPOCH);
            recordedPartitionRecords.addAll((Collection<ByteString>)partitionToReconcile.getValue());
            LOG.warn("DNP: Reconciling missing partition: {} and cleaning up rows {}", (Object)partitionRecord, (Object)partitionToReconcile.getValue().stream().map(rowKey -> {
                try {
                    return ByteStringRangeHelper.formatByteStringRange(this.metadataTableDao.convertNewPartitionRowKeyToPartition((ByteString)rowKey));
                }
                catch (InvalidProtocolBufferException exception) {
                    return rowKey.toStringUtf8();
                }
            }).collect(Collectors.joining(", ", "{", "}")));
        }
    }

    private void cleanUpAfterCommit(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteString> recordedPartitionRecords) {
        bundleFinalizer.afterBundleCommit(Instant.ofEpochMilli((long)Long.MAX_VALUE), () -> {
            for (ByteString rowKey : recordedPartitionRecords) {
                this.metadataTableDao.deleteRowKey(rowKey);
            }
        });
    }

    @VisibleForTesting
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation run(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer, @UnknownKeyFor @NonNull @Initialized Instant startTime) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.debug("DNP: Watermark: " + watermarkEstimator.getState());
        LOG.debug("DNP: CurrentTracker: " + ((OffsetRange)tracker.currentRestriction()).getFrom());
        if (((OffsetRange)tracker.currentRestriction()).getFrom() == 0L) {
            return this.generateInitialPartitionsAction.run(receiver, tracker, watermarkEstimator, startTime);
        }
        this.partitionReconciler = new PartitionReconciler(this.metadataTableDao);
        this.advanceWatermark(tracker, watermarkEstimator);
        if (!tracker.tryClaim((Object)((OffsetRange)tracker.currentRestriction()).getFrom())) {
            LOG.error("DNP: Couldn't continue because we failed to claim tracker: " + tracker.currentRestriction());
            return DoFn.ProcessContinuation.stop();
        }
        ArrayList<ByteString> recordedPartitionRecords = new ArrayList<ByteString>();
        ServerStream<Row> rows = this.metadataTableDao.readNewPartitions();
        for (Row row : rows) {
            this.processNewPartition(row, receiver, recordedPartitionRecords);
        }
        this.processReconcilerPartitions(receiver, watermarkEstimator, startTime, recordedPartitionRecords);
        this.cleanUpAfterCommit(bundleFinalizer, recordedPartitionRecords);
        return DoFn.ProcessContinuation.resume().withResumeDelay(Duration.standardSeconds((long)1L));
    }
}

