/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionClaimer;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionProgressChecker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionSplitter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRestrictionTracker
extends RestrictionTracker<PartitionRestriction, PartitionPosition>
implements RestrictionTracker.HasProgress {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitionRestrictionTracker.class);
    private final @UnknownKeyFor @NonNull @Initialized PartitionRestrictionSplitter splitter;
    private final @UnknownKeyFor @NonNull @Initialized PartitionRestrictionClaimer claimer;
    private final @UnknownKeyFor @NonNull @Initialized PartitionRestrictionProgressChecker progressChecker;
    protected @UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction;
    private @Nullable @UnknownKeyFor @Initialized PartitionPosition lastClaimedPosition;
    protected @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Timestamp> timeSupplier;

    public PartitionRestrictionTracker(@UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction) {
        this(restriction, new PartitionRestrictionSplitter(), new PartitionRestrictionClaimer(), new PartitionRestrictionProgressChecker());
    }

    PartitionRestrictionTracker(@UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction, @UnknownKeyFor @NonNull @Initialized PartitionRestrictionSplitter splitter, @UnknownKeyFor @NonNull @Initialized PartitionRestrictionClaimer claimer, @UnknownKeyFor @NonNull @Initialized PartitionRestrictionProgressChecker progressChecker) {
        this.splitter = splitter;
        this.claimer = claimer;
        this.restriction = restriction;
        this.progressChecker = progressChecker;
        this.timeSupplier = () -> Timestamp.now();
    }

    @VisibleForTesting
    public void setTimeSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Timestamp> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized PartitionRestriction> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        SplitResult<PartitionRestriction> splitResult = this.splitter.trySplit(fractionOfRemainder, this.lastClaimedPosition, this.restriction);
        if (splitResult != null) {
            PartitionRestriction restrictionFromSplit;
            this.restriction = restrictionFromSplit = Optional.ofNullable((PartitionRestriction)splitResult.getPrimary()).orElse(this.restriction);
        }
        return splitResult;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized PartitionPosition position) {
        boolean canClaim = this.claimer.tryClaim(this.restriction, this.lastClaimedPosition, position);
        if (canClaim) {
            this.lastClaimedPosition = position;
        }
        return canClaim;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
        String token = Optional.ofNullable(this.restriction.getMetadata()).map(PartitionRestrictionMetadata::getPartitionToken).orElse(null);
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(this.restriction, this.lastClaimedPosition);
        LOG.debug("[" + token + "] Progress is " + progress);
        return progress;
    }

    public @UnknownKeyFor @NonNull @Initialized PartitionRestriction currentRestriction() {
        return this.restriction;
    }

    public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (this.restriction.getMode() == PartitionMode.STOP) {
            return;
        }
        if (this.lastClaimedPosition != null) {
            PartitionMode currentMode = this.lastClaimedPosition.getMode();
            if (currentMode == PartitionMode.QUERY_CHANGE_STREAM) {
                Timestamp nextPosition = TimestampUtils.next(this.lastClaimedPosition.getTimestamp().get());
                if (nextPosition.compareTo(this.restriction.getEndTimestamp()) < 0) {
                    throw new IllegalStateException(String.format("Last attempted key was %s in range %s, claiming work in [%s, %s) was not attempted", nextPosition, this.restriction, nextPosition, this.restriction.getEndTimestamp()));
                }
            } else {
                Preconditions.checkState((currentMode == PartitionMode.DONE ? 1 : 0) != 0, (String)"Restriction %s does not have mode DONE", (Object)this.restriction.toString());
            }
        } else {
            throw new IllegalStateException(String.format("restriction is non-empty %s and no keys have been attempted.", this.restriction));
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized PartitionRestriction getRestriction() {
        return this.restriction;
    }

    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized PartitionPosition getLastClaimedPosition() {
        return this.lastClaimedPosition;
    }
}

