/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRestrictionClaimer {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitionRestrictionClaimer.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PartitionMode, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PartitionMode>> allowedTransitions = new HashMap<PartitionMode, Set<PartitionMode>>();

    public PartitionRestrictionClaimer() {
        this.allowedTransitions.put(PartitionMode.UPDATE_STATE, Sets.newHashSet((Object[])new PartitionMode[]{PartitionMode.UPDATE_STATE, PartitionMode.QUERY_CHANGE_STREAM}));
        this.allowedTransitions.put(PartitionMode.QUERY_CHANGE_STREAM, Sets.newHashSet((Object[])new PartitionMode[]{PartitionMode.QUERY_CHANGE_STREAM, PartitionMode.WAIT_FOR_CHILD_PARTITIONS}));
        this.allowedTransitions.put(PartitionMode.WAIT_FOR_CHILD_PARTITIONS, Sets.newHashSet((Object[])new PartitionMode[]{PartitionMode.WAIT_FOR_CHILD_PARTITIONS, PartitionMode.DONE}));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction, @Nullable @UnknownKeyFor @Initialized PartitionPosition lastClaimedPosition, @UnknownKeyFor @NonNull @Initialized PartitionPosition position) {
        boolean tryClaimResult;
        PartitionMode fromMode = Optional.ofNullable(lastClaimedPosition).map(PartitionPosition::getMode).orElse(restriction.getMode());
        PartitionMode toMode = position.getMode();
        String token = Optional.ofNullable(restriction.getMetadata()).map(PartitionRestrictionMetadata::getPartitionToken).orElse("");
        if (fromMode == PartitionMode.STOP) {
            LOG.debug("[" + token + "] Try claim from (" + restriction + "," + lastClaimedPosition + ", " + position + ") is false");
            return false;
        }
        Preconditions.checkArgument((boolean)this.allowedTransitions.getOrDefault((Object)fromMode, Collections.emptySet()).contains((Object)toMode), (String)"Invalid partition mode transition from %s to %s", (Object)((Object)fromMode), (Object)((Object)toMode));
        Preconditions.checkArgument((toMode != PartitionMode.QUERY_CHANGE_STREAM || position.getTimestamp().isPresent() ? 1 : 0) != 0, (String)"%s mode must specify a timestamp (no value sent)", (Object)((Object)toMode));
        switch (toMode) {
            case QUERY_CHANGE_STREAM: {
                Timestamp attemptedTimestamp = position.getTimestamp().get();
                Timestamp endTimestamp = Optional.ofNullable(restriction.getEndTimestamp()).orElse(Timestamp.MAX_VALUE);
                Preconditions.checkArgument((lastClaimedPosition == null || !lastClaimedPosition.getTimestamp().isPresent() || attemptedTimestamp.compareTo(lastClaimedPosition.getTimestamp().get()) >= 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (Object)position, (Object)lastClaimedPosition);
                Preconditions.checkArgument((attemptedTimestamp.compareTo(restriction.getStartTimestamp()) >= 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s before the start timestamp %s", (Object)position, (Object)restriction.getStartTimestamp().toString());
                tryClaimResult = attemptedTimestamp.compareTo(endTimestamp) < 0;
                break;
            }
            case UPDATE_STATE: 
            case WAIT_FOR_CHILD_PARTITIONS: 
            case DONE: {
                tryClaimResult = true;
                break;
            }
            case STOP: {
                throw new IllegalArgumentException("Trying to claim STOP state is invalid");
            }
            default: {
                throw new IllegalArgumentException("Unknown mode " + (Object)((Object)toMode));
            }
        }
        LOG.debug("[" + token + "] Try claim from (" + restriction + ", " + position + ") is " + tryClaimResult);
        return tryClaimResult;
    }
}

