/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Value;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.Nullable;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class PartitionMetadata
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 995720273301116075L;
    private @UnknownKeyFor @NonNull @Initialized String partitionToken;
    private @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> parentTokens;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp;
    private @UnknownKeyFor @NonNull @Initialized long heartbeatMillis;
    private @UnknownKeyFor @NonNull @Initialized State state;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp watermark;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp createdAt;
    @javax.annotation.Nullable
    @Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp scheduledAt;
    @javax.annotation.Nullable
    @Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp runningAt;
    @javax.annotation.Nullable
    @Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp finishedAt;

    private PartitionMetadata() {
    }

    public PartitionMetadata(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> parentTokens, @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp, @UnknownKeyFor @NonNull @Initialized long heartbeatMillis, @UnknownKeyFor @NonNull @Initialized State state, @UnknownKeyFor @NonNull @Initialized Timestamp watermark, @UnknownKeyFor @NonNull @Initialized Timestamp createdAt, @javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp scheduledAt, @javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp runningAt, @javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp finishedAt) {
        this.partitionToken = partitionToken;
        this.parentTokens = parentTokens;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.heartbeatMillis = heartbeatMillis;
        this.state = state;
        this.watermark = watermark;
        this.createdAt = createdAt;
        this.scheduledAt = scheduledAt;
        this.runningAt = runningAt;
        this.finishedAt = finishedAt;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPartitionToken() {
        return this.partitionToken;
    }

    public @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> getParentTokens() {
        return this.parentTokens;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized long getHeartbeatMillis() {
        return this.heartbeatMillis;
    }

    public @UnknownKeyFor @NonNull @Initialized State getState() {
        return this.state;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getWatermark() {
        return this.watermark;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getCreatedAt() {
        return this.createdAt;
    }

    @javax.annotation.Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getScheduledAt() {
        return this.scheduledAt;
    }

    @javax.annotation.Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getRunningAt() {
        return this.runningAt;
    }

    @javax.annotation.Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getFinishedAt() {
        return this.finishedAt;
    }

    public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
        return new Builder(this);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionMetadata)) {
            return false;
        }
        PartitionMetadata that = (PartitionMetadata)o;
        return this.heartbeatMillis == that.heartbeatMillis && Objects.equals(this.partitionToken, that.partitionToken) && Objects.equals(this.parentTokens, that.parentTokens) && Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.endTimestamp, that.endTimestamp) && this.state == that.state && Objects.equals(this.watermark, that.watermark) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.scheduledAt, that.scheduledAt) && Objects.equals(this.runningAt, that.runningAt) && Objects.equals(this.finishedAt, that.finishedAt);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(new Object[]{this.partitionToken, this.parentTokens, this.startTimestamp, this.endTimestamp, this.heartbeatMillis, this.state, this.watermark, this.createdAt, this.scheduledAt, this.runningAt, this.finishedAt});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionMetadata{partitionToken='" + this.partitionToken + '\'' + ", parentTokens=" + this.parentTokens + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", heartbeatMillis=" + this.heartbeatMillis + ", state=" + (Object)((Object)this.state) + ", watermark=" + this.watermark + ", createdAt=" + this.createdAt + ", scheduledAt=" + this.scheduledAt + ", runningAt=" + this.runningAt + ", finishedAt=" + this.finishedAt + '}';
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private @UnknownKeyFor @NonNull @Initialized String partitionToken;
        private @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> parentTokens;
        private @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp;
        private @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp;
        private @UnknownKeyFor @NonNull @Initialized Long heartbeatMillis;
        private @UnknownKeyFor @NonNull @Initialized State state;
        private @UnknownKeyFor @NonNull @Initialized Timestamp watermark;
        private @UnknownKeyFor @NonNull @Initialized Timestamp createdAt;
        @javax.annotation.Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp scheduledAt;
        @javax.annotation.Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp runningAt;
        @javax.annotation.Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp finishedAt;

        public Builder() {
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition) {
            this.partitionToken = partition.partitionToken;
            this.parentTokens = partition.parentTokens;
            this.startTimestamp = partition.startTimestamp;
            this.endTimestamp = partition.endTimestamp;
            this.heartbeatMillis = partition.heartbeatMillis;
            this.state = partition.state;
            this.watermark = partition.watermark;
            this.createdAt = partition.createdAt;
            this.scheduledAt = partition.scheduledAt;
            this.runningAt = partition.runningAt;
            this.finishedAt = partition.finishedAt;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setPartitionToken(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setParentTokens(@UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> parentTokens) {
            this.parentTokens = parentTokens;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setStartTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setEndTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setHeartbeatMillis(@UnknownKeyFor @NonNull @Initialized long heartbeatMillis) {
            this.heartbeatMillis = heartbeatMillis;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setState(@UnknownKeyFor @NonNull @Initialized State state) {
            this.state = state;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setWatermark(@UnknownKeyFor @NonNull @Initialized Timestamp watermark) {
            this.watermark = watermark;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setCreatedAt(@UnknownKeyFor @NonNull @Initialized Timestamp createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setScheduledAt(@javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setRunningAt(@javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp runningAt) {
            this.runningAt = runningAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setFinishedAt(@javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionMetadata build() {
            Preconditions.checkState((this.partitionToken != null ? 1 : 0) != 0, (Object)"partitionToken");
            Preconditions.checkState((this.parentTokens != null ? 1 : 0) != 0, (Object)"parentTokens");
            Preconditions.checkState((this.startTimestamp != null ? 1 : 0) != 0, (Object)"startTimestamp");
            Preconditions.checkState((this.heartbeatMillis != null ? 1 : 0) != 0, (Object)"heartbeatMillis");
            Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"state");
            Preconditions.checkState((this.watermark != null ? 1 : 0) != 0, (Object)"watermark");
            if (this.createdAt == null) {
                this.createdAt = Value.COMMIT_TIMESTAMP;
            }
            return new PartitionMetadata(this.partitionToken, this.parentTokens, this.startTimestamp, this.endTimestamp, this.heartbeatMillis, this.state, this.watermark, this.createdAt, this.scheduledAt, this.runningAt, this.finishedAt);
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    public static enum State {
        CREATED,
        SCHEDULED,
        RUNNING,
        FINISHED;

    }
}

