/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class HeartbeatRecord
implements ChangeStreamRecord {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 5331450064150969956L;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp timestamp;
    @org.apache.avro.reflect.Nullable
    private @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata;

    private HeartbeatRecord() {
    }

    public HeartbeatRecord(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata) {
        this.timestamp = timestamp;
        this.metadata = metadata;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordTimestamp() {
        return this.getTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getTimestamp() {
        return this.timestamp;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeartbeatRecord)) {
            return false;
        }
        HeartbeatRecord that = (HeartbeatRecord)o;
        return Objects.equals(this.timestamp, that.timestamp);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.timestamp);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "HeartbeatRecord{timestamp=" + this.timestamp + ", metadata=" + this.metadata + '}';
    }
}

