/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.TypeCode;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class ColumnType
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 6861617019875340414L;
    private @UnknownKeyFor @NonNull @Initialized String name;
    private @UnknownKeyFor @NonNull @Initialized TypeCode type;
    private @UnknownKeyFor @NonNull @Initialized boolean isPrimaryKey;
    private @UnknownKeyFor @NonNull @Initialized long ordinalPosition;

    private ColumnType() {
    }

    @SchemaCreate
    public ColumnType(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TypeCode type, @UnknownKeyFor @NonNull @Initialized boolean isPrimaryKey, @UnknownKeyFor @NonNull @Initialized long ordinalPosition) {
        this.name = name;
        this.type = type;
        this.isPrimaryKey = isPrimaryKey;
        this.ordinalPosition = ordinalPosition;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeCode getType() {
        return this.type;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public @UnknownKeyFor @NonNull @Initialized long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnType)) {
            return false;
        }
        ColumnType that = (ColumnType)o;
        return this.isPrimaryKey == that.isPrimaryKey && this.ordinalPosition == that.ordinalPosition && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.name, this.type, this.isPrimaryKey, this.ordinalPosition);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ColumnType{name='" + this.name + '\'' + ", type=" + this.type + ", isPrimaryKey=" + this.isPrimaryKey + ", ordinalPosition=" + this.ordinalPosition + '}';
    }
}

