/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoService(value={SchemaTransformProvider.class})
public class BigQueryStorageWriteApiSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryStorageWriteApiSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_TRIGGERING_FREQUENCY = Duration.standardSeconds((long)5L);
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    private static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ERRORS_TAG = "errors";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration> configurationClass() {
        return BigQueryStorageWriteApiSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
        return new BigQueryStorageWriteApiSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return String.format("beam:schematransform:org.apache.beam:bigquery_storage_write:v1", new Object[0]);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ERRORS_TAG);
    }

    static class BigQueryStorageWriteApiPCollectionRowTupleTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple> {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration;
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;

        BigQueryStorageWriteApiPCollectionRowTupleTransform(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        @VisibleForTesting
        public void setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.has(BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG), (String)"Missing expected input tag: %s", (Object)BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG);
            PCollection inputRows = input.get(BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG);
            BigQueryIO.Write<Row> write = this.createStorageWriteApiTransform();
            if (inputRows.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                Long triggeringFrequency = this.configuration.getTriggeringFrequencySeconds();
                write = write.withAutoSharding().withTriggeringFrequency(triggeringFrequency == null || triggeringFrequency <= 0L ? DEFAULT_TRIGGERING_FREQUENCY : Duration.standardSeconds((long)triggeringFrequency));
            }
            WriteResult result = (WriteResult)inputRows.apply(write);
            Schema errorSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"failed_row", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"error_message", (Schema.FieldType)Schema.FieldType.STRING)});
            PCollection errorRows = ((PCollection)result.getFailedStorageApiInserts().apply("Extract Errors", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)storageError -> Row.withSchema((Schema)errorSchema).withFieldValue("error_message", (Object)storageError.getErrorMessage()).withFieldValue("failed_row", (Object)storageError.getRow().toString()).build()))).setRowSchema(errorSchema);
            return PCollectionRowTuple.of((String)BigQueryStorageWriteApiSchemaTransformProvider.OUTPUT_ERRORS_TAG, (PCollection)errorRows);
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @NonNull @Initialized Row> createStorageWriteApiTransform() {
            BigQueryIO.Write.Method writeMethod = this.configuration.getUseAtLeastOnceSemantics() != null && this.configuration.getUseAtLeastOnceSemantics() != false ? BigQueryIO.Write.Method.STORAGE_API_AT_LEAST_ONCE : BigQueryIO.Write.Method.STORAGE_WRITE_API;
            BigQueryIO.Write<Row> write = BigQueryIO.write().to(this.configuration.getTable()).withMethod(writeMethod).useBeamSchema().withFormatFunction(BigQueryUtils.toTableRow());
            if (!Strings.isNullOrEmpty((String)this.configuration.getCreateDisposition())) {
                BigQueryIO.Write.CreateDisposition createDisposition = BigQueryStorageWriteApiSchemaTransformConfiguration.CREATE_DISPOSITIONS.get(this.configuration.getCreateDisposition());
                write = write.withCreateDisposition(createDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getWriteDisposition())) {
                BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryStorageWriteApiSchemaTransformConfiguration.WRITE_DISPOSITIONS.get(this.configuration.getWriteDisposition());
                write = write.withWriteDisposition(writeDisposition);
            }
            if (this.testBigQueryServices != null) {
                write = write.withTestServices(this.testBigQueryServices);
            }
            return write;
        }
    }

    private static class BigQueryStorageWriteApiSchemaTransform
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration;

        BigQueryStorageWriteApiSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return new BigQueryStorageWriteApiPCollectionRowTupleTransform(this.configuration);
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigQueryStorageWriteApiSchemaTransformConfiguration {
        static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition> CREATE_DISPOSITIONS = ImmutableMap.builder().put((Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name(), (Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).put((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name(), (Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER).build();
        static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition> WRITE_DISPOSITIONS = ImmutableMap.builder().put((Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE).put((Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY).put((Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND).build();

        public void validate() {
            String invalidConfigMessage = "Invalid BigQuery Storage Write configuration: ";
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTable()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table spec for a BigQuery Write must be specified."));
            Preconditions.checkNotNull((Object)BigQueryHelpers.parseTableSpec(this.getTable()));
            if (!Strings.isNullOrEmpty((String)this.getCreateDisposition())) {
                Preconditions.checkArgument((CREATE_DISPOSITIONS.get(this.getCreateDisposition().toUpperCase()) != null ? 1 : 0) != 0, (String)(invalidConfigMessage + "Invalid create disposition was specified. Available dispositions are: "), CREATE_DISPOSITIONS.keySet());
            }
            if (!Strings.isNullOrEmpty((String)this.getWriteDisposition())) {
                Preconditions.checkNotNull((Object)((Object)WRITE_DISPOSITIONS.get(this.getWriteDisposition().toUpperCase())), (String)(invalidConfigMessage + "Invalid write disposition was specified. Available dispositions are: "), WRITE_DISPOSITIONS.keySet());
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTable();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getCreateDisposition();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getWriteDisposition();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Long getTriggeringFrequencySeconds();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getUseAtLeastOnceSemantics();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCreateDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTriggeringFrequencySeconds(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUseAtLeastOnceSemantics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration build();
        }
    }
}

