/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class PrepareWrite<@UnknownKeyFor InputT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
extends PTransform<PCollection<InputT>, PCollection<KV<DestinationT, OutputT>>> {
    private @UnknownKeyFor @NonNull @Initialized DynamicDestinations<InputT, DestinationT> dynamicDestinations;
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> formatFunction;

    public PrepareWrite(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<InputT, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> formatFunction) {
        this.dynamicDestinations = dynamicDestinations;
        this.formatFunction = formatFunction;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<InputT, KV<DestinationT, OutputT>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @DoFn.Element InputT element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) throws @UnknownKeyFor @NonNull @Initialized IOException {
                PrepareWrite.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
                ValueInSingleWindow windowedElement = ValueInSingleWindow.of(element, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)pane);
                Object tableDestination = PrepareWrite.this.dynamicDestinations.getDestination(windowedElement);
                org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getDestination() may not return null, but %s returned null on element %s", (Object)PrepareWrite.this.dynamicDestinations, element);
                Object outputValue = PrepareWrite.this.formatFunction.apply(element);
                Preconditions.checkArgumentNotNull((Object)outputValue, (String)"formatFunction may not return null, but %s returned null on element %s", (Object)PrepareWrite.this.formatFunction, element);
                context.output((Object)KV.of(tableDestination, (Object)outputValue));
            }
        }).withSideInputs(this.dynamicDestinations.getSideInputs()));
    }
}

