/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class DicomIO {
    public static ReadStudyMetadata readStudyMetadata() {
        return new ReadStudyMetadata();
    }

    public static class ReadStudyMetadata
    extends PTransform<PCollection<String>, Result> {
        public static final TupleTag<String> METADATA = new TupleTag<String>(){};
        public static final TupleTag<String> ERROR_MESSAGE = new TupleTag<String>(){};

        private ReadStudyMetadata() {
        }

        public Result expand(PCollection<String> input) {
            return new Result((PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FetchStudyMetadataFn()).withOutputTags(METADATA, TupleTagList.of(ERROR_MESSAGE))));
        }

        static class FetchStudyMetadataFn
        extends DoFn<String, String> {
            private HealthcareApiClient dicomStore;

            FetchStudyMetadataFn() {
            }

            @DoFn.Setup
            public void instantiateHealthcareClient() throws IOException {
                if (this.dicomStore == null) {
                    this.dicomStore = new HttpHealthcareApiClient();
                }
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) {
                block2: {
                    String dicomWebPath = (String)context.element();
                    try {
                        String responseData = this.dicomStore.retrieveDicomStudyMetadata(dicomWebPath);
                        context.output(METADATA, (Object)responseData);
                    }
                    catch (IOException e) {
                        String errorMessage = e.getMessage();
                        if (errorMessage == null) break block2;
                        context.output(ERROR_MESSAGE, (Object)errorMessage);
                    }
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private PCollection<String> readResponse;
            private PCollection<String> failedReads;
            PCollectionTuple pct;

            static Result of(PCollectionTuple pct) throws IllegalArgumentException {
                if (pct.getAll().keySet().containsAll((Collection)TupleTagList.of(METADATA).and(ERROR_MESSAGE))) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the DicomIO.ReadStudyMetadata.METADATA and DicomIO.ReadStudyMetadata.ERROR_MESSAGE tuple tags");
            }

            private Result(PCollectionTuple pct) {
                this.pct = pct;
                this.readResponse = pct.get(METADATA);
                this.failedReads = pct.get(ERROR_MESSAGE);
            }

            public PCollection<String> getFailedReads() {
                return this.failedReads;
            }

            public PCollection<String> getReadResponse() {
                return this.readResponse;
            }

            public Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public Map<TupleTag<?>, PValue> expand() {
                return ImmutableMap.of(METADATA, this.readResponse);
            }

            public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
            }
        }
    }
}

