/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_BatchSpannerRead_PartitionedReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class BatchSpannerRead
extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchSpannerRead.class);

    BatchSpannerRead() {
    }

    public static BatchSpannerRead create(SpannerConfig spannerConfig, PCollectionView<Transaction> txView, TimestampBound timestampBound) {
        return new AutoValue_BatchSpannerRead(spannerConfig, txView, timestampBound);
    }

    abstract SpannerConfig getSpannerConfig();

    abstract @Nullable PCollectionView<Transaction> getTxView();

    abstract TimestampBound getTimestampBound();

    public PCollection<Struct> expand(PCollection<ReadOperation> input) {
        PCollectionView txView = this.getTxView();
        if (txView == null) {
            Pipeline begin = input.getPipeline();
            SpannerIO.CreateTransaction createTx = SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound());
            txView = (PCollectionView)begin.apply((PTransform)createTx);
        }
        return (PCollection)((PCollection)((PCollection)input.apply("Generate Partitions", (PTransform)ParDo.of((DoFn)new GeneratePartitionsFn(this.getSpannerConfig(), txView)).withSideInputs(new PCollectionView[]{txView}))).apply("Shuffle partitions", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Partitions", (PTransform)ParDo.of((DoFn)new ReadFromPartitionFn(this.getSpannerConfig(), (PCollectionView<? extends Transaction>)txView)).withSideInputs(new PCollectionView[]{txView}));
    }

    private static class ReadFromPartitionFn
    extends DoFn<PartitionedReadOperation, Struct> {
        private final SpannerConfig config;
        private final PCollectionView<? extends Transaction> txView;
        private transient SpannerAccessor spannerAccessor;
        private transient LoadingCache<ReadOperation, ServiceCallMetric> metricsForReadOperation;

        public ReadFromPartitionFn(SpannerConfig config, PCollectionView<? extends Transaction> txView) {
            this.config = config;
            this.txView = txView;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
            this.metricsForReadOperation = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<ReadOperation, ServiceCallMetric>(){

                public ServiceCallMetric load(ReadOperation op) {
                    return SpannerIO.ReadAll.buildServiceCallMetricForReadOp(config, op);
                }
            });
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
            this.metricsForReadOperation.invalidateAll();
            this.metricsForReadOperation.cleanUp();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction batchTx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            PartitionedReadOperation op = (PartitionedReadOperation)c.element();
            ServiceCallMetric serviceCallMetric = (ServiceCallMetric)this.metricsForReadOperation.get((Object)op.getReadOperation());
            try (ResultSet resultSet = batchTx.execute(op.getPartition());){
                while (resultSet.next()) {
                    Struct s = resultSet.getCurrentRowAsStruct();
                    c.output((Object)s);
                }
            }
            catch (SpannerException e) {
                serviceCallMetric.call(e.getErrorCode().getGrpcStatusCode().toString());
                LOG.error("Error while processing element", (Throwable)e);
                throw e;
            }
            serviceCallMetric.call("ok");
        }
    }

    @VisibleForTesting
    static class GeneratePartitionsFn
    extends DoFn<ReadOperation, PartitionedReadOperation> {
        private final SpannerConfig config;
        private final PCollectionView<? extends Transaction> txView;
        private transient SpannerAccessor spannerAccessor;

        public GeneratePartitionsFn(SpannerConfig config, PCollectionView<? extends Transaction> txView) {
            this.config = config;
            this.txView = txView;
            Preconditions.checkNotNull(config.getRpcPriority());
            Preconditions.checkNotNull((Object)((Options.RpcPriority)config.getRpcPriority().get()));
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            List partitions;
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction batchTx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            ReadOperation op = (ReadOperation)c.element();
            ServiceCallMetric metric = SpannerIO.ReadAll.buildServiceCallMetricForReadOp(this.config, op);
            try {
                partitions = op.getQuery() != null ? batchTx.partitionQuery(op.getPartitionOptions(), op.getQuery(), new Options.QueryOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.config.getRpcPriority().get()))}) : (op.getIndex() != null ? batchTx.partitionReadUsingIndex(op.getPartitionOptions(), op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.config.getRpcPriority().get()))}) : batchTx.partitionRead(op.getPartitionOptions(), op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.config.getRpcPriority().get()))}));
                metric.call("ok");
            }
            catch (SpannerException e) {
                metric.call(e.getErrorCode().getGrpcStatusCode().toString());
                throw e;
            }
            for (Partition p : partitions) {
                c.output((Object)PartitionedReadOperation.create(op, p));
            }
        }
    }

    @AutoValue
    protected static abstract class PartitionedReadOperation
    implements Serializable {
        protected PartitionedReadOperation() {
        }

        abstract ReadOperation getReadOperation();

        abstract Partition getPartition();

        static PartitionedReadOperation create(ReadOperation readOperation, Partition partition) {
            return new AutoValue_BatchSpannerRead_PartitionedReadOperation(readOperation, partition);
        }
    }
}

