/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.TypeCode;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;

@DefaultCoder(value=AvroCoder.class)
public class ColumnType
implements Serializable {
    private static final long serialVersionUID = 6861617019875340414L;
    private String name;
    private TypeCode type;
    private boolean isPrimaryKey;
    private long ordinalPosition;

    private ColumnType() {
    }

    @SchemaCreate
    public ColumnType(String name, TypeCode type, boolean isPrimaryKey, long ordinalPosition) {
        this.name = name;
        this.type = type;
        this.isPrimaryKey = isPrimaryKey;
        this.ordinalPosition = ordinalPosition;
    }

    public String getName() {
        return this.name;
    }

    public TypeCode getType() {
        return this.type;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnType)) {
            return false;
        }
        ColumnType that = (ColumnType)o;
        return this.isPrimaryKey == that.isPrimaryKey && this.ordinalPosition == that.ordinalPosition && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.isPrimaryKey, this.ordinalPosition);
    }

    public String toString() {
        return "ColumnType{name='" + this.name + '\'' + ", type=" + this.type + ", isPrimaryKey=" + this.isPrimaryKey + ", ordinalPosition=" + this.ordinalPosition + '}';
    }
}

