/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;

public class JsonArrayCoder
extends CustomCoder<JsonArray> {
    private static final JsonArrayCoder CODER = new JsonArrayCoder();
    private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();

    public static JsonArrayCoder of() {
        return CODER;
    }

    public void encode(JsonArray value, OutputStream outStream) throws IOException {
        STRING_CODER.encode(value.toString(), outStream);
    }

    public JsonArray decode(InputStream inStream) throws IOException {
        return JsonParser.parseString((String)STRING_CODER.decode(inStream)).getAsJsonArray();
    }
}

